
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=210 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 10:10:38','2025-04-15 10:10:38'),(2,'default','added',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Mr Nelson Mboya\"}',NULL,'2025-04-15 10:20:33','2025-04-15 10:20:33'),(3,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 10:20:41','2025-04-15 10:20:41'),(4,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:20:45','2025-04-15 10:20:45'),(5,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:22:04','2025-04-15 10:22:04'),(6,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:22:07','2025-04-15 10:22:07'),(7,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:22:49','2025-04-15 10:22:49'),(8,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:22:53','2025-04-15 10:22:53'),(9,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:50:21','2025-04-15 10:50:21'),(10,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:50:25','2025-04-15 10:50:25'),(11,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 10:59:01','2025-04-15 10:59:01'),(12,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 10:59:06','2025-04-15 10:59:06'),(13,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 12:53:09','2025-04-15 12:53:09'),(14,'default','edited',1,'App\\User',NULL,1,2,'App\\User','{\"name\":\"Mr Epimark Massawe\"}',NULL,'2025-04-15 13:03:21','2025-04-15 13:03:21'),(15,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 13:03:36','2025-04-15 13:03:36'),(16,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 14:07:32','2025-04-15 14:07:32'),(17,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 16:06:12','2025-04-15 16:06:12'),(18,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 16:27:29','2025-04-15 16:27:29'),(19,'default','added',204,'App\\Transaction',NULL,1,2,'App\\User','[]',NULL,'2025-04-15 16:42:37','2025-04-15 16:42:37'),(20,'default','edited',1,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Mr Epimark Massawe\"}',NULL,'2025-04-15 17:45:16','2025-04-15 17:45:16'),(21,'default','edited',1,'App\\User',NULL,1,2,'App\\User','{\"name\":\"Mr Epimark Massawe\"}',NULL,'2025-04-15 17:52:15','2025-04-15 17:52:15'),(22,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 17:53:10','2025-04-15 17:53:10'),(23,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 17:54:00','2025-04-15 17:54:00'),(24,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 17:54:01','2025-04-15 17:54:01'),(25,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 17:54:33','2025-04-15 17:54:33'),(26,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-15 20:34:55','2025-04-15 20:34:55'),(27,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-16 10:29:42','2025-04-16 10:29:42'),(28,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-16 10:52:17','2025-04-16 10:52:17'),(29,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-16 11:10:12','2025-04-16 11:10:13'),(30,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-16 11:13:21','2025-04-16 11:13:21'),(31,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-16 12:47:34','2025-04-16 12:47:34'),(32,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-16 13:27:01','2025-04-16 13:27:01'),(33,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-16 13:27:42','2025-04-16 13:27:42'),(34,'default','added',3,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Mr Muzamil Iddy\"}',NULL,'2025-04-16 16:11:58','2025-04-16 16:11:59'),(35,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-17 06:55:40','2025-04-17 06:55:41'),(36,'default','added',207,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-17 07:00:33','2025-04-17 07:00:34'),(37,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-17 07:24:13','2025-04-17 07:24:13'),(38,'default','added',209,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":888000}}',NULL,'2025-04-17 08:14:17','2025-04-17 08:14:17'),(39,'default','added',210,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":888000}}',NULL,'2025-04-17 08:16:54','2025-04-17 08:16:54'),(40,'default','added',211,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-17 08:38:26','2025-04-17 08:38:26'),(41,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-17 08:40:45','2025-04-17 08:40:45'),(42,'default','added',212,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720000}}',NULL,'2025-04-17 08:50:15','2025-04-17 08:50:15'),(43,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-17 08:52:37','2025-04-17 08:52:37'),(44,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-17 08:53:00','2025-04-17 08:53:00'),(45,'default','added',213,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1140000}}',NULL,'2025-04-17 08:53:09','2025-04-17 08:53:09'),(46,'default','added',214,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170000}}',NULL,'2025-04-17 08:56:30','2025-04-17 08:56:31'),(47,'default','added',215,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750000}}',NULL,'2025-04-17 09:09:13','2025-04-17 09:09:13'),(48,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-17 09:11:54','2025-04-17 09:11:54'),(49,'default','added',216,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3978000}}',NULL,'2025-04-17 09:22:10','2025-04-17 09:22:10'),(50,'default','added',217,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45000}}',NULL,'2025-04-17 09:34:13','2025-04-17 09:34:13'),(51,'default','added',218,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800000}}',NULL,'2025-04-17 09:43:58','2025-04-17 09:43:59'),(52,'default','added',219,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":690000}}',NULL,'2025-04-17 09:51:36','2025-04-17 09:51:36'),(53,'default','added',220,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8252500}}',NULL,'2025-04-17 10:30:41','2025-04-17 10:30:41'),(54,'default','added',221,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":77000}}',NULL,'2025-04-17 10:41:41','2025-04-17 10:41:42'),(55,'default','added',222,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":530000}}',NULL,'2025-04-17 10:51:22','2025-04-17 10:51:22'),(56,'default','added',223,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120000}}',NULL,'2025-04-17 11:15:43','2025-04-17 11:15:43'),(57,'default','added',224,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10967000}}',NULL,'2025-04-17 12:20:28','2025-04-17 12:20:28'),(58,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-17 17:30:04','2025-04-17 17:30:04'),(59,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-18 07:26:26','2025-04-18 07:26:26'),(60,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-18 08:16:44','2025-04-18 08:16:45'),(61,'default','added',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-18 08:25:06','2025-04-18 08:25:06'),(62,'default','added',228,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":21000000}}',NULL,'2025-04-18 08:48:36','2025-04-18 08:48:36'),(63,'default','added',229,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 08:53:58','2025-04-18 08:53:58'),(64,'default','added',231,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 09:05:37','2025-04-18 09:05:37'),(65,'default','added',233,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 09:10:15','2025-04-18 09:10:15'),(66,'default','added',235,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 09:25:26','2025-04-18 09:25:26'),(67,'default','added',237,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 09:30:50','2025-04-18 09:30:50'),(68,'default','added',240,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8595200}}',NULL,'2025-04-18 09:44:04','2025-04-18 09:44:04'),(69,'default','added',241,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 09:46:11','2025-04-18 09:46:11'),(70,'default','added',243,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 09:48:45','2025-04-18 09:48:45'),(71,'default','added',245,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 10:04:11','2025-04-18 10:04:11'),(72,'default','added',247,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 10:12:47','2025-04-18 10:12:47'),(73,'default','added',249,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 10:35:47','2025-04-18 10:35:48'),(74,'default','added',251,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 10:43:56','2025-04-18 10:43:56'),(75,'default','added',253,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 11:24:25','2025-04-18 11:24:25'),(76,'default','added',255,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 11:25:14','2025-04-18 11:25:14'),(77,'default','added',257,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 11:56:29','2025-04-18 11:56:29'),(78,'default','added',259,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 12:00:39','2025-04-18 12:00:39'),(79,'default','added',261,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 12:01:32','2025-04-18 12:01:32'),(80,'default','added',263,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 12:55:12','2025-04-18 12:55:13'),(81,'default','added',265,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":825000}}',NULL,'2025-04-18 13:18:38','2025-04-18 13:18:38'),(82,'default','added',266,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":61200000}}',NULL,'2025-04-18 13:27:32','2025-04-18 13:27:32'),(83,'default','added',267,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 13:31:14','2025-04-18 13:31:14'),(84,'default','added',269,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 13:34:46','2025-04-18 13:34:46'),(85,'default','added',271,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 13:41:39','2025-04-18 13:41:39'),(86,'default','added',273,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 13:44:14','2025-04-18 13:44:14'),(87,'default','added',275,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 13:49:18','2025-04-18 13:49:18'),(88,'default','added',277,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 14:05:32','2025-04-18 14:05:32'),(89,'default','added',279,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-18 14:19:08','2025-04-18 14:19:08'),(90,'default','added',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-18 14:37:40','2025-04-18 14:37:40'),(91,'default','added',281,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23038000}}',NULL,'2025-04-18 15:10:03','2025-04-18 15:10:03'),(92,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-18 16:41:05','2025-04-18 16:41:05'),(93,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-18 18:20:59','2025-04-18 18:20:59'),(94,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-18 19:44:45','2025-04-18 19:44:45'),(95,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2025-04-18 19:44:51','2025-04-18 19:44:51'),(96,'default','added',283,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"shipping_status\":\"shipped\",\"final_total\":20000}}',NULL,'2025-04-18 19:48:29','2025-04-18 19:48:29'),(97,'default','added',284,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":30000}}',NULL,'2025-04-18 19:51:12','2025-04-18 19:51:12'),(98,'default','edited',284,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"30000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"30000.0000\"}}',NULL,'2025-04-18 19:51:48','2025-04-18 19:51:48'),(99,'default','edited',284,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"30000.0000\"}}',NULL,'2025-04-18 19:57:37','2025-04-18 19:57:37'),(100,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-19 07:37:25','2025-04-19 07:37:26'),(101,'default','added',285,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4104000}}',NULL,'2025-04-19 07:39:48','2025-04-19 07:39:48'),(102,'default','added',286,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4287000}}',NULL,'2025-04-19 07:46:37','2025-04-19 07:46:37'),(103,'default','added',287,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17945100}}',NULL,'2025-04-19 10:10:49','2025-04-19 10:10:49'),(104,'default','added',288,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-19 11:13:25','2025-04-19 11:13:25'),(105,'default','added',290,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-19 11:27:37','2025-04-19 11:27:37'),(106,'default','added',292,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-19 11:36:29','2025-04-19 11:36:29'),(107,'default','added',294,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-19 11:41:06','2025-04-19 11:41:06'),(108,'default','added',296,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65721250}}',NULL,'2025-04-19 13:24:01','2025-04-19 13:24:01'),(109,'default','added',297,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":26600000}}',NULL,'2025-04-19 13:43:30','2025-04-19 13:43:30'),(110,'default','added',298,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-19 13:46:21','2025-04-19 13:46:21'),(111,'default','added',300,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700000}}',NULL,'2025-04-19 14:50:19','2025-04-19 14:50:19'),(112,'default','added',301,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-19 14:54:07','2025-04-19 14:54:07'),(113,'default','added',302,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2964000}}',NULL,'2025-04-19 15:11:24','2025-04-19 15:11:24'),(114,'default','added',303,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":672000}}',NULL,'2025-04-19 15:16:05','2025-04-19 15:16:06'),(115,'default','added',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-19 15:26:54','2025-04-19 15:26:54'),(116,'default','added',304,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":90000000}}',NULL,'2025-04-19 15:35:15','2025-04-19 15:35:15'),(117,'default','added',305,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-19 15:49:19','2025-04-19 15:49:19'),(118,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 16:53:41','2025-04-20 16:53:43'),(119,'default','added',307,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1780000}}',NULL,'2025-04-20 18:32:03','2025-04-20 18:32:03'),(120,'default','added',308,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":817500}}',NULL,'2025-04-20 19:37:16','2025-04-20 19:37:16'),(121,'default','added',309,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":282000}}',NULL,'2025-04-20 19:51:34','2025-04-20 19:51:34'),(122,'default','added',310,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2153000}}',NULL,'2025-04-20 20:46:54','2025-04-20 20:46:54'),(123,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-21 07:24:20','2025-04-21 07:24:20'),(124,'default','added',311,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2288000}}',NULL,'2025-04-21 07:56:05','2025-04-21 07:56:06'),(125,'default','added',312,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-21 08:17:09','2025-04-21 08:17:09'),(126,'default','added',314,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":224000}}',NULL,'2025-04-21 08:44:10','2025-04-21 08:44:10'),(127,'default','added',315,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86000}}',NULL,'2025-04-21 09:03:07','2025-04-21 09:03:07'),(128,'default','added',316,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2700000}}',NULL,'2025-04-21 09:10:09','2025-04-21 09:10:09'),(129,'default','added',317,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-21 09:20:51','2025-04-21 09:20:51'),(130,'default','added',319,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90000}}',NULL,'2025-04-21 09:30:35','2025-04-21 09:30:35'),(131,'default','added',320,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":328000}}',NULL,'2025-04-21 11:18:06','2025-04-21 11:18:07'),(132,'default','added',321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000}}',NULL,'2025-04-21 11:25:41','2025-04-21 11:25:42'),(133,'default','added',322,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":111000}}',NULL,'2025-04-21 12:16:18','2025-04-21 12:16:18'),(134,'default','added',323,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":54000}}',NULL,'2025-04-21 13:13:01','2025-04-21 13:13:01'),(135,'default','added',324,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280900}}',NULL,'2025-04-21 13:51:09','2025-04-21 13:51:09'),(136,'default','added',325,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":276500}}',NULL,'2025-04-21 14:17:41','2025-04-21 14:17:41'),(137,'default','added',326,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-21 14:43:11','2025-04-21 14:43:11'),(138,'default','added',328,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35000}}',NULL,'2025-04-21 15:17:58','2025-04-21 15:17:58'),(139,'default','added',329,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85000}}',NULL,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(140,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-21 16:55:34','2025-04-21 16:55:34'),(141,'default','added',330,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":495000}}',NULL,'2025-04-21 17:27:40','2025-04-21 17:27:40'),(142,'default','added',331,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26000}}',NULL,'2025-04-21 17:30:55','2025-04-21 17:30:55'),(143,'default','added',332,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-21 17:39:36','2025-04-21 17:39:36'),(144,'default','added',333,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-21 17:41:30','2025-04-21 17:41:30'),(145,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-04-22 04:08:59','2025-04-22 04:08:59'),(146,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 05:13:14','2025-04-22 05:13:14'),(147,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 07:03:36','2025-04-22 07:03:36'),(148,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-04-22 07:10:03','2025-04-22 07:10:03'),(149,'default','added',334,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63773000}}',NULL,'2025-04-22 08:43:20','2025-04-22 08:43:24'),(150,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2025-04-22 08:55:38','2025-04-22 08:55:38'),(151,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2025-04-22 08:57:45','2025-04-22 08:57:45'),(152,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-22 08:57:54','2025-04-22 08:57:54'),(153,'default','added',335,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":115000}}',NULL,'2025-04-22 09:06:24','2025-04-22 09:06:24'),(154,'default','added',336,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 09:26:33','2025-04-22 09:26:33'),(155,'default','added',337,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 09:28:20','2025-04-22 09:28:20'),(156,'default','added',338,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 09:30:13','2025-04-22 09:30:13'),(157,'default','added',339,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 09:32:48','2025-04-22 09:32:48'),(158,'default','added',340,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":538000}}',NULL,'2025-04-22 10:21:28','2025-04-22 10:21:29'),(159,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 10:39:09','2025-04-22 10:39:09'),(160,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 10:39:24','2025-04-22 10:39:24'),(161,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 10:39:27','2025-04-22 10:39:27'),(162,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 10:39:41','2025-04-22 10:39:41'),(163,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 10:47:19','2025-04-22 10:47:19'),(164,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 10:47:24','2025-04-22 10:47:24'),(165,'default','added',341,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":556000}}',NULL,'2025-04-22 11:04:38','2025-04-22 11:04:39'),(166,'default','added',342,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45000}}',NULL,'2025-04-22 11:15:45','2025-04-22 11:15:46'),(167,'default','payment_edited',338,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 11:17:19','2025-04-22 11:17:19'),(168,'default','payment_edited',337,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 11:17:43','2025-04-22 11:17:44'),(169,'default','payment_edited',336,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 11:18:01','2025-04-22 11:18:01'),(170,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 11:19:57','2025-04-22 11:19:57'),(171,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 11:20:06','2025-04-22 11:20:06'),(172,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 11:20:08','2025-04-22 11:20:08'),(173,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 11:20:15','2025-04-22 11:20:15'),(174,'default','added',343,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60000}}',NULL,'2025-04-22 11:42:54','2025-04-22 11:42:54'),(175,'default','edited',343,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"60000.0000\"}}',NULL,'2025-04-22 11:43:46','2025-04-22 11:43:46'),(176,'default','added',344,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180000}}',NULL,'2025-04-22 12:06:11','2025-04-22 12:06:11'),(177,'default','added',345,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":355500}}',NULL,'2025-04-22 12:44:20','2025-04-22 12:44:20'),(178,'default','added',346,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 12:55:36','2025-04-22 12:55:36'),(179,'default','added',347,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 13:04:44','2025-04-22 13:04:44'),(180,'default','added',348,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 13:06:26','2025-04-22 13:06:26'),(181,'default','added',349,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 13:10:02','2025-04-22 13:10:02'),(182,'default','added',350,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 13:15:10','2025-04-22 13:15:10'),(183,'default','added',351,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 13:19:36','2025-04-22 13:19:36'),(184,'default','added',352,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-04-22 13:20:58','2025-04-22 13:20:58'),(185,'default','added',353,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":335000}}',NULL,'2025-04-22 13:36:53','2025-04-22 13:36:53'),(186,'default','added',354,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":111000}}',NULL,'2025-04-22 14:08:30','2025-04-22 14:08:30'),(187,'default','added',355,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10500}}',NULL,'2025-04-22 14:31:29','2025-04-22 14:31:29'),(188,'default','added',356,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":580500}}',NULL,'2025-04-22 14:49:00','2025-04-22 14:49:00'),(189,'default','added',357,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2212000}}',NULL,'2025-04-22 15:27:58','2025-04-22 15:27:58'),(190,'default','edited',357,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2201000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2212000.0000\"}}',NULL,'2025-04-22 15:30:56','2025-04-22 15:30:56'),(191,'default','added',358,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":83000}}',NULL,'2025-04-22 15:43:04','2025-04-22 15:43:04'),(192,'default','added',359,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":158000}}',NULL,'2025-04-22 16:02:21','2025-04-22 16:02:21'),(193,'default','added',360,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45000}}',NULL,'2025-04-22 16:05:35','2025-04-22 16:05:35'),(194,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 16:13:28','2025-04-22 16:13:28'),(195,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-22 18:14:27','2025-04-22 18:14:27'),(196,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-23 08:12:44','2025-04-23 08:12:44'),(197,'default','added',361,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":816000}}',NULL,'2025-04-23 09:43:39','2025-04-23 09:43:39'),(198,'default','added',362,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":310000}}',NULL,'2025-04-23 10:08:04','2025-04-23 10:08:04'),(199,'default','edited',303,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":672000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"672000.0000\"}}',NULL,'2025-04-23 10:28:06','2025-04-23 10:28:06'),(200,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-23 10:42:21','2025-04-23 10:42:22'),(201,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-23 10:42:44','2025-04-23 10:42:44'),(202,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-23 10:42:47','2025-04-23 10:42:47'),(203,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-23 10:42:53','2025-04-23 10:42:53'),(204,'default','added',363,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":741000}}',NULL,'2025-04-23 11:25:54','2025-04-23 11:25:54'),(205,'default','added',364,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90000}}',NULL,'2025-04-23 11:53:15','2025-04-23 11:53:15'),(206,'default','added',365,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155000}}',NULL,'2025-04-23 11:58:25','2025-04-23 11:58:25'),(207,'default','added',366,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2025-04-23 12:26:49','2025-04-23 12:26:49'),(208,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-04-23 13:06:24','2025-04-23 13:06:25'),(209,'default','added',368,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1500000}}',NULL,'2025-04-23 13:11:32','2025-04-23 13:11:32');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 03:13:44','2017-12-18 03:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 03:04:39','2017-12-18 03:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 02:55:40','2017-12-18 02:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 02:58:40','2017-12-18 02:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 02:51:10','2017-12-18 02:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 02:51:10','2017-12-18 02:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'NISHER HOME SHOPPING CENTER',138,'2025-04-15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Africa/Nairobi',1,'fifo',0.00,'includes','1744718156_NisherHomeShopping.jpg',NULL,0,'add_expiry','keep_selling',0,0,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"enable_sales_order\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"disable_order_tax\":\"1\",\"is_pos_subtotal_editable\":\"1\",\"show_pricing_on_product_sugesstion\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',0,1,0,0,1,0,1,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"subscription\"]','m/d/Y','12',0,0,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":\"SO\"}','green',NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":\"Lipa Number\",\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"enable_purchase_order\":\"1\",\"default_datatable_page_entries\":\"25\"}',1,'2025-04-15 12:40:23','2025-04-23 13:11:31'),(2,'Melian Software Company Limited',138,'2025-04-18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,4,'Africa/Nairobi',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-04-18 16:44:03','2025-04-18 16:44:03');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','Main Store Kariakoo','Agrey/Sikukuu Opposite Cello Building','Tanzania','Kinondoni','Dar es salaam','14441',1,1,1,1,NULL,1,'browser',NULL,'+255 754 024 478',NULL,NULL,'https://www.nisher.melianplus.co.tz','[\"210\",\"92\",\"142\"]',1,'{\"cash\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,'2025-04-15 12:40:23','2025-04-22 09:26:21'),(2,1,'BL0002','Ilala Warehouse Store','Agrey/Sikukuu Opposite Cello Building','Tanzania','Kinondoni','Dar es salaam','14441',1,1,1,1,0,1,'browser',NULL,'+255 754 024 478',NULL,'epimackmassaweg8@gmail.com',NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:36:49','2025-04-22 11:56:12'),(3,2,'BL0001','Melian Software Company Limited','kariakoo','Tanzania','Kinondoni','Dar es salaam','14441',2,NULL,2,2,NULL,1,'browser',NULL,'0785520714','','','www.meliansoftware.com',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2025-04-18 16:44:05','2025-04-18 16:44:05');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-04-15 10:10:00','2025-04-15 10:10:54'),(2,1,1,2,'close','2025-04-15 19:34:14',0.0000,0,0,NULL,NULL,'2025-04-15 17:30:00','2025-04-15 17:34:14'),(3,1,2,2,'close','2025-04-15 19:48:10',0.0000,0,0,NULL,NULL,'2025-04-15 17:46:00','2025-04-15 17:48:10'),(4,1,1,2,'close','2025-04-18 10:31:57',0.0000,0,0,NULL,NULL,'2025-04-18 08:29:00','2025-04-18 08:31:57'),(5,1,1,2,'open',NULL,0.0000,0,0,NULL,NULL,'2025-04-18 16:48:00','2025-04-18 16:48:28');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Appliances',1,NULL,0,2,'product','Home appliances',NULL,NULL,'2025-04-17 09:31:23','2025-04-17 09:31:23');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `land_mark` varchar(191) DEFAULT NULL,
  `street_name` varchar(191) DEFAULT NULL,
  `building_number` varchar(191) DEFAULT NULL,
  `additional_number` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(2,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Mr ayob','Mr','ayob',NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'07777777777',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 08:40:45','2025-04-17 08:40:45'),(3,1,'supplier',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,'666','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'777',NULL,'666666',NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 08:25:06','2025-04-18 08:25:06'),(4,1,'customer','business',NULL,NULL,NULL,NULL,'HELA LIMITED','',NULL,NULL,NULL,NULL,NULL,'HABIBA','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'078333333333',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 14:37:40','2025-04-18 14:37:40'),(5,2,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,4,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 16:44:04','2025-04-18 16:44:04'),(6,1,'supplier',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,'CHINA','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'07777866666',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 15:26:53','2025-04-19 15:26:53');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES (1,'Food',1,NULL,NULL,NULL,'2025-04-21 17:33:25','2025-04-21 17:33:25'),(2,'Allowance',1,NULL,NULL,NULL,'2025-04-21 17:33:39','2025-04-21 17:33:39'),(3,'RENT',1,NULL,NULL,NULL,'2025-04-22 09:18:15','2025-04-22 09:18:15'),(4,'ELECTRICITY',1,NULL,NULL,NULL,'2025-04-22 09:18:58','2025-04-22 09:18:58'),(5,'SECURITY',1,NULL,NULL,NULL,'2025-04-22 09:19:39','2025-04-22 09:19:39'),(6,'SALARIES',1,NULL,NULL,NULL,'2025-04-22 09:21:57','2025-04-22 09:21:57'),(7,'WIFI',1,NULL,NULL,NULL,'2025-04-22 09:23:11','2025-04-22 09:23:11');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,0,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null,\"zatca_phase\":\"phase_1\"}',1,1,0,NULL,1,'[\"invoice_no\"]','classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-04-15 12:40:23','2025-04-15 17:15:12'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,2,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-04-18 16:44:04','2025-04-18 16:44:04');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','year','sequential',NULL,1,64,4,1,'2025-04-15 12:40:23','2025-04-23 11:58:22'),(2,2,'Default','blank','sequential','',1,1,4,1,'2025-04-18 16:44:04','2025-04-18 19:57:35');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(291,'2023_04_17_155216_add_custom_fields_to_products',1),(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),(294,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),(295,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),(296,'2023_12_06_152840_add_contact_type_in_contacts',1),(297,'2024_10_03_151459_modify_transaction_sell_lines_purchase_lines_table',1),(298,'2025_03_07_114637_add_more_addresh_column_in_contact',1),(299,'2018_06_27_185405_create_packages_table',2),(300,'2018_06_28_182803_create_subscriptions_table',2),(301,'2018_07_17_182021_add_rows_to_system_table',2),(302,'2018_07_19_131721_add_options_to_packages_table',2),(303,'2018_08_17_155534_add_min_termination_alert_days',2),(304,'2018_08_28_105945_add_business_based_username_settings_to_system_table',2),(305,'2018_08_30_105906_add_superadmin_communicator_logs_table',2),(306,'2018_11_02_130636_add_custom_permissions_to_packages_table',2),(307,'2018_11_05_161848_add_more_fields_to_packages_table',2),(308,'2018_12_10_124621_modify_system_table_values_null_default',2),(309,'2019_05_10_135434_add_missing_database_column_indexes',2),(310,'2019_08_16_115300_create_superadmin_frontend_pages_table',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (80,'App\\User',1),(80,'App\\User',2),(80,'App\\User',3);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',2),(3,'App\\User',1),(3,'App\\User',3),(6,'App\\User',4);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(11,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(12,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(13,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(14,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(15,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(16,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(17,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(18,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(19,2,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(20,2,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-04-18 16:44:05','2025-04-18 16:44:05');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `custom_permissions` longtext NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) DEFAULT NULL,
  `custom_link_text` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'Advanced Package','Package for a Yearly Subscription',2,3,1000,0,0,0,0,0,'years',1,0,0.0000,'',2,1,1,0,0,0,'','',NULL,'2025-04-15 13:22:53','2025-04-15 13:26:26');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2025-04-15 12:30:20',NULL),(2,'direct_sell.access','web','2025-04-15 12:30:20',NULL),(3,'product.opening_stock','web','2025-04-15 12:30:22','2025-04-15 12:30:22'),(4,'crud_all_bookings','web','2025-04-15 12:30:23','2025-04-15 12:30:23'),(5,'crud_own_bookings','web','2025-04-15 12:30:23','2025-04-15 12:30:23'),(6,'access_default_selling_price','web','2025-04-15 12:30:24','2025-04-15 12:30:24'),(7,'purchase.payments','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(8,'sell.payments','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(9,'edit_product_price_from_sale_screen','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(10,'edit_product_discount_from_sale_screen','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(11,'roles.view','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(12,'roles.create','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(13,'roles.update','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(14,'roles.delete','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(15,'account.access','web','2025-04-15 12:30:25','2025-04-15 12:30:25'),(16,'discount.access','web','2025-04-15 12:30:26','2025-04-15 12:30:26'),(17,'view_purchase_price','web','2025-04-15 12:30:26','2025-04-15 12:30:26'),(18,'view_own_sell_only','web','2025-04-15 12:30:26','2025-04-15 12:30:26'),(19,'edit_product_discount_from_pos_screen','web','2025-04-15 12:30:27','2025-04-15 12:30:27'),(20,'edit_product_price_from_pos_screen','web','2025-04-15 12:30:27','2025-04-15 12:30:27'),(21,'access_shipping','web','2025-04-15 12:30:27','2025-04-15 12:30:27'),(22,'purchase.update_status','web','2025-04-15 12:30:27','2025-04-15 12:30:27'),(23,'list_drafts','web','2025-04-15 12:30:28','2025-04-15 12:30:28'),(24,'list_quotations','web','2025-04-15 12:30:28','2025-04-15 12:30:28'),(25,'view_cash_register','web','2025-04-15 12:30:30','2025-04-15 12:30:30'),(26,'close_cash_register','web','2025-04-15 12:30:30','2025-04-15 12:30:30'),(27,'print_invoice','web','2025-04-15 12:30:31','2025-04-15 12:30:31'),(28,'user.view','web','2025-04-15 12:30:34',NULL),(29,'user.create','web','2025-04-15 12:30:34',NULL),(30,'user.update','web','2025-04-15 12:30:34',NULL),(31,'user.delete','web','2025-04-15 12:30:34',NULL),(32,'supplier.view','web','2025-04-15 12:30:34',NULL),(33,'supplier.create','web','2025-04-15 12:30:34',NULL),(34,'supplier.update','web','2025-04-15 12:30:34',NULL),(35,'supplier.delete','web','2025-04-15 12:30:34',NULL),(36,'customer.view','web','2025-04-15 12:30:34',NULL),(37,'customer.create','web','2025-04-15 12:30:34',NULL),(38,'customer.update','web','2025-04-15 12:30:34',NULL),(39,'customer.delete','web','2025-04-15 12:30:34',NULL),(40,'product.view','web','2025-04-15 12:30:34',NULL),(41,'product.create','web','2025-04-15 12:30:34',NULL),(42,'product.update','web','2025-04-15 12:30:34',NULL),(43,'product.delete','web','2025-04-15 12:30:34',NULL),(44,'purchase.view','web','2025-04-15 12:30:34',NULL),(45,'purchase.create','web','2025-04-15 12:30:34',NULL),(46,'purchase.update','web','2025-04-15 12:30:34',NULL),(47,'purchase.delete','web','2025-04-15 12:30:34',NULL),(48,'sell.view','web','2025-04-15 12:30:34',NULL),(49,'sell.create','web','2025-04-15 12:30:34',NULL),(50,'sell.update','web','2025-04-15 12:30:34',NULL),(51,'sell.delete','web','2025-04-15 12:30:34',NULL),(52,'purchase_n_sell_report.view','web','2025-04-15 12:30:34',NULL),(53,'contacts_report.view','web','2025-04-15 12:30:34',NULL),(54,'stock_report.view','web','2025-04-15 12:30:34',NULL),(55,'tax_report.view','web','2025-04-15 12:30:34',NULL),(56,'trending_product_report.view','web','2025-04-15 12:30:34',NULL),(57,'register_report.view','web','2025-04-15 12:30:34',NULL),(58,'sales_representative.view','web','2025-04-15 12:30:34',NULL),(59,'expense_report.view','web','2025-04-15 12:30:34',NULL),(60,'business_settings.access','web','2025-04-15 12:30:34',NULL),(61,'barcode_settings.access','web','2025-04-15 12:30:34',NULL),(62,'invoice_settings.access','web','2025-04-15 12:30:34',NULL),(63,'brand.view','web','2025-04-15 12:30:34',NULL),(64,'brand.create','web','2025-04-15 12:30:34',NULL),(65,'brand.update','web','2025-04-15 12:30:34',NULL),(66,'brand.delete','web','2025-04-15 12:30:34',NULL),(67,'tax_rate.view','web','2025-04-15 12:30:34',NULL),(68,'tax_rate.create','web','2025-04-15 12:30:34',NULL),(69,'tax_rate.update','web','2025-04-15 12:30:34',NULL),(70,'tax_rate.delete','web','2025-04-15 12:30:34',NULL),(71,'unit.view','web','2025-04-15 12:30:34',NULL),(72,'unit.create','web','2025-04-15 12:30:34',NULL),(73,'unit.update','web','2025-04-15 12:30:34',NULL),(74,'unit.delete','web','2025-04-15 12:30:34',NULL),(75,'category.view','web','2025-04-15 12:30:34',NULL),(76,'category.create','web','2025-04-15 12:30:34',NULL),(77,'category.update','web','2025-04-15 12:30:34',NULL),(78,'category.delete','web','2025-04-15 12:30:34',NULL),(79,'expense.access','web','2025-04-15 12:30:34',NULL),(80,'access_all_locations','web','2025-04-15 12:30:34',NULL),(81,'dashboard.data','web','2025-04-15 12:30:34',NULL),(82,'location.1','web','2025-04-15 12:40:23','2025-04-15 12:40:23'),(83,'edit_purchase_payment','web','2025-04-15 13:00:43','2025-04-15 13:00:43'),(84,'delete_purchase_payment','web','2025-04-15 13:00:43','2025-04-15 13:00:43'),(85,'edit_pos_payment','web','2025-04-15 13:00:44','2025-04-15 13:00:44'),(86,'disable_pay_checkout','web','2025-04-15 13:00:44','2025-04-15 13:00:44'),(87,'disable_draft','web','2025-04-15 13:00:44','2025-04-15 13:00:44'),(88,'disable_express_checkout','web','2025-04-15 13:00:44','2025-04-15 13:00:44'),(89,'disable_discount','web','2025-04-15 13:00:44','2025-04-15 13:00:44'),(90,'disable_suspend_sale','web','2025-04-15 13:00:44','2025-04-15 13:00:44'),(91,'disable_credit_sale','web','2025-04-15 13:00:45','2025-04-15 13:00:45'),(92,'disable_quotation','web','2025-04-15 13:00:45','2025-04-15 13:00:45'),(93,'disable_card','web','2025-04-15 13:00:45','2025-04-15 13:00:45'),(94,'view_paid_sells_only','web','2025-04-15 13:00:46','2025-04-15 13:00:46'),(95,'view_due_sells_only','web','2025-04-15 13:00:46','2025-04-15 13:00:46'),(96,'view_partial_sells_only','web','2025-04-15 13:00:46','2025-04-15 13:00:46'),(97,'view_overdue_sells_only','web','2025-04-15 13:00:46','2025-04-15 13:00:46'),(98,'direct_sell.update','web','2025-04-15 13:00:47','2025-04-15 13:00:47'),(99,'direct_sell.delete','web','2025-04-15 13:00:47','2025-04-15 13:00:47'),(100,'view_commission_agent_sell','web','2025-04-15 13:00:47','2025-04-15 13:00:47'),(101,'edit_sell_payment','web','2025-04-15 13:00:48','2025-04-15 13:00:48'),(102,'delete_sell_payment','web','2025-04-15 13:00:48','2025-04-15 13:00:48'),(103,'access_sell_return','web','2025-04-15 13:00:48','2025-04-15 13:00:48'),(104,'access_own_sell_return','web','2025-04-15 13:00:49','2025-04-15 13:00:49'),(105,'edit_invoice_number','web','2025-04-15 13:00:49','2025-04-15 13:00:49'),(106,'draft.update','web','2025-04-15 13:00:50','2025-04-15 13:00:50'),(107,'draft.delete','web','2025-04-15 13:00:50','2025-04-15 13:00:50'),(108,'view_product_stock_value','web','2025-04-15 13:00:50','2025-04-15 13:00:50'),(109,'expense.add','web','2025-04-15 13:00:50','2025-04-15 13:00:50'),(110,'expense.edit','web','2025-04-15 13:00:51','2025-04-15 13:00:51'),(111,'expense.delete','web','2025-04-15 13:00:51','2025-04-15 13:00:51'),(112,'customer_irrespective_of_sell','web','2025-04-15 13:00:52','2025-04-15 13:00:52'),(113,'direct_sell.view','web','2025-04-15 13:00:52','2025-04-15 13:00:52'),(114,'draft.view_all','web','2025-04-15 13:00:52','2025-04-15 13:00:52'),(115,'all_expense.access','web','2025-04-15 13:00:52','2025-04-15 13:00:52'),(116,'quotation.update','web','2025-04-15 13:02:04','2025-04-15 13:02:04'),(117,'quotation.delete','web','2025-04-15 13:02:04','2025-04-15 13:02:04'),(118,'quotation.view_own','web','2025-04-15 13:02:05','2025-04-15 13:02:05'),(119,'view_export_buttons','web','2025-04-15 13:05:02','2025-04-15 13:05:02'),(120,'location.2','web','2025-04-15 13:36:49','2025-04-15 13:36:49'),(121,'supplier.view_own','web','2025-04-15 17:40:01','2025-04-15 17:40:01'),(122,'customer.view_own','web','2025-04-15 17:40:01','2025-04-15 17:40:01'),(123,'view_own_purchase','web','2025-04-15 17:40:01','2025-04-15 17:40:01'),(124,'quotation.view_all','web','2025-04-15 17:41:32','2025-04-15 17:41:32'),(125,'access_pending_shipments_only','web','2025-04-18 19:18:49','2025-04-18 19:18:49'),(126,'access_commission_agent_shipping','web','2025-04-18 19:18:49','2025-04-18 19:18:49'),(127,'location.3','web','2025-04-18 16:44:05','2025-04-18 16:44:05'),(128,'so.create','web','2025-04-22 10:46:38','2025-04-22 10:46:38'),(129,'so.update','web','2025-04-22 10:46:38','2025-04-22 10:46:38'),(130,'so.delete','web','2025-04-22 10:46:39','2025-04-22 10:46:39'),(131,'so.view_all','web','2025-04-22 10:46:39','2025-04-22 10:46:39');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,2),(137,2),(138,2),(139,2),(140,2),(141,2),(142,2),(143,2),(144,2),(145,2),(146,2),(147,2),(148,2),(149,2),(150,2),(151,2),(152,2),(153,2),(154,2),(155,2),(156,2),(157,2),(158,2),(159,2),(160,2),(161,2),(162,2),(163,2),(164,2),(165,2),(166,2),(167,2),(168,2),(169,2),(170,2),(171,2),(172,2),(173,2),(174,2),(175,2),(176,2),(177,2),(178,2),(179,2),(180,2),(181,2),(182,2),(183,2),(184,2),(185,2),(186,2),(187,2),(188,2),(189,2),(190,2),(191,2),(192,2),(193,2),(194,2),(195,2),(196,2),(197,2),(198,2),(199,2),(200,2),(201,2),(202,2),(203,2),(204,2),(205,2),(206,2),(207,2),(208,2),(209,2),(210,2),(139,1),(142,1),(206,1),(141,1),(210,1),(209,1),(201,1),(202,1),(203,1),(204,1),(205,1),(207,1),(208,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(211,3),(212,2),(212,1),(147,1),(213,2),(213,1),(143,1),(144,1),(137,1),(140,1),(215,2),(150,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(2,NULL,'DUMMY',2,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(3,NULL,'DUMMY',3,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(4,NULL,'DUMMY',4,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(5,NULL,'DUMMY',5,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(6,NULL,'DUMMY',6,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(7,NULL,'DUMMY',7,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(8,NULL,'DUMMY',8,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(9,NULL,'DUMMY',9,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(10,NULL,'DUMMY',10,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(11,NULL,'DUMMY',11,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(12,NULL,'DUMMY',12,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(13,NULL,'DUMMY',13,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(14,NULL,'DUMMY',14,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(15,NULL,'DUMMY',15,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(16,NULL,'DUMMY',16,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(17,NULL,'DUMMY',17,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(18,NULL,'DUMMY',18,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(19,NULL,'DUMMY',19,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(20,NULL,'DUMMY',20,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(21,NULL,'DUMMY',21,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(22,NULL,'DUMMY',22,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(23,NULL,'DUMMY',23,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(24,NULL,'DUMMY',24,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(25,NULL,'DUMMY',25,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(26,NULL,'DUMMY',26,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(27,NULL,'DUMMY',27,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(28,NULL,'DUMMY',28,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(29,NULL,'DUMMY',29,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(30,NULL,'DUMMY',30,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(31,NULL,'DUMMY',31,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(32,NULL,'DUMMY',32,1,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(33,NULL,'DUMMY',33,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(34,NULL,'DUMMY',34,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(35,NULL,'DUMMY',35,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(36,NULL,'DUMMY',36,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(37,NULL,'DUMMY',37,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(38,NULL,'DUMMY',38,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(39,NULL,'DUMMY',39,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(40,NULL,'DUMMY',40,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(41,NULL,'DUMMY',41,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(42,NULL,'DUMMY',42,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(43,NULL,'DUMMY',43,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(44,NULL,'DUMMY',44,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(45,NULL,'DUMMY',45,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(46,NULL,'DUMMY',46,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(47,NULL,'DUMMY',47,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(48,NULL,'DUMMY',48,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(49,NULL,'DUMMY',49,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(50,NULL,'DUMMY',50,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(51,NULL,'DUMMY',51,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(52,NULL,'DUMMY',52,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(53,NULL,'DUMMY',53,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(54,NULL,'DUMMY',54,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(55,NULL,'DUMMY',55,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(56,NULL,'DUMMY',56,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(57,NULL,'DUMMY',57,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(58,NULL,'DUMMY',58,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(59,NULL,'DUMMY',59,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(60,NULL,'DUMMY',60,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(61,NULL,'DUMMY',61,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(62,NULL,'DUMMY',62,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(63,NULL,'DUMMY',63,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(64,NULL,'DUMMY',64,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(65,NULL,'DUMMY',65,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(66,NULL,'DUMMY',66,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(67,NULL,'DUMMY',67,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(68,NULL,'DUMMY',68,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(69,NULL,'DUMMY',69,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(70,NULL,'DUMMY',70,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(71,NULL,'DUMMY',71,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(72,NULL,'DUMMY',72,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(73,NULL,'DUMMY',73,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(74,NULL,'DUMMY',74,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(75,NULL,'DUMMY',75,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(76,NULL,'DUMMY',76,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(77,NULL,'DUMMY',77,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(78,NULL,'DUMMY',78,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(79,NULL,'DUMMY',79,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(80,NULL,'DUMMY',80,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(81,NULL,'DUMMY',81,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(82,NULL,'DUMMY',82,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(83,NULL,'DUMMY',83,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(84,NULL,'DUMMY',84,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(85,NULL,'DUMMY',85,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(86,NULL,'DUMMY',86,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(87,NULL,'DUMMY',87,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(88,NULL,'DUMMY',88,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(89,NULL,'DUMMY',89,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(90,NULL,'DUMMY',90,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(91,NULL,'DUMMY',91,1,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(92,NULL,'DUMMY',92,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(93,NULL,'DUMMY',93,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(94,NULL,'DUMMY',94,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(95,NULL,'DUMMY',95,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(96,NULL,'DUMMY',96,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(97,NULL,'DUMMY',97,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(98,NULL,'DUMMY',98,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(99,NULL,'DUMMY',99,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(100,NULL,'DUMMY',100,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(101,NULL,'DUMMY',101,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(102,NULL,'DUMMY',102,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(103,NULL,'DUMMY',103,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(104,NULL,'DUMMY',104,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(105,NULL,'DUMMY',105,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(106,NULL,'DUMMY',106,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(107,NULL,'DUMMY',107,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(108,NULL,'DUMMY',108,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(109,NULL,'DUMMY',109,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(110,NULL,'DUMMY',110,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(111,NULL,'DUMMY',111,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(112,NULL,'DUMMY',112,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(113,NULL,'DUMMY',113,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(114,NULL,'DUMMY',114,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(115,NULL,'DUMMY',115,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(116,NULL,'DUMMY',116,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(117,NULL,'DUMMY',117,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(118,NULL,'DUMMY',118,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(119,NULL,'DUMMY',119,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(120,NULL,'DUMMY',120,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(121,NULL,'DUMMY',121,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(122,NULL,'DUMMY',122,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(123,NULL,'DUMMY',123,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(124,NULL,'DUMMY',124,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(125,NULL,'DUMMY',125,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(126,NULL,'DUMMY',126,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(127,NULL,'DUMMY',127,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(128,NULL,'DUMMY',128,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(129,NULL,'DUMMY',129,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(130,NULL,'DUMMY',130,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(131,NULL,'DUMMY',131,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(132,NULL,'DUMMY',132,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(133,NULL,'DUMMY',133,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(134,NULL,'DUMMY',134,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(135,NULL,'DUMMY',135,1,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(136,NULL,'DUMMY',136,1,'2025-04-15 13:47:20','2025-04-15 13:47:20'),(137,NULL,'DUMMY',137,1,'2025-04-15 13:47:21','2025-04-15 13:47:21'),(138,NULL,'DUMMY',138,1,'2025-04-15 13:47:22','2025-04-15 13:47:22'),(139,NULL,'DUMMY',139,1,'2025-04-15 13:47:23','2025-04-15 13:47:23'),(140,NULL,'DUMMY',140,1,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(141,NULL,'DUMMY',141,1,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(142,NULL,'DUMMY',142,1,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(143,NULL,'DUMMY',143,1,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(144,NULL,'DUMMY',144,1,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(145,NULL,'DUMMY',145,1,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(146,NULL,'DUMMY',146,1,'2025-04-15 13:47:25','2025-04-15 13:47:25'),(147,NULL,'DUMMY',147,1,'2025-04-15 13:47:25','2025-04-15 13:47:25'),(148,NULL,'DUMMY',148,1,'2025-04-15 13:47:25','2025-04-15 13:47:25'),(149,NULL,'DUMMY',149,1,'2025-04-15 13:47:26','2025-04-15 13:47:26'),(150,NULL,'DUMMY',150,1,'2025-04-15 13:47:26','2025-04-15 13:47:26'),(151,NULL,'DUMMY',151,1,'2025-04-15 13:47:27','2025-04-15 13:47:27'),(152,NULL,'DUMMY',152,1,'2025-04-15 13:47:27','2025-04-15 13:47:27'),(153,NULL,'DUMMY',153,1,'2025-04-15 13:47:28','2025-04-15 13:47:28'),(154,NULL,'DUMMY',154,1,'2025-04-15 13:47:30','2025-04-15 13:47:30'),(155,NULL,'DUMMY',155,1,'2025-04-15 13:47:31','2025-04-15 13:47:31'),(156,NULL,'DUMMY',156,1,'2025-04-15 13:47:32','2025-04-15 13:47:32'),(157,NULL,'DUMMY',157,1,'2025-04-15 13:47:33','2025-04-15 13:47:33'),(158,NULL,'DUMMY',158,1,'2025-04-15 13:47:33','2025-04-15 13:47:33'),(159,NULL,'DUMMY',159,1,'2025-04-15 13:47:34','2025-04-15 13:47:34'),(160,NULL,'DUMMY',160,1,'2025-04-15 13:47:35','2025-04-15 13:47:35'),(161,NULL,'DUMMY',161,1,'2025-04-15 13:47:35','2025-04-15 13:47:35'),(162,NULL,'DUMMY',162,1,'2025-04-15 13:47:36','2025-04-15 13:47:36'),(163,NULL,'DUMMY',163,1,'2025-04-15 13:47:36','2025-04-15 13:47:36'),(164,NULL,'DUMMY',164,1,'2025-04-15 13:47:37','2025-04-15 13:47:37'),(165,NULL,'DUMMY',165,1,'2025-04-15 13:47:37','2025-04-15 13:47:37'),(166,NULL,'DUMMY',166,1,'2025-04-15 13:47:38','2025-04-15 13:47:38'),(167,NULL,'DUMMY',167,1,'2025-04-15 13:47:39','2025-04-15 13:47:39'),(168,NULL,'DUMMY',168,1,'2025-04-15 13:47:39','2025-04-15 13:47:39'),(169,NULL,'DUMMY',169,1,'2025-04-15 13:47:39','2025-04-15 13:47:39'),(170,NULL,'DUMMY',170,1,'2025-04-15 13:47:40','2025-04-15 13:47:40'),(171,NULL,'DUMMY',171,1,'2025-04-15 13:47:40','2025-04-15 13:47:40'),(172,NULL,'DUMMY',172,1,'2025-04-15 13:47:41','2025-04-15 13:47:41'),(173,NULL,'DUMMY',173,1,'2025-04-15 13:47:41','2025-04-15 13:47:41'),(174,NULL,'DUMMY',174,1,'2025-04-15 13:47:42','2025-04-15 13:47:42'),(175,NULL,'DUMMY',175,1,'2025-04-15 13:47:43','2025-04-15 13:47:43'),(176,NULL,'DUMMY',176,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(177,NULL,'DUMMY',177,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(178,NULL,'DUMMY',178,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(179,NULL,'DUMMY',179,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(180,NULL,'DUMMY',180,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(181,NULL,'DUMMY',181,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(182,NULL,'DUMMY',182,1,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(183,NULL,'DUMMY',183,1,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(184,NULL,'DUMMY',184,1,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(185,NULL,'DUMMY',185,1,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(186,NULL,'DUMMY',186,1,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(187,NULL,'DUMMY',187,1,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(188,NULL,'DUMMY',188,1,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(189,NULL,'DUMMY',189,1,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(190,NULL,'DUMMY',190,1,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(191,NULL,'DUMMY',191,1,'2025-04-15 13:47:47','2025-04-15 13:47:47'),(192,NULL,'DUMMY',192,1,'2025-04-15 13:47:47','2025-04-15 13:47:47'),(193,NULL,'DUMMY',193,1,'2025-04-15 13:47:47','2025-04-15 13:47:47'),(194,NULL,'DUMMY',194,1,'2025-04-15 13:47:48','2025-04-15 13:47:48'),(195,NULL,'DUMMY',195,1,'2025-04-15 13:47:49','2025-04-15 13:47:49'),(196,NULL,'DUMMY',196,1,'2025-04-15 13:47:49','2025-04-15 13:47:49'),(197,NULL,'DUMMY',197,1,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(198,NULL,'DUMMY',198,1,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(199,NULL,'DUMMY',199,1,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(200,NULL,'DUMMY',200,1,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(201,NULL,'DUMMY',201,1,'2025-04-15 13:47:51','2025-04-15 13:47:51'),(202,NULL,'DUMMY',202,1,'2025-04-15 13:47:51','2025-04-15 13:47:51'),(203,NULL,'DUMMY',203,1,'2025-04-15 13:47:52','2025-04-15 13:47:52'),(204,NULL,'DUMMY',204,1,'2025-04-15 13:47:52','2025-04-15 13:47:52'),(205,NULL,'DUMMY',205,1,'2025-04-17 14:13:34','2025-04-17 14:13:34'),(206,NULL,'DUMMY',206,1,'2025-04-18 08:10:15','2025-04-18 08:10:15'),(207,NULL,'DUMMY',207,1,'2025-04-18 08:18:22','2025-04-18 08:18:22'),(208,NULL,'DUMMY',208,1,'2025-04-18 09:36:16','2025-04-18 09:36:16'),(209,NULL,'DUMMY',209,1,'2025-04-18 13:05:50','2025-04-18 13:05:50'),(210,NULL,'DUMMY',210,1,'2025-04-18 13:08:54','2025-04-18 13:08:54'),(211,NULL,'DUMMY',211,1,'2025-04-18 19:46:50','2025-04-18 19:46:50'),(212,NULL,'DUMMY',212,1,'2025-04-19 13:38:00','2025-04-19 13:38:00'),(213,NULL,'DUMMY',213,1,'2025-04-21 09:07:25','2025-04-21 09:07:25'),(214,NULL,'DUMMY',214,1,'2025-04-23 13:06:32','2025-04-23 13:06:32'),(215,NULL,'DUMMY',215,1,'2025-04-23 13:08:15','2025-04-23 13:08:15');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(10) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'2M S BRONZE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0001','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(2,'2M S SILVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0002','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(3,'2M S GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0003','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(4,'2M S COPPER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0004','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(5,'2M S BLACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0005','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(6,'2M D BLACK',1,'single',1,NULL,NULL,NULL,1,NULL,NULL,'inclusive',1,5.0000,'0006','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-17 09:35:57'),(7,'2M D SILVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0007','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(8,'2M D GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0008','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(9,'3M D GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0009','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(10,'3M D SILVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0010','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(11,'3M  D BLACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0011','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(12,'3M S GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0012','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(13,'3M S COPPER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0013','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(14,'3M S SILVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0014','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-21 13:08:19'),(15,'3M S BRONZE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0015','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(16,'MAUA GOLD STICK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0016','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-22 14:29:51'),(17,'MAUA GOLD BANCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0017','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(18,'BRIDAL  WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0018','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(19,'BRIDAL COLOURED',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0019','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(20,'VASE MTI BLACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0020','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(21,'VASE WHITE KUSWA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0021','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(22,'NANDY TREE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0022','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(23,'SCATIERED TETAL TREEKS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0023','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(24,'SCATTERED PETAL TREENG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0024','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(25,'CORONARIUM TREE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0025','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-19 14:25:47'),(26,'PALM TREE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0026','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(27,'AMARA STICK TREE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0027','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(28,'RAGGS ROUND',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0028','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(29,'RAGGS ROUND FUPI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0029','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(30,'KABATI 3 DOOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0030','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(31,'KABATI 2 DOOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0031','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(32,'FORONYA SOFT VALVET SANI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0032','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(33,'FORONYA BRAND',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0033','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(34,'FORONYA LUXURY VALVET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0034','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(35,'FOROBYA FUMFY FENDI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'0035','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(36,'FORONYA DRAFT MANYOYA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0036','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(37,'MISWALA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0037','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(38,'FORONYA NYOYA PLAIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0038','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(39,'FORONYA NYOYA 2 SIDES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0039','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(40,'PAZIA 1.5 SPECIAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0040','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(41,'EMPTY  BOOK SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0041','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-19 09:36:27'),(42,'ZULIA 3D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0042','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(43,'SOFT ZULIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0043','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(44,'PAZIA SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0044','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(45,'MAUA GOLD 9K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0045','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(46,'PAZIA 2M READY MADE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0046','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(47,'PAZIA 1.5 READY MADE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0047','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(48,'WALL PANEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0048','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(49,'SEAT (CHAIR LOVER)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0049','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(50,'MAUA MADOGO GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0050','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(51,'MAUA ROSE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0051','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(52,'VIOO VYA 5PC SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0052','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(53,'SAA ZA 80K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0053','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(54,'MAUA MADOGO 13K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0054','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(55,'MAUA KUNING\'INIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0055','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(56,'SOFA COVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0056','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(57,'FORONYA NDOGO 1900',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0057','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(58,'LAMP ZA 25K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0058','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(59,'LAMP ZA 29 K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0059','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(60,'VERSE CUP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0060','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(61,'EMPTY BOOKSINGLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0061','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(62,'VERSE APPLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0062','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(63,'VASE NDEFU @ 45K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0063','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(64,'LESS KUSHONA ROLLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0064','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(65,'PAZIA KUSHONA ROLLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0065','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(66,'VASE WHITE MTI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0066','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(67,'FORONYA MANYOYA WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0067','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(68,'TAULO WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0068','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(69,'MITO 45 X 45',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0069','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(70,'VIBANIO SHANGA KAWAIDA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0070','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(71,'VIBANIO RUNGU KAWAIDA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0071','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(72,'VIBANIO SHANGA GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0072','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(73,'TREY ROUND KATI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0073','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(74,'TREY ROUND NDOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0074','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(75,'TABLE CLOTH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0075','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-21 15:16:06'),(76,'DOORMAT NDOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0076','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(77,'DOORMAT MATUTA KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0077','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(78,'doormat waterproof',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0078','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-21 09:18:25'),(79,'VIBANIO MANYOYA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0079','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(80,'VIBANIO ROUND RUNGU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0080','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(81,'VIBANIO GOLD CHAINI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0081','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(82,'RAGES SAMAKI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0082','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(83,'DOORMAT 4K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0083','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(84,'DOORMAT MANYOYA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0084','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(85,'DOORMAT MISTARI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0085','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(86,'DOORMART 3D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0086','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(87,'DOORMAT TAIL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0087','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(88,'SHOWER CURTAIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0088','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(89,'BATHROOM MAT RUBBER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0089','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(90,'3D MANYOYA ZULIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0090','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(91,'MIKANDA PAZIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0091','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(92,'SAA ZA 2PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0092','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(93,'CURTAIN HOOK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0093','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-17 09:41:08'),(94,'SAA ZA 3PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0094','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(95,'FLAME ZA PC 3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0095','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(96,'FISHER 8MM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0096','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-23 12:42:48'),(97,'ZULIA 3D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0097','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(98,'CERAMIO AOLDVOSE KB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0098','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(99,'DIANNE VASE KB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0099','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(100,'CHAMPAGNE ROSE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0100','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(101,'CERAMIC GOLD NGOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0101','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(102,'CLOCKE GOLD & WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0102','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(103,'GOLD GINGER JAR NDOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0103','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(104,'GOLD GINGER KUBWA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0104','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(105,'VASE NDOGO @ 18K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0105','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(106,'DIANNE VASE NDOGO GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0106','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(107,'DIANNE VASE NDOGO  WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0107','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(108,'BLACK WITH GOLD JARVASE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0108','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(109,'PAMPER STICKS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0109','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(110,'ORCHID FLOWER 45+',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0110','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(111,'LILY FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0111','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(112,'MAUA @15K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0112','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(113,'CHERRY FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0113','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(114,'RINGI PAZIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0114','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(115,'VIOO SQUARE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0115','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(116,'VIOO ROUND',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0116','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(117,'TABLE RUNNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0117','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(118,'CURTAIN HOOK JANI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0118','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(119,'DIFFUSERS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0119','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(120,'DUSTIBIN & TISSUE BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0120','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(121,'TABLE MATS NDEFU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0121','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(122,'TABLE MATES ROUND',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0122','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(123,'THROWING BLANCKETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0123','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(124,'WALLPAPERS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0124','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(125,'WALLPAPERS 3D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0125','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(126,'KITCHEN ZA STICKER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0126','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(127,'LESS ZA SPECIAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0127','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(128,'TABLE MATS KACHA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0128','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(129,'CANDLE HOLDER KB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0129','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(130,'TREY SQUARE SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0130','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(131,'BEDSHEETS & 4 PILLOWINE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0131','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(132,'BEDSHEET & DUVET COVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0132','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(133,'VIBANIO TAUSI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0133','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(134,'CHERRY TREE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0134','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(135,'CANDLE HOLDER NDOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0135','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(136,'DORMAT 2D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0136','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:18','2025-04-15 13:47:18'),(137,'SOFT ZULIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0137','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:20','2025-04-15 13:47:21'),(138,'CHAIR COVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0138','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:22','2025-04-15 13:47:22'),(139,'RINGI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0139','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:23','2025-04-15 13:47:23'),(140,'MIKANDA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0140','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:23','2025-04-15 13:47:24'),(141,'PAZIA SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0141','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(142,'LESS PAZIA SPECIAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0142','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:24','2025-04-17 13:29:39'),(143,'TABLE MATS ROUND',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0143','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:24','2025-04-17 13:34:06'),(144,'EMPTY BOOK SINGLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0144','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(145,'EMPTY BOOK SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0145','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:24','2025-04-15 13:47:24'),(146,'VELVET JORA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0146','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:25','2025-04-15 13:47:25'),(147,'BATHROOM MAT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0147','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:25','2025-04-15 13:47:25'),(148,'2M D SILVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0148','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:25','2025-04-15 13:47:25'),(149,'2M D GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0149','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:25','2025-04-15 13:47:26'),(150,'2M D BLACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0150','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:26','2025-04-15 13:47:26'),(151,'3M D BLACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0151','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:26','2025-04-15 13:47:27'),(152,'3M D GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0152','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:27','2025-04-15 13:47:27'),(153,'3M S COPPER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0153','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:28','2025-04-15 13:47:28'),(154,'3M D SILVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0154','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:29','2025-04-23 13:24:54'),(155,'KARATI 2DOOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0155','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:31','2025-04-15 13:47:31'),(156,'KARATI 3DOOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0156','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:31','2025-04-15 13:47:32'),(157,'FORONYA SOFT VELVET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0157','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:32','2025-04-15 13:47:32'),(158,'VASE WHITE MTI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0158','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:33','2025-04-19 11:29:50'),(159,'ZULIA 3D MANYOYA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0159','C128',NULL,NULL,1,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:34','2025-04-17 15:06:18'),(160,'VIBANIO BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0160','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:34','2025-04-15 13:47:35'),(161,'SAA ZA 2PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0161','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:35','2025-04-15 13:47:35'),(162,'FORONYA MANYOYA DRAFT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0162','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:35','2025-04-15 13:47:36'),(163,'FORONYA FENDI MANYOYA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0163','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:36','2025-04-15 13:47:36'),(164,'DOORMAT MANYOYA BELLO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0164','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:37','2025-04-15 13:47:37'),(165,'SOFA COVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0165','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:37','2025-04-15 13:47:37'),(166,'FORONYA NDOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0166','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:38','2025-04-15 13:47:38'),(167,'THROWING BLANKET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0167','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:39','2025-04-15 13:47:39'),(168,'DOORMAT RUBER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0168','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:39','2025-04-15 13:47:39'),(169,'CURTAIN HOOK @20K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0169','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:39','2025-04-15 13:47:39'),(170,'VIBANIO SHANGA KAWAIDA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0170','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:40','2025-04-15 13:47:40'),(171,'VIBANIO SHANGA GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0171','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:40','2025-04-15 13:47:40'),(172,'CURTAIN HOOK  @12K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0172','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:41','2025-04-15 13:47:41'),(173,'VIOO ROUND NDOGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0173','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:41','2025-04-15 13:47:41'),(174,'VIOO ROUND KUBWA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0174','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:42','2025-04-15 13:47:42'),(175,'MAUA CHERRY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0175','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:43','2025-04-15 13:47:43'),(176,'DOORMAT MIKANDA (RELI)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0176','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(177,'VERSE GOLD KIBUYU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0177','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(178,'MAUA MADOGO @10K GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0178','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(179,'MAUA ORCHID KUBWA MEZA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0179','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(180,'VERSE NDOGO GOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0180','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(181,'VERSE SET CHUNGU ROTE SET 24',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0181','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(182,'VERSE SET WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0182','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(183,'DUSTBIN SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0183','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:44','2025-04-15 13:47:44'),(184,'VERSE NDEFU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0184','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(185,'SAA ZA 2PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0185','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(186,'VIBANIO KAWAIDA @4K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0186','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(187,'LAMP ZA 29K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0187','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:45','2025-04-15 13:47:45'),(188,'LAMP ZA 26K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0188','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(189,'LAMP ZA 35K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0189','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(190,'ORCHID FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0190','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(191,'RILLIES FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0191','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:46','2025-04-15 13:47:46'),(192,'TULIP BANCH FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0192','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:47','2025-04-15 13:47:47'),(193,'LOVEBIRD BANCH FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0193','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:47','2025-04-15 13:47:47'),(194,'HEAD CRYSTAL ROSE BANCH FLOWER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,2.0000,'0194','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:48','2025-04-15 13:47:48'),(195,'WALLPAPERS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0195','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:48','2025-04-15 13:47:48'),(196,'GUNDI WALLPAPER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0196','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:49','2025-04-15 13:47:49'),(197,'VIOO VYA KUSIMAMA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0197','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:49','2025-04-15 13:47:49'),(198,'ZULIA NYASI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0198','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(199,'SAA ZA 3PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0199','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(200,'VIOO VYA 3PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0200','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:50','2025-04-15 13:47:50'),(201,'FRAME 50 × 50',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0201','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:51','2025-04-15 13:47:51'),(202,'FRAME 50 × 70',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0202','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:51','2025-04-15 13:47:51'),(203,'FRAME 60 × 80',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0203','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:52','2025-04-15 13:47:52'),(204,'FRAME 60 × 120',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'0204','C128',NULL,NULL,1,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,2,NULL,NULL,0,0,'2025-04-15 13:47:52','2025-04-15 13:47:52'),(205,'KABATI 2 DOOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0205','C128',NULL,NULL,0,'470','','','','','','','','','','','','','','','','','','','','',NULL,NULL,1,NULL,NULL,0,0,'2025-04-17 14:13:33','2025-04-17 14:36:04'),(206,'PAZIA 1.5 SPECIAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,50.0000,'0206','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-18 08:10:15','2025-04-18 08:10:15'),(207,'Cofee Maker',1,'single',1,NULL,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0207','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,0,0,'2025-04-18 08:18:22','2025-04-18 08:18:22'),(208,'KABATI 3 DOORS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,50.0000,'0208','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-18 09:36:16','2025-04-18 09:36:16'),(209,'MITO 45X45',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,50.0000,'0209','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-18 13:05:49','2025-04-18 13:05:49'),(210,'PAZIA READYMADE 2M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0210','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-18 13:08:54','2025-04-18 13:08:54'),(211,'Mouse pad',2,'single',26,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,12.0000,'0211','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,0,0,'2025-04-18 19:46:50','2025-04-18 19:46:50'),(212,'PAZIA READY MADE 1.5',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0212','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-19 13:37:59','2025-04-19 13:38:00'),(213,'doormat waterproof',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,100.0000,'0213','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-21 09:07:24','2025-04-21 09:07:24'),(214,'FISHER 8MM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0214','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-23 13:06:29','2025-04-23 13:06:32'),(215,'FISHER 8MM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,50.0000,'0215','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,0,'2025-04-23 13:08:14','2025-04-23 13:08:14');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_requisition_line_id` int(11) DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=340 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,1,1,6.0000,0.0000,7000.0000,0.00,7000.0000,7000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 11:10:44'),(2,2,2,2,16.0000,0.0000,7000.0000,0.00,7000.0000,7000.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 11:15:45'),(3,3,3,3,12.0000,0.0000,84000.0000,0.00,84000.0000,84000.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-20 18:32:02'),(4,4,4,4,10.0000,0.0000,84000.0000,0.00,84000.0000,84000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(5,5,5,5,4.0000,0.0000,7000.0000,0.00,7000.0000,7000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 11:10:09'),(6,6,6,6,15.0000,0.0000,12500.0000,0.00,12500.0000,12500.0000,0.0000,NULL,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 15:27:58'),(7,7,7,7,11.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(8,8,8,8,11.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(9,9,9,9,17.0000,0.0000,17333.3300,0.00,17333.3300,17333.3300,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 09:55:42'),(10,10,10,10,10.0000,0.0000,17333.0000,0.00,17333.0000,17333.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 11:11:23'),(11,11,11,11,15.0000,0.0000,17333.0000,0.00,17333.0000,17333.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 11:47:09'),(12,12,12,12,5.0000,0.0000,17333.3330,0.00,17333.3330,17333.3330,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 10:02:33'),(13,13,13,13,22.0000,0.0000,11000.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,22.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 16:07:05'),(14,14,14,14,13.0000,0.0000,11000.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-21 13:13:01'),(15,15,15,15,8.0000,0.0000,132000.0000,0.00,132000.0000,132000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(16,16,16,16,462.0000,0.0000,1300.0000,0.00,1300.0000,1300.0000,0.0000,NULL,NULL,NULL,30.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 14:49:00'),(17,17,17,17,349.0000,0.0000,5800.0000,0.00,5800.0000,5800.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-20 18:32:02'),(18,18,18,18,111.0000,0.0000,16000.0000,0.00,16000.0000,16000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(19,19,19,19,128.0000,0.0000,22500.0000,0.00,22500.0000,22500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(20,20,20,20,41.0000,0.0000,1641.0000,0.00,1641.0000,1641.0000,0.0000,NULL,NULL,NULL,16.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 08:43:07'),(21,21,21,21,5.0000,0.0000,12900.0000,0.00,12900.0000,12900.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(22,22,22,22,5.0000,0.0000,53287.0000,0.00,53287.0000,53287.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 08:43:06'),(23,23,23,23,2.0000,0.0000,54000.0000,0.00,54000.0000,54000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(24,24,24,24,8.0000,0.0000,32000.0000,0.00,32000.0000,32000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(25,25,25,25,26.0000,0.0000,29675.0000,0.00,29675.0000,29675.0000,0.0000,NULL,NULL,NULL,17.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 08:43:06'),(26,26,26,26,14.0000,0.0000,23500.0000,0.00,23500.0000,23500.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 12:06:10'),(27,27,27,27,9.0000,0.0000,30062.0000,0.00,30062.0000,30062.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 08:43:06'),(28,28,28,28,866.0000,0.0000,3900.0000,0.00,3900.0000,3900.0000,0.0000,NULL,NULL,NULL,357.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 12:44:19'),(29,29,29,29,177.0000,0.0000,3330.0000,0.00,3330.0000,3330.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 11:25:53'),(30,30,30,30,21.0000,0.0000,31600.0000,0.00,31600.0000,31600.0000,0.0000,NULL,NULL,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 08:43:08'),(31,31,31,31,57.0000,0.0000,21225.0000,0.00,21225.0000,21225.0000,0.0000,NULL,NULL,NULL,23.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 08:43:08'),(32,32,32,32,751.0000,0.0000,2400.0000,0.00,2400.0000,2400.0000,0.0000,NULL,NULL,NULL,467.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 13:23:59'),(33,33,33,33,263.0000,0.0000,1650.0000,0.00,1650.0000,1650.0000,0.0000,NULL,NULL,NULL,34.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 19:51:32'),(34,34,34,34,506.0000,0.0000,2400.0000,0.00,2400.0000,2400.0000,0.0000,NULL,NULL,NULL,259.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 15:43:02'),(35,35,36,36,382.0000,0.0000,4000.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,118.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:13'),(36,36,37,37,85.0000,0.0000,18000.0000,0.00,18000.0000,18000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(37,37,38,38,96.0000,0.0000,4100.0000,0.00,4100.0000,4100.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 18:32:02'),(38,38,39,39,24.0000,0.0000,8000.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 18:31:59'),(39,39,40,40,789.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,511.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-23 11:25:53'),(40,40,41,41,118.0000,0.0000,11544.0000,0.00,11544.0000,11544.0000,0.0000,NULL,NULL,NULL,103.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 15:27:58'),(41,41,42,42,19.0000,0.0000,24500.0000,0.00,24500.0000,24500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(42,42,43,43,57.0000,0.0000,31800.0000,0.00,31800.0000,31800.0000,0.0000,NULL,NULL,NULL,57.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:08'),(43,43,44,44,426.0000,0.0000,26475.0000,0.00,26475.0000,26475.0000,0.0000,NULL,NULL,NULL,116.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 20:46:50'),(44,44,45,45,358.0000,0.0000,6120.0000,0.00,6120.0000,6120.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(45,45,46,46,600.0000,0.0000,30000.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,466.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 15:27:57'),(46,46,47,47,140.0000,0.0000,19000.0000,0.00,19000.0000,19000.0000,0.0000,NULL,NULL,NULL,140.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-21 07:56:04'),(47,47,48,48,268.0000,0.0000,3500.0000,0.00,3500.0000,3500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(48,48,49,49,34.0000,0.0000,38970.0000,0.00,38970.0000,38970.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 13:36:52'),(49,49,50,50,36.0000,0.0000,6000.0000,0.00,6000.0000,6000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(50,50,51,51,596.0000,0.0000,6500.0000,0.00,6500.0000,6500.0000,0.0000,NULL,NULL,NULL,23.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:09'),(51,51,52,52,22.0000,0.0000,29000.0000,0.00,29000.0000,29000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(52,52,53,53,6.0000,0.0000,52000.0000,0.00,52000.0000,52000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(53,53,54,54,56.0000,0.0000,8000.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(54,54,55,55,60.0000,0.0000,14500.0000,0.00,14500.0000,14500.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 19:37:14'),(55,55,56,56,66.0000,0.0000,65800.0000,0.00,65800.0000,65800.0000,0.0000,NULL,NULL,NULL,64.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-23 09:43:38'),(56,56,57,57,1484.0000,0.0000,1100.0000,0.00,1100.0000,1100.0000,0.0000,NULL,NULL,NULL,611.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:08'),(57,57,58,58,156.0000,0.0000,16560.0000,0.00,16560.0000,16560.0000,0.0000,NULL,NULL,NULL,70.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-18 15:51:28'),(58,58,59,59,83.0000,0.0000,17500.0000,0.00,17500.0000,17500.0000,0.0000,NULL,NULL,NULL,83.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:04'),(59,59,60,60,12.0000,0.0000,13000.0000,0.00,13000.0000,13000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(60,60,61,61,199.0000,0.0000,4000.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,166.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 12:44:20'),(61,61,62,62,6.0000,0.0000,18000.0000,0.00,18000.0000,18000.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 20:46:49'),(62,62,63,63,32.0000,0.0000,25000.0000,0.00,25000.0000,25000.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:08'),(63,63,64,64,5.0000,0.0000,360000.0000,0.00,360000.0000,360000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(64,64,65,65,5.0000,0.0000,550000.0000,0.00,550000.0000,550000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(65,65,66,66,14.0000,0.0000,13000.0000,0.00,13000.0000,13000.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 10:10:48'),(66,66,67,67,325.0000,0.0000,4000.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,136.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-21 11:18:05'),(67,67,68,68,135.0000,0.0000,6500.0000,0.00,6500.0000,6500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(68,68,69,69,104.0000,0.0000,3300.0000,0.00,3300.0000,3300.0000,0.0000,NULL,NULL,NULL,104.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:15'),(69,69,70,70,879.0000,0.0000,2000.0000,0.00,2000.0000,2000.0000,0.0000,NULL,NULL,NULL,117.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 12:44:19'),(70,70,71,71,636.0000,0.0000,1300.0000,0.00,1300.0000,1300.0000,0.0000,NULL,NULL,NULL,122.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 20:46:49'),(71,71,72,72,548.0000,0.0000,6100.0000,0.00,6100.0000,6100.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(72,72,73,73,2.0000,0.0000,30000.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 19:37:16'),(73,73,74,74,5.0000,0.0000,20000.0000,0.00,20000.0000,20000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(74,74,75,75,184.0000,0.0000,25800.0000,0.00,25800.0000,25800.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:15'),(75,75,76,76,101.0000,0.0000,1100.0000,0.00,1100.0000,1100.0000,0.0000,NULL,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 10:10:47'),(76,76,77,77,60.0000,0.0000,9450.0000,0.00,9450.0000,9450.0000,0.0000,NULL,NULL,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 18:32:02'),(77,77,78,78,124.0000,0.0000,5000.0000,0.00,5000.0000,5000.0000,0.0000,NULL,NULL,NULL,52.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:17'),(78,78,79,79,20.0000,0.0000,2200.0000,0.00,2200.0000,2200.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(79,79,80,80,186.0000,0.0000,3530.0000,0.00,3530.0000,3530.0000,0.0000,NULL,NULL,NULL,84.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:07'),(80,80,81,81,21.0000,0.0000,3530.0000,0.00,3530.0000,3530.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-17 10:30:41'),(81,81,82,82,253.0000,0.0000,10500.0000,0.00,10500.0000,10500.0000,0.0000,NULL,NULL,NULL,97.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 14:48:59'),(82,82,83,83,30.0000,0.0000,2200.0000,0.00,2200.0000,2200.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(83,83,84,84,25.0000,0.0000,4000.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 08:43:11'),(84,84,85,85,14.0000,0.0000,8100.0000,0.00,8100.0000,8100.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 10:10:48'),(85,85,86,86,76.0000,0.0000,4200.0000,0.00,4200.0000,4200.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 13:23:58'),(86,86,87,87,160.0000,0.0000,3500.0000,0.00,3500.0000,3500.0000,0.0000,NULL,NULL,NULL,31.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 10:10:48'),(87,87,88,88,157.0000,0.0000,5200.0000,0.00,5200.0000,5200.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-22 12:44:19'),(88,88,89,89,60.0000,0.0000,4100.0000,0.00,4100.0000,4100.0000,0.0000,NULL,NULL,NULL,55.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-19 13:23:57'),(89,89,90,90,14.0000,0.0000,65000.0000,0.00,65000.0000,65000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-17 12:20:24'),(90,90,91,91,70.0000,0.0000,16000.0000,0.00,16000.0000,16000.0000,0.0000,NULL,NULL,NULL,70.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-20 20:46:53'),(91,91,92,92,62.0000,0.0000,18000.0000,0.00,18000.0000,18000.0000,0.0000,NULL,NULL,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:16'),(92,92,93,93,236.0000,0.0000,5200.0000,0.00,5200.0000,5200.0000,0.0000,NULL,NULL,NULL,118.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 09:06:23'),(93,93,94,94,73.0000,0.0000,32580.0000,0.00,32580.0000,32580.0000,0.0000,NULL,NULL,NULL,70.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 11:25:53'),(94,94,95,95,23.0000,0.0000,40000.0000,0.00,40000.0000,40000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-21 11:18:06'),(95,95,96,96,300.0000,0.0000,750.0000,0.00,750.0000,750.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 12:45:59'),(96,96,97,97,19.0000,0.0000,32000.0000,0.00,32000.0000,32000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(97,97,98,98,4.0000,0.0000,28000.0000,0.00,28000.0000,28000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(98,98,99,99,17.0000,0.0000,22000.0000,0.00,22000.0000,22000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(99,99,100,100,40.0000,0.0000,10500.0000,0.00,10500.0000,10500.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-19 13:23:59'),(100,100,101,101,16.0000,0.0000,23000.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(101,101,102,102,24.0000,0.0000,17000.0000,0.00,17000.0000,17000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(102,102,103,103,19.0000,0.0000,22000.0000,0.00,22000.0000,22000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(103,103,104,104,24.0000,0.0000,21000.0000,0.00,21000.0000,21000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(104,104,105,105,18.0000,0.0000,11000.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(105,105,106,106,15.0000,0.0000,18000.0000,0.00,18000.0000,18000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 20:46:49'),(106,106,107,107,21.0000,0.0000,18000.0000,0.00,18000.0000,18000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 18:32:01'),(107,107,108,108,18.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(108,108,109,109,635.0000,0.0000,1320.0000,0.00,1320.0000,1320.0000,0.0000,NULL,NULL,NULL,32.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 20:46:52'),(109,109,110,110,218.0000,0.0000,2200.0000,0.00,2200.0000,2200.0000,0.0000,NULL,NULL,NULL,44.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:09'),(110,110,111,111,201.0000,0.0000,3200.0000,0.00,3200.0000,3200.0000,0.0000,NULL,NULL,NULL,77.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:09'),(111,111,112,112,50.0000,0.0000,10000.0000,0.00,10000.0000,10000.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 11:25:53'),(112,112,113,113,80.0000,0.0000,2300.0000,0.00,2300.0000,2300.0000,0.0000,NULL,NULL,NULL,71.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:08'),(113,113,114,114,41.0000,0.0000,8040.0000,0.00,8040.0000,8040.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 18:32:02'),(114,114,115,115,16.0000,0.0000,19800.0000,0.00,19800.0000,19800.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(115,115,116,116,7.0000,0.0000,19800.0000,0.00,19800.0000,19800.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(116,116,117,117,146.0000,0.0000,12500.0000,0.00,12500.0000,12500.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 19:37:13'),(117,117,118,118,34.0000,0.0000,7510.0000,0.00,7510.0000,7510.0000,0.0000,NULL,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:10'),(118,118,119,119,33.0000,0.0000,8000.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:13'),(119,119,120,120,23.0000,0.0000,34200.0000,0.00,34200.0000,34200.0000,0.0000,NULL,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:12'),(120,120,121,121,164.0000,0.0000,2100.0000,0.00,2100.0000,2100.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-19 13:23:59'),(121,121,122,122,75.0000,0.0000,11000.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,75.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-21 11:18:05'),(122,122,123,123,323.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,133.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 11:58:24'),(123,123,124,124,37.0000,0.0000,9000.0000,0.00,9000.0000,9000.0000,0.0000,NULL,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 11:58:24'),(124,124,125,125,34.0000,0.0000,17000.0000,0.00,17000.0000,17000.0000,0.0000,NULL,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 20:46:53'),(125,125,126,126,384.0000,0.0000,950.0000,0.00,950.0000,950.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-20 20:46:49'),(126,126,127,127,1015.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,763.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 09:43:38'),(127,127,128,128,28.0000,0.0000,10000.0000,0.00,10000.0000,10000.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-21 14:04:39'),(128,128,129,129,3.0000,0.0000,55000.0000,0.00,55000.0000,55000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(129,129,130,130,2.0000,0.0000,45000.0000,0.00,45000.0000,45000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(130,130,131,131,44.0000,0.0000,30000.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(131,131,132,132,18.0000,0.0000,40000.0000,0.00,40000.0000,40000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-17 12:20:23'),(132,132,133,133,60.0000,0.0000,1800.0000,0.00,1800.0000,1800.0000,0.0000,NULL,NULL,NULL,34.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-22 08:43:08'),(133,133,134,134,1.0000,0.0000,30000.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(134,134,135,135,17.0000,0.0000,52000.0000,0.00,52000.0000,52000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(135,135,136,136,5.0000,0.0000,4200.0000,0.00,4200.0000,4200.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:20','2025-04-15 13:47:20'),(136,136,137,137,576.0000,0.0000,31800.0000,0.00,31800.0000,31800.0000,0.0000,NULL,NULL,NULL,576.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:22','2025-04-18 09:10:15'),(137,137,138,138,200.0000,0.0000,38970.0000,0.00,38970.0000,38970.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:22','2025-04-18 13:49:18'),(138,138,139,139,2400.0000,0.0000,8040.0000,0.00,8040.0000,8040.0000,0.0000,NULL,NULL,NULL,400.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:23','2025-04-18 10:43:56'),(139,139,140,140,920.0000,0.0000,16000.0000,0.00,16000.0000,16000.0000,0.0000,NULL,NULL,NULL,120.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-18 12:55:12'),(140,140,141,141,520.0000,0.0000,26475.0000,0.00,26475.0000,26475.0000,0.0000,NULL,NULL,NULL,280.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-21 14:43:09'),(141,141,142,142,1800.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,1100.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-18 10:12:46'),(142,142,143,143,225.0000,0.0000,11000.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,150.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-19 15:49:19'),(143,143,144,144,480.0000,0.0000,4000.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,100.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-21 14:43:10'),(144,144,145,145,320.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,160.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-18 09:25:25'),(145,145,146,146,20.0000,0.0000,550000.0000,0.00,550000.0000,550000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:25','2025-04-19 11:13:25'),(146,146,147,147,1320.0000,0.0000,4800.0000,0.00,4800.0000,4800.0000,0.0000,NULL,NULL,NULL,180.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:25','2025-04-21 08:17:09'),(147,147,148,148,1021.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,110.0000,103.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:25','2025-04-23 12:26:49'),(148,148,149,149,300.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,120.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:26','2025-04-19 11:41:06'),(149,149,150,150,240.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,240.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:26','2025-04-19 11:41:06'),(150,150,151,151,930.0000,0.0000,17000.0000,0.00,17000.0000,17000.0000,0.0000,NULL,NULL,NULL,450.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:27','2025-04-23 09:59:43'),(151,151,152,152,204.0000,0.0000,1733.3300,0.00,1733.3300,1733.3300,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:27','2025-04-23 10:00:24'),(152,152,153,153,120.0000,0.0000,132000.0000,0.00,132000.0000,132000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:29','2025-04-17 14:07:09'),(153,153,154,154,342.0000,0.0000,17333.0000,0.00,17333.0000,17333.0000,0.0000,NULL,NULL,NULL,60.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:30','2025-04-23 10:47:40'),(154,154,155,155,47.0000,0.0000,21225.0000,0.00,21225.0000,21225.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:31','2025-04-15 13:47:31'),(155,155,156,156,34.0000,0.0000,31600.0000,0.00,31600.0000,31600.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:32','2025-04-15 13:47:32'),(156,156,157,157,5400.0000,0.0000,2400.0000,0.00,2400.0000,2400.0000,0.0000,NULL,NULL,NULL,4200.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:33','2025-04-18 09:25:25'),(157,157,158,158,70.0000,0.0000,12900.0000,0.00,12900.0000,12900.0000,0.0000,NULL,NULL,NULL,42.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:34','2025-04-19 11:36:29'),(158,158,159,159,45.0000,0.0000,65000.0000,0.00,65000.0000,65000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:34','2025-04-17 15:07:28'),(159,159,160,160,600.0000,0.0000,1300.0000,0.00,1300.0000,1300.0000,0.0000,NULL,NULL,NULL,300.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:35','2025-04-18 11:56:28'),(160,160,161,161,520.0000,0.0000,32580.0000,0.00,32580.0000,32580.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:35','2025-04-17 15:12:53'),(161,161,162,162,1500.0000,0.0000,4000.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:36','2025-04-17 15:17:18'),(162,162,163,163,1500.0000,0.0000,4500.0000,0.00,4500.0000,4500.0000,0.0000,NULL,NULL,NULL,1500.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:36','2025-04-18 09:25:25'),(163,163,164,164,500.0000,0.0000,4045.0000,0.00,4045.0000,4045.0000,0.0000,NULL,NULL,NULL,300.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:37','2025-04-18 09:25:25'),(164,164,165,165,420.0000,0.0000,65800.0000,0.00,65800.0000,65800.0000,0.0000,NULL,NULL,NULL,120.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:38','2025-04-18 10:35:47'),(165,165,166,166,23000.0000,0.0000,1100.0000,0.00,1100.0000,1100.0000,0.0000,NULL,NULL,NULL,6000.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:38','2025-04-18 13:41:39'),(166,166,167,167,1100.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,400.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:39','2025-04-23 12:26:49'),(167,167,168,168,175.0000,0.0000,3500.0000,0.00,3500.0000,3500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:39','2025-04-17 15:28:08'),(168,168,169,169,30.0000,0.0000,14500.0000,0.00,14500.0000,14500.0000,0.0000,NULL,NULL,NULL,30.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:39','2025-04-18 10:35:47'),(169,169,170,170,250.0000,0.0000,2000.0000,0.00,2000.0000,2000.0000,0.0000,NULL,NULL,NULL,250.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:40','2025-04-18 10:35:47'),(170,170,171,171,400.0000,0.0000,6800.0000,0.00,6800.0000,6800.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:40','2025-04-17 16:24:21'),(171,171,172,172,20.0000,0.0000,6200.0000,0.00,6200.0000,6200.0000,0.0000,NULL,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:41','2025-04-18 10:35:47'),(172,172,173,173,72.0000,0.0000,19800.0000,0.00,19800.0000,19800.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:41','2025-04-17 15:33:57'),(173,173,174,174,36.0000,0.0000,36000.0000,0.00,36000.0000,36000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:43','2025-04-17 15:35:01'),(174,174,175,175,1000.0000,0.0000,23000.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:35:46'),(175,175,176,176,48.0000,0.0000,7089.0000,0.00,7089.0000,7089.0000,0.0000,NULL,NULL,NULL,48.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-18 11:56:29'),(176,176,177,177,324.0000,0.0000,23000.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:37:18'),(177,177,178,178,240.0000,0.0000,6000.0000,0.00,6000.0000,6000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:43:57'),(178,178,179,179,40.0000,0.0000,11000.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:45:18'),(179,179,180,180,1296.0000,0.0000,17000.0000,0.00,17000.0000,17000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:47:08'),(180,180,181,181,576.0000,0.0000,29000.0000,0.00,29000.0000,29000.0000,0.0000,NULL,NULL,NULL,48.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-18 14:05:32'),(181,181,182,182,324.0000,0.0000,29000.0000,0.00,29000.0000,29000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:49:45'),(182,182,183,183,16.0000,0.0000,34200.0000,0.00,34200.0000,34200.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 15:50:40'),(183,183,184,184,24.0000,0.0000,25000.0000,0.00,25000.0000,25000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 15:51:18'),(184,184,185,185,72.0000,0.0000,18000.0000,0.00,18000.0000,18000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 15:52:27'),(185,185,186,186,600.0000,0.0000,3510.0000,0.00,3510.0000,3510.0000,0.0000,NULL,NULL,NULL,300.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-18 13:44:14'),(186,186,187,187,216.0000,0.0000,17000.0000,0.00,17000.0000,17000.0000,0.0000,NULL,NULL,NULL,112.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-19 11:27:37'),(187,187,188,188,288.0000,0.0000,13700.0000,0.00,13700.0000,13700.0000,0.0000,NULL,NULL,NULL,112.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:46','2025-04-19 11:27:37'),(188,188,189,189,144.0000,0.0000,19800.0000,0.00,19800.0000,19800.0000,0.0000,NULL,NULL,NULL,112.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:46','2025-04-19 11:27:37'),(189,189,190,190,500.0000,0.0000,3247.0000,0.00,3247.0000,3247.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:46','2025-04-17 16:05:41'),(190,190,191,191,480.0000,0.0000,4700.0000,0.00,4700.0000,4700.0000,0.0000,NULL,NULL,NULL,142.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:47','2025-04-23 12:26:49'),(191,191,192,192,400.0000,0.0000,3350.0000,0.00,3350.0000,3350.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:47','2025-04-17 16:06:50'),(192,192,193,193,600.0000,0.0000,8402.0000,0.00,8402.0000,8402.0000,0.0000,NULL,NULL,NULL,112.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:48','2025-04-23 12:26:49'),(193,193,194,194,480.0000,0.0000,6284.0000,0.00,6284.0000,6284.0000,0.0000,NULL,NULL,NULL,76.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:48','2025-04-23 12:26:49'),(194,194,195,195,6480.0000,0.0000,8000.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,3700.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:49','2025-04-18 12:55:12'),(195,195,196,196,4800.0000,0.0000,2431.0000,0.00,2431.0000,2431.0000,0.0000,NULL,NULL,NULL,3349.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:49','2025-04-19 15:49:18'),(196,196,197,197,200.0000,0.0000,28000.0000,0.00,28000.0000,28000.0000,0.0000,NULL,NULL,NULL,182.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:50','2025-04-21 14:43:10'),(197,197,198,198,500.0000,0.0000,16677.0000,0.00,16677.0000,16677.0000,0.0000,NULL,NULL,NULL,200.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:50','2025-04-19 15:49:18'),(198,198,199,199,960.0000,0.0000,23000.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,590.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:50','2025-04-21 14:43:10'),(199,199,200,200,400.0000,0.0000,8470.0000,0.00,8470.0000,8470.0000,0.0000,NULL,NULL,NULL,280.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:51','2025-04-21 14:43:10'),(200,200,201,201,480.0000,0.0000,19000.0000,0.00,19000.0000,19000.0000,0.0000,NULL,NULL,NULL,384.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:51','2025-04-18 11:25:14'),(201,201,202,202,310.0000,0.0000,34000.0000,0.00,34000.0000,34000.0000,0.0000,NULL,NULL,NULL,240.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:51','2025-04-18 12:55:12'),(202,202,203,203,240.0000,0.0000,45000.0000,0.00,45000.0000,45000.0000,0.0000,NULL,NULL,NULL,240.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:52','2025-04-18 12:01:32'),(203,203,204,204,90.0000,0.0000,66000.0000,0.00,66000.0000,66000.0000,0.0000,NULL,NULL,NULL,84.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-15 13:47:52','2025-04-18 12:55:12'),(236,208,137,137,1.0000,0.0000,0.0000,0.00,31800.0000,31800.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-17 07:00:33','2025-04-17 07:00:33'),(237,226,205,205,470.0000,0.0000,27000.0000,0.00,27000.0000,27000.0000,0.0000,NULL,NULL,NULL,240.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-17 14:22:19','2025-04-18 09:30:50'),(238,227,207,207,1.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 08:19:06','2025-04-18 08:19:06'),(239,228,206,206,1500.0000,0.0000,14000.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,1050.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 08:48:36','2025-04-21 14:43:09'),(240,230,137,137,23.0000,0.0000,0.0000,0.00,31800.0000,31800.0000,0.0000,NULL,NULL,NULL,23.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 08:53:58','2025-04-22 08:43:08'),(241,232,167,167,200.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:05:36','2025-04-21 17:30:55'),(242,234,137,137,552.0000,0.0000,0.0000,0.00,31800.0000,31800.0000,0.0000,NULL,NULL,NULL,84.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:10:14','2025-04-22 08:43:08'),(243,236,164,164,300.0000,0.0000,0.0000,0.00,4045.0000,4045.0000,0.0000,NULL,NULL,NULL,170.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:25:25','2025-04-22 08:43:12'),(244,236,157,157,4200.0000,0.0000,0.0000,0.00,2400.0000,2400.0000,0.0000,NULL,NULL,NULL,419.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:25:25','2025-04-22 12:44:19'),(245,236,163,163,1500.0000,0.0000,0.0000,0.00,4500.0000,4500.0000,0.0000,NULL,NULL,NULL,322.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:25:25','2025-04-23 11:58:24'),(246,236,145,145,160.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(247,236,166,166,5000.0000,0.0000,0.0000,0.00,1100.0000,1100.0000,0.0000,NULL,NULL,NULL,838.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:25:25','2025-04-23 11:53:15'),(248,238,205,205,240.0000,0.0000,0.0000,0.00,27000.0000,27000.0000,0.0000,NULL,NULL,NULL,45.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:30:50','2025-04-19 13:23:58'),(249,239,208,208,272.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,NULL,112.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:37:40','2025-04-18 09:46:11'),(250,240,208,208,272.0000,0.0000,31600.0000,0.00,31600.0000,31600.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:44:03','2025-04-18 09:44:03'),(251,242,208,208,112.0000,0.0000,0.0000,0.00,31600.0000,31600.0000,0.0000,NULL,NULL,NULL,40.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:46:11','2025-04-20 18:32:01'),(252,244,140,140,80.0000,0.0000,0.0000,0.00,16000.0000,16000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 09:48:45','2025-04-22 12:44:19'),(253,246,151,151,390.0000,0.0000,0.0000,0.00,104000.0000,104000.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:04:10','2025-04-23 11:25:54'),(254,246,142,142,900.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,318.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:04:10','2025-04-22 12:44:19'),(255,248,142,142,200.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(256,248,202,202,10.0000,0.0000,0.0000,0.00,34000.0000,34000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(257,248,197,197,16.0000,0.0000,0.0000,0.00,28000.0000,28000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(258,248,195,195,60.0000,0.0000,0.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(259,248,199,199,30.0000,0.0000,0.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(260,250,206,206,900.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,685.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-19 13:23:57'),(261,250,141,141,80.0000,0.0000,0.0000,0.00,26475.0000,26475.0000,0.0000,NULL,NULL,NULL,16.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-22 08:43:10'),(262,250,165,165,120.0000,0.0000,0.0000,0.00,65800.0000,65800.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-20 20:46:52'),(263,250,170,170,250.0000,0.0000,0.0000,0.00,2000.0000,2000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(264,250,172,172,20.0000,0.0000,0.0000,0.00,6200.0000,6200.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(265,250,169,169,30.0000,0.0000,0.0000,0.00,14500.0000,14500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(266,252,139,139,400.0000,0.0000,0.0000,0.00,8040.0000,8040.0000,0.0000,NULL,NULL,NULL,110.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:43:55','2025-04-19 07:46:36'),(267,252,154,154,60.0000,0.0000,0.0000,0.00,104000.0000,104000.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:43:55','2025-04-23 10:08:04'),(268,252,143,143,75.0000,0.0000,0.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,29.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 10:43:55','2025-04-22 15:27:57'),(269,254,203,203,16.0000,0.0000,0.0000,0.00,45000.0000,45000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:24:25','2025-04-18 11:24:25'),(270,256,148,148,60.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(271,256,149,149,60.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(272,256,201,201,384.0000,0.0000,0.0000,0.00,19000.0000,19000.0000,0.0000,NULL,NULL,NULL,176.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:25:13','2025-04-22 08:43:13'),(273,256,202,202,220.0000,0.0000,0.0000,0.00,34000.0000,34000.0000,0.0000,NULL,NULL,NULL,105.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:25:13','2025-04-22 16:02:20'),(274,256,203,203,208.0000,0.0000,0.0000,0.00,45000.0000,45000.0000,0.0000,NULL,NULL,NULL,166.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:25:13','2025-04-23 11:58:24'),(275,258,204,204,78.0000,0.0000,0.0000,0.00,66000.0000,66000.0000,0.0000,NULL,NULL,NULL,47.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-22 08:43:13'),(276,258,198,198,150.0000,0.0000,0.0000,0.00,16677.0000,16677.0000,0.0000,NULL,NULL,NULL,83.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-22 08:43:17'),(277,258,200,200,240.0000,0.0000,0.0000,0.00,8470.0000,8470.0000,0.0000,NULL,NULL,NULL,128.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-22 08:43:13'),(278,258,197,197,152.0000,0.0000,0.0000,0.00,28000.0000,28000.0000,0.0000,NULL,NULL,NULL,92.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-23 11:25:53'),(279,258,196,196,3289.0000,0.0000,0.0000,0.00,2431.0000,2431.0000,0.0000,NULL,NULL,NULL,771.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-23 11:58:24'),(280,258,195,195,3600.0000,0.0000,0.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,1471.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-23 09:43:38'),(281,258,160,160,300.0000,0.0000,0.0000,0.00,1300.0000,1300.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(282,258,147,147,120.0000,0.0000,0.0000,0.00,4800.0000,4800.0000,0.0000,NULL,NULL,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-22 08:43:18'),(283,258,176,176,48.0000,0.0000,0.0000,0.00,7089.0000,7089.0000,0.0000,NULL,NULL,NULL,32.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-22 08:43:11'),(284,260,141,141,80.0000,0.0000,0.0000,0.00,26475.0000,26475.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(285,260,206,206,50.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(286,260,203,203,8.0000,0.0000,0.0000,0.00,45000.0000,45000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(287,262,141,141,80.0000,0.0000,0.0000,0.00,26475.0000,26475.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:01:29','2025-04-18 12:01:29'),(288,262,206,206,50.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:01:30','2025-04-18 12:01:30'),(289,262,203,203,8.0000,0.0000,0.0000,0.00,45000.0000,45000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:01:30','2025-04-18 12:01:30'),(290,264,202,202,10.0000,0.0000,0.0000,0.00,34000.0000,34000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(291,264,204,204,6.0000,0.0000,0.0000,0.00,66000.0000,66000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(292,264,140,140,40.0000,0.0000,0.0000,0.00,16000.0000,16000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(293,264,195,195,40.0000,0.0000,0.0000,0.00,8000.0000,8000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(294,265,209,209,250.0000,0.0000,3300.0000,0.00,3300.0000,3300.0000,0.0000,NULL,NULL,NULL,100.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:18:38','2025-04-18 13:31:14'),(295,266,210,210,2040.0000,0.0000,30000.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,80.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:27:31','2025-04-21 14:43:11'),(296,268,209,209,100.0000,0.0000,0.0000,0.00,3300.0000,3300.0000,0.0000,NULL,NULL,NULL,47.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:31:13','2025-04-22 08:43:15'),(297,270,210,210,40.0000,0.0000,0.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:34:46','2025-04-20 20:46:52'),(298,272,166,166,1000.0000,0.0000,0.0000,0.00,1100.0000,1100.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:41:38','2025-04-18 13:41:38'),(299,274,186,186,300.0000,0.0000,0.0000,0.00,3510.0000,3510.0000,0.0000,NULL,NULL,NULL,130.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:44:13','2025-04-22 08:43:07'),(300,276,138,138,1.0000,0.0000,0.0000,0.00,38970.0000,38970.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 13:49:18','2025-04-18 13:49:18'),(301,278,181,181,48.0000,0.0000,0.0000,0.00,29000.0000,29000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 14:05:31','2025-04-18 14:05:31'),(302,280,199,199,490.0000,0.0000,0.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,204.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 14:19:08','2025-04-22 10:21:28'),(303,282,211,211,200.0000,0.0000,12000.0000,0.00,12000.0000,12000.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-18 19:47:04','2025-04-18 19:57:36'),(304,289,146,146,1.0000,0.0000,0.0000,0.00,550000.0000,550000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:13:25','2025-04-19 11:13:25'),(305,291,188,188,112.0000,0.0000,0.0000,0.00,13700.0000,13700.0000,0.0000,NULL,NULL,NULL,61.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:27:36','2025-04-22 15:27:57'),(306,291,187,187,112.0000,0.0000,0.0000,0.00,17000.0000,17000.0000,0.0000,NULL,NULL,NULL,46.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:27:36','2025-04-22 14:48:59'),(307,291,189,189,112.0000,0.0000,0.0000,0.00,19800.0000,19800.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:27:36','2025-04-20 18:32:01'),(308,293,158,158,42.0000,0.0000,0.0000,0.00,12900.0000,12900.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:36:28','2025-04-22 08:43:07'),(309,295,150,150,240.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:41:05','2025-04-19 11:41:05'),(310,295,149,149,60.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 11:41:05','2025-04-19 11:41:05'),(311,297,212,212,1400.0000,0.0000,19000.0000,0.00,19000.0000,19000.0000,0.0000,NULL,NULL,NULL,500.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 13:43:30','2025-04-19 13:46:21'),(312,299,212,212,500.0000,0.0000,0.0000,0.00,19000.0000,19000.0000,0.0000,NULL,NULL,NULL,75.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 13:46:21','2025-04-21 13:51:07'),(313,304,149,149,300.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:35:15','2025-04-19 15:35:15'),(314,304,148,148,300.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:35:15','2025-04-19 15:35:15'),(315,304,150,150,600.0000,0.0000,75000.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,150.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:35:15','2025-04-23 12:26:49'),(316,306,196,196,60.0000,0.0000,0.0000,0.00,2431.0000,2431.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(317,306,198,198,50.0000,0.0000,0.0000,0.00,16677.0000,16677.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(318,306,143,143,75.0000,0.0000,0.0000,0.00,11000.0000,11000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(319,306,150,150,90.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(320,306,151,151,60.0000,0.0000,0.0000,0.00,104000.0000,104000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(321,306,199,199,20.0000,0.0000,0.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(322,313,147,147,60.0000,0.0000,0.0000,0.00,4800.0000,4800.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 08:17:09','2025-04-21 08:17:09'),(323,316,213,213,600.0000,0.0000,4500.0000,0.00,4500.0000,4500.0000,0.0000,NULL,NULL,NULL,50.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 09:10:09','2025-04-21 09:20:51'),(324,318,213,213,50.0000,0.0000,0.0000,0.00,4500.0000,4500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 09:20:50','2025-04-21 09:20:50'),(325,327,141,141,40.0000,0.0000,0.0000,0.00,26475.0000,26475.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(326,327,206,206,50.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(327,327,167,167,100.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(328,327,197,197,14.0000,0.0000,0.0000,0.00,28000.0000,28000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(329,327,200,200,40.0000,0.0000,0.0000,0.00,8470.0000,8470.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(330,327,144,144,100.0000,0.0000,0.0000,0.00,4000.0000,4000.0000,0.0000,NULL,NULL,NULL,100.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-22 08:43:05'),(331,327,199,199,50.0000,0.0000,0.0000,0.00,23000.0000,23000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(332,327,210,210,40.0000,0.0000,0.0000,0.00,30000.0000,30000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(333,367,194,194,76.0000,0.0000,0.0000,0.00,6284.0000,6284.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(334,367,191,191,142.0000,0.0000,0.0000,0.00,4700.0000,4700.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(335,367,193,193,112.0000,0.0000,0.0000,0.00,8402.0000,8402.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(336,367,167,167,100.0000,0.0000,0.0000,0.00,14000.0000,14000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(337,367,150,150,60.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(338,367,148,148,50.0000,0.0000,0.0000,0.00,75000.0000,75000.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(339,368,215,215,2000.0000,0.0000,750.0000,0.00,750.0000,750.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-23 13:11:32','2025-04-23 13:11:32');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',5,1,'2025-04-15 12:40:23','2025-04-19 15:26:53'),(2,'business_location',2,1,'2025-04-15 12:40:23','2025-04-15 13:36:49'),(3,'stock_adjustment',1,1,'2025-04-15 16:42:36','2025-04-15 16:42:36'),(5,'stock_transfer',35,1,'2025-04-17 07:00:32','2025-04-23 12:26:44'),(6,'sell_payment',75,1,'2025-04-17 08:14:16','2025-04-23 11:58:23'),(7,'purchase',8,1,'2025-04-18 08:48:35','2025-04-23 13:11:31'),(8,'contacts',1,2,'2025-04-18 16:44:04','2025-04-18 16:44:04'),(9,'business_location',1,2,'2025-04-18 16:44:05','2025-04-18 16:44:05'),(10,'draft',2,2,'2025-04-18 19:48:29','2025-04-18 19:51:12'),(11,'sell_payment',1,2,'2025-04-18 19:57:36','2025-04-18 19:57:36'),(12,'expense',13,1,'2025-04-21 17:39:36','2025-04-22 13:20:51'),(13,'expense_payment',3,1,'2025-04-22 11:17:19','2025-04-22 11:18:01');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (1,3),(2,3),(3,3),(6,3),(7,3),(8,3),(9,3),(10,3),(16,3),(17,3),(21,3),(22,3),(25,2),(25,3),(25,7),(26,2),(26,3),(26,7),(28,3),(29,3),(30,3),(32,3),(33,3),(34,3),(35,3),(36,3),(37,3),(38,3),(39,3),(40,3),(41,3),(42,3),(43,3),(44,3),(45,3),(46,3),(47,3),(48,2),(48,3),(48,7),(49,2),(49,3),(49,7),(50,2),(50,3),(50,7),(51,2),(51,3),(51,7),(52,3),(53,3),(54,3),(56,3),(59,3),(63,3),(64,3),(65,3),(66,3),(71,3),(72,3),(73,3),(74,3),(80,2),(80,7),(81,3),(83,3),(84,3),(85,3),(89,3),(90,3),(92,3),(93,3),(94,3),(95,3),(96,3),(97,3),(98,3),(99,3),(101,3),(102,3),(103,3),(104,3),(106,3),(107,3),(108,3),(109,3),(110,3),(111,3),(112,3),(113,3),(114,3),(115,3),(116,3),(117,3),(119,3),(124,3),(125,3),(126,3),(128,3),(129,3),(130,3),(131,3);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_service_staff` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(2,'Cashier#1','web',1,0,0,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(3,'System Admin#1','web',1,0,0,'2025-04-15 13:00:43','2025-04-15 17:51:29'),(4,'System Manager#1','web',1,0,0,'2025-04-15 17:40:00','2025-04-15 17:40:00'),(5,'Director#1','web',1,0,0,'2025-04-15 17:41:32','2025-04-15 17:41:32'),(6,'Admin#2','web',2,1,0,'2025-04-18 16:44:03','2025-04-18 16:44:03'),(7,'Cashier#2','web',2,0,0,'2025-04-18 16:44:04','2025-04-18 16:44:04');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
INSERT INTO `stock_adjustment_lines` VALUES (1,204,148,148,103.0000,0.0000,75000.0000,NULL,NULL,'2025-04-15 16:42:36','2025-04-15 16:42:36');
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(22,4) NOT NULL,
  `package_details` longtext NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) DEFAULT NULL,
  `payment_transaction_id` varchar(191) DEFAULT NULL,
  `status` enum('approved','waiting','declined') NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  KEY `subscriptions_package_id_index` (`package_id`),
  KEY `subscriptions_created_id_index` (`created_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (2,1,1,'2025-04-15','2026-04-15','2026-04-15',0.0000,'{\"location_count\":2,\"user_count\":3,\"product_count\":1000,\"invoice_count\":0,\"name\":\"Advanced Package\"}',2,'offline','paid Once time cost','approved',NULL,'2025-04-15 13:28:45','2025-04-15 13:28:45'),(3,2,1,'2025-04-18','2026-04-18','2026-04-18',0.0000,'{\"location_count\":2,\"user_count\":3,\"product_count\":1000,\"invoice_count\":0,\"name\":\"Advanced Package\"}',2,'offline','Testing hii haina shida','approved',NULL,'2025-04-18 16:44:34','2025-04-18 16:44:34');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_communicator_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_communicator_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_ids` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_communicator_logs` WRITE;
/*!40000 ALTER TABLE `superadmin_communicator_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_communicator_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_frontend_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_frontend_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) DEFAULT NULL,
  `slug` varchar(191) NOT NULL,
  `content` longtext NOT NULL,
  `is_shown` tinyint(1) NOT NULL,
  `menu_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_frontend_pages` WRITE;
/*!40000 ALTER TABLE `superadmin_frontend_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_frontend_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','6.6'),(2,'default_business_active_status','1'),(3,'superadmin_version','2.2'),(4,'app_currency_id','138'),(5,'invoice_business_name','SmartPOs'),(6,'invoice_business_landmark','Melian Software Company Limited'),(7,'invoice_business_zip','Zip'),(8,'invoice_business_state','State'),(9,'invoice_business_city','Dar es salaam'),(10,'invoice_business_country','Tanzania'),(11,'email','support@meliansoftware.com'),(12,'package_expiry_alert_days','20'),(13,'enable_business_based_username','0'),(14,'superadmin_register_tc',NULL),(15,'welcome_email_subject',NULL),(16,'welcome_email_body',NULL),(17,'additional_js',NULL),(18,'additional_css',NULL),(19,'offline_payment_details','Cash Payment at the Office'),(20,'superadmin_enable_register_tc','0'),(21,'allow_email_settings_to_businesses','0'),(22,'enable_new_business_registration_notification','0'),(23,'enable_new_subscription_notification','0'),(24,'enable_welcome_email','0'),(25,'enable_offline_payment','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `for_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `method` varchar(191) DEFAULT NULL,
  `payment_type` varchar(191) DEFAULT NULL,
  `transaction_no` varchar(191) DEFAULT NULL,
  `card_transaction_number` varchar(191) DEFAULT NULL,
  `card_number` varchar(191) DEFAULT NULL,
  `card_type` varchar(191) DEFAULT NULL,
  `card_holder_name` varchar(191) DEFAULT NULL,
  `card_month` varchar(191) DEFAULT NULL,
  `card_year` varchar(191) DEFAULT NULL,
  `card_security` varchar(5) DEFAULT NULL,
  `cheque_number` varchar(191) DEFAULT NULL,
  `bank_account_number` varchar(191) DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT 0,
  `gateway` varchar(191) DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT 0,
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `payment_ref_no` varchar(191) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,209,1,0,888000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-18 09:59:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0001',NULL,'2025-04-17 08:14:16','2025-04-17 08:14:16'),(2,210,1,0,888000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-18 09:59:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0002',NULL,'2025-04-17 08:16:53','2025-04-17 08:16:53'),(3,211,1,0,100000.0000,'bank_transfer',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 10:34:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0003',NULL,'2025-04-17 08:38:25','2025-04-17 08:38:25'),(4,212,1,0,720000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-18 10:39:00',1,0,NULL,0,2,NULL,NULL,NULL,'SP2025/0004',NULL,'2025-04-17 08:50:15','2025-04-17 08:50:15'),(5,213,1,0,1140000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-18 10:51:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0005',NULL,'2025-04-17 08:53:08','2025-04-17 08:53:08'),(6,214,1,0,170000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 10:54:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0006',NULL,'2025-04-17 08:56:29','2025-04-17 08:56:29'),(7,215,1,0,1750000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 10:56:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0007',NULL,'2025-04-17 09:09:13','2025-04-17 09:09:13'),(8,216,1,0,3978000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 11:09:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0008',NULL,'2025-04-17 09:22:09','2025-04-17 09:22:09'),(9,217,1,0,45000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 11:24:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0009',NULL,'2025-04-17 09:34:12','2025-04-17 09:34:12'),(10,218,1,0,4800000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 11:41:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0010',NULL,'2025-04-17 09:43:52','2025-04-17 09:43:52'),(11,219,1,0,690000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 11:44:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0011',NULL,'2025-04-17 09:51:35','2025-04-17 09:51:35'),(12,220,1,0,8252500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 11:52:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0012',NULL,'2025-04-17 10:30:39','2025-04-17 10:30:39'),(13,221,1,0,77000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 12:36:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0013',NULL,'2025-04-17 10:41:40','2025-04-17 10:41:40'),(14,222,1,0,530000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 12:42:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0014',NULL,'2025-04-17 10:51:18','2025-04-17 10:51:18'),(15,223,1,0,120000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 13:10:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0015',NULL,'2025-04-17 11:15:41','2025-04-17 11:15:41'),(16,224,1,0,10967000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 13:16:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0016',NULL,'2025-04-17 12:20:21','2025-04-17 12:20:21'),(18,281,1,0,23038000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 16:59:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0017',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(19,284,2,0,30000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:56:00',4,0,NULL,0,5,NULL,NULL,NULL,'SP2025/0001',NULL,'2025-04-18 19:57:36','2025-04-18 19:57:36'),(20,285,1,0,4104000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 09:38:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0018',NULL,'2025-04-19 07:39:47','2025-04-19 07:39:47'),(21,286,1,0,4287000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 09:40:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0019',NULL,'2025-04-19 07:46:36','2025-04-19 07:46:36'),(22,287,1,0,17945100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 09:51:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0020',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(23,296,1,0,65721250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 13:45:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0021',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(24,300,1,0,700000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 16:20:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0022',NULL,'2025-04-19 14:50:17','2025-04-19 14:50:17'),(25,301,1,0,10000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 16:52:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0023',NULL,'2025-04-19 14:54:06','2025-04-19 14:54:06'),(26,302,1,0,2964000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 16:54:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0024',NULL,'2025-04-19 15:11:23','2025-04-19 15:11:23'),(27,303,1,0,672000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-03-25 17:12:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0025',NULL,'2025-04-19 15:16:05','2025-04-23 10:28:05'),(28,307,1,0,1780000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 18:54:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0026',NULL,'2025-04-20 18:31:55','2025-04-20 18:31:55'),(29,308,1,0,817500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 20:52:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0027',NULL,'2025-04-20 19:37:03','2025-04-20 19:37:03'),(30,309,1,0,282000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 21:37:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0028',NULL,'2025-04-20 19:51:22','2025-04-20 19:51:22'),(31,310,1,0,2153000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 21:51:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0029',NULL,'2025-04-20 20:46:43','2025-04-20 20:46:43'),(32,311,1,0,2288000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 09:30:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0030',NULL,'2025-04-21 07:56:03','2025-04-21 07:56:03'),(33,314,1,0,224000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 10:17:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0031',NULL,'2025-04-21 08:44:09','2025-04-21 08:44:09'),(34,315,1,0,86000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 10:57:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0032',NULL,'2025-04-21 09:03:06','2025-04-21 09:03:06'),(35,319,1,0,90000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 11:16:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0033',NULL,'2025-04-21 09:30:34','2025-04-21 09:30:34'),(36,320,1,0,328000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 12:53:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0034',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(37,321,1,0,40000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 13:21:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0035',NULL,'2025-04-21 11:25:33','2025-04-21 11:25:33'),(38,322,1,0,111000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 13:49:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0036',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(39,323,1,0,54000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 14:57:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0037',NULL,'2025-04-21 13:13:00','2025-04-21 13:13:00'),(40,324,1,0,280900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 15:32:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0038',NULL,'2025-04-21 13:51:02','2025-04-21 13:51:02'),(41,325,1,0,276500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 16:11:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0039',NULL,'2025-04-21 14:17:38','2025-04-21 14:17:38'),(42,328,1,0,35000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 17:17:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0040',NULL,'2025-04-21 15:17:57','2025-04-21 15:17:57'),(43,329,1,0,85000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 17:21:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0041',NULL,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(44,330,1,0,495000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 18:56:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0042',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(45,331,1,0,26000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 19:29:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0043',NULL,'2025-04-21 17:30:54','2025-04-21 17:30:54'),(46,332,1,0,14000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 19:33:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0044',NULL,'2025-04-21 17:39:36','2025-04-21 17:39:36'),(47,333,1,0,30000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 19:40:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0045',NULL,'2025-04-21 17:41:30','2025-04-21 17:41:30'),(48,334,1,0,63773000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 09:05:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0046',NULL,'2025-04-22 08:42:58','2025-04-22 08:42:58'),(49,335,1,0,115000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 10:52:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0047',NULL,'2025-04-22 09:06:22','2025-04-22 09:06:22'),(50,339,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 11:31:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0048',NULL,'2025-04-22 09:32:48','2025-04-22 09:32:48'),(51,340,1,0,538000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 12:17:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0049',NULL,'2025-04-22 10:21:27','2025-04-22 10:21:27'),(52,341,1,0,556000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 12:51:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0050',NULL,'2025-04-22 11:04:36','2025-04-22 11:04:36'),(53,342,1,0,45000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:14:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0051',NULL,'2025-04-22 11:15:45','2025-04-22 11:15:45'),(54,338,1,0,80000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:17:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'2025/0001',NULL,'2025-04-22 11:17:19','2025-04-22 11:17:19'),(55,337,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:17:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'2025/0002',NULL,'2025-04-22 11:17:42','2025-04-22 11:17:42'),(56,336,1,0,150000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:17:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'2025/0003',NULL,'2025-04-22 11:18:01','2025-04-22 11:18:01'),(57,343,1,0,60000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 13:42:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0052',NULL,'2025-04-22 11:42:53','2025-04-22 11:43:46'),(58,344,1,0,180000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:54:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0053',NULL,'2025-04-22 12:06:10','2025-04-22 12:06:10'),(59,345,1,0,355500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 14:27:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0054',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(60,346,1,0,14000.0000,'card',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 14:52:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0055',NULL,'2025-04-22 12:55:36','2025-04-22 12:55:36'),(61,347,1,0,30000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:03:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0056',NULL,'2025-04-22 13:04:43','2025-04-22 13:04:43'),(62,348,1,0,150000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:04:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0057',NULL,'2025-04-22 13:06:25','2025-04-22 13:06:25'),(63,349,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:08:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0058',NULL,'2025-04-22 13:10:02','2025-04-22 13:10:02'),(64,350,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:10:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0059',NULL,'2025-04-22 13:15:10','2025-04-22 13:15:10'),(65,351,1,0,80000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:15:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0060',NULL,'2025-04-22 13:19:36','2025-04-22 13:19:36'),(66,352,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:20:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2025/0061',NULL,'2025-04-22 13:20:58','2025-04-22 13:20:58'),(67,353,1,0,335000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:31:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0062',NULL,'2025-04-22 13:36:51','2025-04-22 13:36:51'),(68,354,1,0,111000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 16:00:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0063',NULL,'2025-04-22 14:08:29','2025-04-22 14:08:29'),(69,355,1,0,10500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 16:25:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0064',NULL,'2025-04-22 14:31:25','2025-04-22 14:31:25'),(70,356,1,0,580500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 16:42:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0065',NULL,'2025-04-22 14:48:58','2025-04-22 14:48:58'),(71,357,1,0,2212000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 16:56:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0066',NULL,'2025-04-22 15:27:55','2025-04-22 15:30:54'),(72,357,1,1,11000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 17:30:54',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0067',NULL,'2025-04-22 15:30:55','2025-04-22 15:30:55'),(73,358,1,0,83000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 17:38:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0068',NULL,'2025-04-22 15:42:59','2025-04-22 15:42:59'),(74,359,1,0,158000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 17:58:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0069',NULL,'2025-04-22 16:02:19','2025-04-22 16:02:19'),(75,360,1,0,45000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 18:04:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0070',NULL,'2025-04-22 16:05:34','2025-04-22 16:05:34'),(76,361,1,0,816000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 11:37:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0071',NULL,'2025-04-23 09:43:37','2025-04-23 09:43:37'),(77,362,1,0,310000.0000,'bank_transfer',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 11:44:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0072',NULL,'2025-04-23 10:08:03','2025-04-23 10:08:03'),(78,363,1,0,741000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 13:11:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0073',NULL,'2025-04-23 11:25:52','2025-04-23 11:25:52'),(79,364,1,0,90000.0000,'custom_pay_1',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 13:51:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0074',NULL,'2025-04-23 11:53:15','2025-04-23 11:53:15'),(80,365,1,0,155000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 13:53:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0075',NULL,'2025-04-23 11:58:23','2025-04-23 11:58:23');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text DEFAULT NULL,
  `so_line_id` int(11) DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`),
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`),
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`),
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=579 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (33,207,137,137,1.0000,0.0000,0.0000,31800.0000,31800.0000,NULL,0.0000,31800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 07:00:33','2025-04-17 07:00:33'),(34,209,123,123,37.0000,0.0000,0.0000,24000.0000,24000.0000,'fixed',0.0000,24000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 08:14:16','2025-04-17 08:14:16'),(35,210,123,123,37.0000,0.0000,0.0000,24000.0000,24000.0000,'fixed',0.0000,24000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 08:16:53','2025-04-17 08:16:53'),(36,211,117,117,5.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 08:38:24','2025-04-17 08:38:24'),(37,212,122,122,36.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 08:50:14','2025-04-17 08:50:14'),(38,213,43,43,30.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 08:53:07','2025-04-17 08:53:07'),(39,214,51,51,17.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 08:56:29','2025-04-17 08:56:29'),(40,215,58,58,70.0000,0.0000,0.0000,25000.0000,25000.0000,'fixed',0.0000,25000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 09:09:12','2025-04-17 09:09:12'),(41,216,127,127,234.0000,0.0000,0.0000,17000.0000,17000.0000,'fixed',0.0000,17000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 09:22:09','2025-04-17 09:22:09'),(42,217,119,119,3.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 09:34:12','2025-04-17 09:34:12'),(43,218,93,93,60.0000,0.0000,0.0000,80000.0000,80000.0000,'fixed',0.0000,80000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 09:43:47','2025-04-17 09:43:47'),(44,219,22,22,1.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 09:51:35','2025-04-17 09:51:35'),(45,219,26,26,10.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 09:51:35','2025-04-17 09:51:35'),(46,220,34,34,152.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:30:38','2025-04-17 10:30:38'),(47,220,109,109,31.0000,0.0000,0.0000,3500.0000,3500.0000,'fixed',0.0000,3500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:30:38','2025-04-17 10:30:38'),(48,220,56,56,13.0000,0.0000,0.0000,85000.0000,85000.0000,'fixed',0.0000,85000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:30:38','2025-04-17 10:30:38'),(49,220,32,32,351.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:30:38','2025-04-17 10:30:38'),(50,220,81,81,14.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:30:39','2025-04-17 10:30:39'),(51,220,46,46,131.0000,0.0000,0.0000,34000.0000,34000.0000,'fixed',0.0000,34000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:30:39','2025-04-17 10:30:39'),(52,221,36,36,11.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:41:39','2025-04-17 10:41:39'),(53,222,20,20,8.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:51:14','2025-04-17 10:51:14'),(54,222,110,110,30.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:51:14','2025-04-17 10:51:14'),(55,222,17,17,11.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:51:14','2025-04-17 10:51:14'),(56,222,111,111,32.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 10:51:14','2025-04-17 10:51:14'),(57,223,27,27,2.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 11:15:41','2025-04-17 11:15:41'),(58,224,132,132,1.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:18','2025-04-17 12:20:18'),(59,224,88,88,3.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:19','2025-04-17 12:20:19'),(60,224,76,76,5.0000,0.0000,0.0000,25000.0000,25000.0000,'fixed',0.0000,25000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:19','2025-04-17 12:20:19'),(61,224,47,47,45.0000,0.0000,0.0000,22000.0000,22000.0000,'fixed',0.0000,22000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:19','2025-04-17 12:20:19'),(62,224,28,28,77.0000,0.0000,0.0000,70000.0000,70000.0000,'fixed',0.0000,70000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:19','2025-04-17 12:20:19'),(63,224,91,91,35.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:19','2025-04-17 12:20:19'),(64,224,113,113,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:19','2025-04-17 12:20:19'),(65,224,49,49,4.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(66,224,94,94,47.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(67,224,71,71,59.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(68,224,90,90,1.0000,0.0000,0.0000,80000.0000,80000.0000,'fixed',0.0000,80000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(69,224,80,80,13.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(70,224,59,59,27.0000,0.0000,0.0000,28000.0000,28000.0000,'fixed',0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(71,224,66,66,9.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(72,224,85,85,9.0000,0.0000,0.0000,12000.0000,12000.0000,'fixed',0.0000,12000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(73,224,87,87,25.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-17 12:20:20','2025-04-17 12:20:20'),(90,229,137,137,23.0000,0.0000,0.0000,31800.0000,31800.0000,NULL,0.0000,31800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 08:53:58','2025-04-18 08:53:58'),(91,231,167,167,200.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:05:36','2025-04-18 09:05:36'),(92,233,137,137,552.0000,0.0000,0.0000,31800.0000,31800.0000,NULL,0.0000,31800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:10:14','2025-04-18 09:10:14'),(93,235,164,164,300.0000,0.0000,0.0000,4045.0000,4045.0000,NULL,0.0000,4045.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(94,235,157,157,4200.0000,0.0000,0.0000,2400.0000,2400.0000,NULL,0.0000,2400.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(95,235,163,163,1500.0000,0.0000,0.0000,4500.0000,4500.0000,NULL,0.0000,4500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(96,235,145,145,160.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(97,235,166,166,5000.0000,0.0000,0.0000,1100.0000,1100.0000,NULL,0.0000,1100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(98,237,205,205,240.0000,0.0000,0.0000,27000.0000,27000.0000,NULL,0.0000,27000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:30:50','2025-04-18 09:30:50'),(99,241,208,208,112.0000,0.0000,0.0000,31600.0000,31600.0000,NULL,0.0000,31600.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:46:11','2025-04-18 09:46:11'),(100,243,140,140,80.0000,0.0000,0.0000,16000.0000,16000.0000,NULL,0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 09:48:45','2025-04-18 09:48:45'),(101,245,151,151,390.0000,0.0000,0.0000,104000.0000,104000.0000,NULL,0.0000,104000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:04:10','2025-04-18 10:04:10'),(102,245,142,142,900.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:04:10','2025-04-18 10:04:10'),(103,247,142,142,200.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(104,247,202,202,10.0000,0.0000,0.0000,34000.0000,34000.0000,NULL,0.0000,34000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(105,247,197,197,16.0000,0.0000,0.0000,28000.0000,28000.0000,NULL,0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(106,247,195,195,60.0000,0.0000,0.0000,8000.0000,8000.0000,NULL,0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(107,247,199,199,30.0000,0.0000,0.0000,23000.0000,23000.0000,NULL,0.0000,23000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(108,249,206,206,900.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(109,249,141,141,80.0000,0.0000,0.0000,26475.0000,26475.0000,NULL,0.0000,26475.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(110,249,165,165,120.0000,0.0000,0.0000,65800.0000,65800.0000,NULL,0.0000,65800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(111,249,170,170,250.0000,0.0000,0.0000,2000.0000,2000.0000,NULL,0.0000,2000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(112,249,172,172,20.0000,0.0000,0.0000,6200.0000,6200.0000,NULL,0.0000,6200.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(113,249,169,169,30.0000,0.0000,0.0000,14500.0000,14500.0000,NULL,0.0000,14500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(114,251,139,139,400.0000,0.0000,0.0000,8040.0000,8040.0000,NULL,0.0000,8040.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:43:55','2025-04-18 10:43:55'),(115,251,154,154,60.0000,0.0000,0.0000,104000.0000,104000.0000,NULL,0.0000,104000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:43:55','2025-04-18 10:43:55'),(116,251,143,143,75.0000,0.0000,0.0000,11000.0000,11000.0000,NULL,0.0000,11000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 10:43:55','2025-04-18 10:43:55'),(117,253,203,203,16.0000,0.0000,0.0000,45000.0000,45000.0000,NULL,0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:24:25','2025-04-18 11:24:25'),(118,255,148,148,60.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(119,255,149,149,60.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(120,255,201,201,384.0000,0.0000,0.0000,19000.0000,19000.0000,NULL,0.0000,19000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(121,255,202,202,220.0000,0.0000,0.0000,34000.0000,34000.0000,NULL,0.0000,34000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(122,255,203,203,208.0000,0.0000,0.0000,45000.0000,45000.0000,NULL,0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(123,257,204,204,78.0000,0.0000,0.0000,66000.0000,66000.0000,NULL,0.0000,66000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(124,257,198,198,150.0000,0.0000,0.0000,16677.0000,16677.0000,NULL,0.0000,16677.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(125,257,200,200,240.0000,0.0000,0.0000,8470.0000,8470.0000,NULL,0.0000,8470.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(126,257,197,197,152.0000,0.0000,0.0000,28000.0000,28000.0000,NULL,0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(127,257,196,196,3289.0000,0.0000,0.0000,2431.0000,2431.0000,NULL,0.0000,2431.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(128,257,195,195,3600.0000,0.0000,0.0000,8000.0000,8000.0000,NULL,0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(129,257,160,160,300.0000,0.0000,0.0000,1300.0000,1300.0000,NULL,0.0000,1300.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(130,257,147,147,120.0000,0.0000,0.0000,4800.0000,4800.0000,NULL,0.0000,4800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(131,257,176,176,48.0000,0.0000,0.0000,7089.0000,7089.0000,NULL,0.0000,7089.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(132,259,141,141,80.0000,0.0000,0.0000,26475.0000,26475.0000,NULL,0.0000,26475.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(133,259,206,206,50.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(134,259,203,203,8.0000,0.0000,0.0000,45000.0000,45000.0000,NULL,0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(135,261,141,141,80.0000,0.0000,0.0000,26475.0000,26475.0000,NULL,0.0000,26475.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:01:28','2025-04-18 12:01:28'),(136,261,206,206,50.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:01:28','2025-04-18 12:01:28'),(137,261,203,203,8.0000,0.0000,0.0000,45000.0000,45000.0000,NULL,0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:01:29','2025-04-18 12:01:29'),(138,263,202,202,10.0000,0.0000,0.0000,34000.0000,34000.0000,NULL,0.0000,34000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(139,263,204,204,6.0000,0.0000,0.0000,66000.0000,66000.0000,NULL,0.0000,66000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(140,263,140,140,40.0000,0.0000,0.0000,16000.0000,16000.0000,NULL,0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(141,263,195,195,40.0000,0.0000,0.0000,8000.0000,8000.0000,NULL,0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(142,267,209,209,100.0000,0.0000,0.0000,3300.0000,3300.0000,NULL,0.0000,3300.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 13:31:13','2025-04-18 13:31:13'),(143,269,210,210,40.0000,0.0000,0.0000,30000.0000,30000.0000,NULL,0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 13:34:46','2025-04-18 13:34:46'),(144,271,166,166,1000.0000,0.0000,0.0000,1100.0000,1100.0000,NULL,0.0000,1100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 13:41:38','2025-04-18 13:41:38'),(145,273,186,186,300.0000,0.0000,0.0000,3510.0000,3510.0000,NULL,0.0000,3510.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 13:44:13','2025-04-18 13:44:13'),(146,275,138,138,1.0000,0.0000,0.0000,38970.0000,38970.0000,NULL,0.0000,38970.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 13:49:17','2025-04-18 13:49:17'),(147,277,181,181,48.0000,0.0000,0.0000,29000.0000,29000.0000,NULL,0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 14:05:31','2025-04-18 14:05:31'),(148,279,199,199,490.0000,0.0000,0.0000,23000.0000,23000.0000,NULL,0.0000,23000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 14:19:08','2025-04-18 14:19:08'),(149,281,47,47,64.0000,0.0000,0.0000,22000.0000,22000.0000,'fixed',0.0000,22000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(150,281,127,127,450.0000,0.0000,0.0000,17000.0000,17000.0000,'fixed',0.0000,17000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(151,281,40,40,495.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(152,281,46,46,144.0000,0.0000,0.0000,34000.0000,34000.0000,'fixed',0.0000,34000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(153,281,123,123,48.0000,0.0000,0.0000,24000.0000,24000.0000,'fixed',0.0000,24000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(154,281,86,86,2.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(155,283,211,211,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 19:48:29','2025-04-18 19:48:29'),(156,284,211,211,2.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-18 19:51:12','2025-04-18 19:57:35'),(157,285,199,199,108.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 07:39:46','2025-04-19 07:39:46'),(158,286,163,163,309.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 07:46:35','2025-04-19 07:46:35'),(159,286,67,67,110.0000,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 07:46:35','2025-04-19 07:46:35'),(160,286,139,139,110.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 07:46:35','2025-04-19 07:46:35'),(161,287,176,176,29.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:44','2025-04-19 10:10:44'),(162,287,76,76,2.0000,0.0000,0.0000,25000.0000,25000.0000,'fixed',0.0000,25000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:44','2025-04-19 10:10:44'),(163,287,28,28,152.0000,0.0000,0.0000,70000.0000,70000.0000,'fixed',0.0000,70000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:44','2025-04-19 10:10:44'),(164,287,91,91,27.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:44','2025-04-19 10:10:44'),(165,287,49,49,3.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(166,287,199,199,25.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(167,287,71,71,60.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(168,287,80,80,35.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(169,287,59,59,32.0000,0.0000,0.0000,28000.0000,28000.0000,'fixed',0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(170,287,62,62,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(171,287,66,66,3.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(172,287,85,85,3.0000,0.0000,0.0000,12000.0000,12000.0000,'fixed',0.0000,12000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(173,287,87,87,6.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(174,287,41,41,37.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(175,287,16,16,20.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(176,287,128,128,3.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(177,287,82,82,66.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(178,287,33,33,31.0000,0.0000,0.0000,3500.0000,3500.0000,'fixed',0.0000,3500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(179,287,67,67,6.0000,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(180,287,166,166,658.0000,0.0000,0.0000,1700.0000,1700.0000,'fixed',0.0000,1700.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 10:10:45','2025-04-19 10:10:45'),(181,288,146,146,1.0000,0.0000,0.0000,550000.0000,550000.0000,NULL,0.0000,550000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:13:25','2025-04-19 11:13:25'),(182,290,188,188,112.0000,0.0000,0.0000,13700.0000,13700.0000,NULL,0.0000,13700.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:27:35','2025-04-19 11:27:35'),(183,290,187,187,112.0000,0.0000,0.0000,17000.0000,17000.0000,NULL,0.0000,17000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:27:35','2025-04-19 11:27:35'),(184,290,189,189,112.0000,0.0000,0.0000,19800.0000,19800.0000,NULL,0.0000,19800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:27:35','2025-04-19 11:27:35'),(185,292,158,158,42.0000,0.0000,0.0000,12900.0000,12900.0000,NULL,0.0000,12900.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:36:28','2025-04-19 11:36:28'),(186,294,150,150,240.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:41:05','2025-04-19 11:41:05'),(187,294,149,149,60.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 11:41:05','2025-04-19 11:41:05'),(188,296,195,195,147.0000,0.0000,0.0000,13000.0000,13000.0000,'fixed',0.0000,13000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:54','2025-04-19 13:23:54'),(189,296,206,206,685.0000,0.0000,0.0000,22000.0000,22000.0000,'fixed',0.0000,22000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:54','2025-04-19 13:23:54'),(190,296,69,69,93.0000,0.0000,0.0000,4500.0000,4500.0000,'fixed',0.0000,4500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:54','2025-04-19 13:23:54'),(191,296,77,77,26.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:54','2025-04-19 13:23:54'),(192,296,89,89,55.0000,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(193,296,113,113,18.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(194,296,44,44,115.0000,0.0000,0.0000,31000.0000,31000.0000,'fixed',0.0000,31000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(195,296,78,78,1.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(196,296,205,205,45.0000,0.0000,0.0000,0.0000,0.0000,'fixed',0.0000,0.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(197,296,86,86,3.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(198,296,70,70,95.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(199,296,80,80,30.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(200,296,201,201,45.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(201,296,202,202,56.0000,0.0000,0.0000,48000.0000,48000.0000,'fixed',0.0000,48000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(202,296,203,203,65.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(203,296,204,204,12.0000,0.0000,0.0000,100000.0000,100000.0000,'fixed',0.0000,100000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(204,296,125,125,3.0000,0.0000,0.0000,39000.0000,39000.0000,'fixed',0.0000,39000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(205,296,200,200,95.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(206,296,197,197,38.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(207,296,142,142,143.0000,0.0000,0.0000,17000.0000,17000.0000,'fixed',0.0000,17000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(208,296,196,196,348.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(209,296,92,92,4.0000,0.0000,0.0000,29000.0000,29000.0000,'fixed',0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(210,296,198,198,57.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(211,296,133,133,8.0000,0.0000,0.0000,3500.0000,3500.0000,'fixed',0.0000,3500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(212,296,208,208,39.0000,0.0000,0.0000,37000.0000,37000.0000,'fixed',0.0000,37000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(213,296,96,96,3.0000,0.0000,0.0000,31750.0000,31750.0000,'fixed',0.0000,31750.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(214,296,121,121,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(215,296,46,46,136.0000,0.0000,0.0000,34000.0000,34000.0000,'fixed',0.0000,34000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(216,296,195,195,818.0000,0.0000,0.0000,13000.0000,13000.0000,'fixed',0.0000,13000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(217,296,196,196,251.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(218,296,32,32,116.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(219,296,100,100,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(220,296,122,122,32.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(221,296,61,61,56.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(222,296,142,142,153.0000,0.0000,0.0000,17000.0000,17000.0000,'fixed',0.0000,17000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(223,296,199,199,58.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(224,296,63,63,2.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(225,296,34,34,70.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(226,296,163,163,6.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(227,296,188,188,7.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:23:55','2025-04-19 13:23:55'),(228,298,212,212,500.0000,0.0000,0.0000,19000.0000,19000.0000,NULL,0.0000,19000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 13:46:21','2025-04-19 13:46:21'),(229,300,110,110,9.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 14:50:17','2025-04-19 14:50:17'),(230,300,111,111,3.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 14:50:17','2025-04-19 14:50:17'),(231,300,25,25,10.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 14:50:17','2025-04-19 14:50:17'),(232,300,27,27,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 14:50:17','2025-04-19 14:50:17'),(233,300,88,88,1.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 14:50:17','2025-04-19 14:50:17'),(234,301,51,51,1.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 14:54:06','2025-04-19 14:54:06'),(235,302,13,13,19.0000,0.0000,0.0000,156000.0000,156000.0000,'fixed',0.0000,156000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:11:23','2025-04-19 15:11:23'),(236,303,164,164,112.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:16:05','2025-04-23 10:28:05'),(237,305,196,196,60.0000,0.0000,0.0000,2431.0000,2431.0000,NULL,0.0000,2431.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(238,305,198,198,50.0000,0.0000,0.0000,16677.0000,16677.0000,NULL,0.0000,16677.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(239,305,143,143,75.0000,0.0000,0.0000,11000.0000,11000.0000,NULL,0.0000,11000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(240,305,150,150,90.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(241,305,151,151,60.0000,0.0000,0.0000,104000.0000,104000.0000,NULL,0.0000,104000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(242,305,199,199,20.0000,0.0000,0.0000,23000.0000,23000.0000,NULL,0.0000,23000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(243,307,201,201,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(244,307,91,91,2.0000,0.0000,0.0000,21000.0000,21000.0000,'fixed',0.0000,21000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(245,307,39,39,2.0000,0.0000,0.0000,13000.0000,13000.0000,'fixed',0.0000,13000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(246,307,69,69,2.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(247,307,196,196,10.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(248,307,56,56,3.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(249,307,11,11,2.0000,0.0000,0.0000,27000.0000,27000.0000,'fixed',0.0000,27000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(250,307,3,3,4.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(251,307,196,196,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(252,307,124,124,3.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(253,307,151,151,1.0000,0.0000,0.0000,155000.0000,155000.0000,'fixed',0.0000,155000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(254,307,92,92,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(255,307,199,199,5.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:52','2025-04-20 18:31:52'),(256,307,61,61,6.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(257,307,82,82,2.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(258,307,107,107,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(259,307,208,208,1.0000,0.0000,0.0000,39000.0000,39000.0000,'fixed',0.0000,39000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(260,307,40,40,1.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(261,307,204,204,1.0000,0.0000,0.0000,100000.0000,100000.0000,'fixed',0.0000,100000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(262,307,6,6,1.0000,0.0000,0.0000,96000.0000,96000.0000,'fixed',0.0000,96000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(263,307,189,189,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(264,307,91,91,1.0000,0.0000,0.0000,21000.0000,21000.0000,'fixed',0.0000,21000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(265,307,198,198,1.0000,0.0000,0.0000,28000.0000,28000.0000,'fixed',0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(266,307,61,61,2.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(267,307,166,166,20.0000,0.0000,0.0000,1700.0000,1700.0000,'fixed',0.0000,1700.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:53','2025-04-20 18:31:53'),(268,307,3,3,1.0000,0.0000,0.0000,100000.0000,100000.0000,'fixed',0.0000,100000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(269,307,186,186,2.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(270,307,186,186,2.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(271,307,38,38,6.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(272,307,210,210,1.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(273,307,17,17,3.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(274,307,91,91,1.0000,0.0000,0.0000,21000.0000,21000.0000,'fixed',0.0000,21000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(275,307,77,77,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(276,307,114,114,1.0000,0.0000,0.0000,11000.0000,11000.0000,'fixed',0.0000,11000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(277,307,157,157,2.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(278,307,157,157,3.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(279,307,142,142,2.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 18:31:54','2025-04-20 18:31:54'),(280,308,94,94,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:51','2025-04-20 19:36:51'),(281,308,122,122,3.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:53','2025-04-20 19:36:53'),(282,308,91,91,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(283,308,142,142,12.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(284,308,117,117,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(285,308,203,203,1.0000,0.0000,0.0000,70000.0000,70000.0000,'fixed',0.0000,70000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(286,308,55,55,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(287,308,62,62,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'verse and maua =60000',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(288,308,163,163,1.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(289,308,91,91,1.0000,0.0000,0.0000,21000.0000,21000.0000,'fixed',0.0000,21000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(290,308,195,195,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(291,308,61,61,10.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:54','2025-04-20 19:36:54'),(292,308,78,78,1.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(293,308,46,46,1.0000,0.0000,0.0000,36000.0000,36000.0000,'fixed',0.0000,36000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(294,308,186,186,2.0000,0.0000,0.0000,5500.0000,5500.0000,'fixed',0.0000,5500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(295,308,61,61,1.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(296,308,41,41,1.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(297,308,157,157,10.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(298,308,91,91,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(299,308,71,71,1.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(300,308,209,209,1.0000,0.0000,0.0000,5500.0000,5500.0000,'fixed',0.0000,5500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(301,308,123,123,1.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(302,308,73,73,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:36:55','2025-04-20 19:36:55'),(303,309,61,61,10.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:17','2025-04-20 19:51:17'),(304,309,201,201,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:19','2025-04-20 19:51:19'),(305,309,33,33,3.0000,0.0000,0.0000,3000.0000,3000.0000,'fixed',0.0000,3000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:19','2025-04-20 19:51:19'),(306,309,62,62,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(307,309,51,51,2.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(308,309,61,61,1.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(309,309,43,43,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(310,309,82,82,1.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(311,309,123,123,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(312,309,111,111,4.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:20','2025-04-20 19:51:20'),(313,309,29,29,1.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 19:51:21','2025-04-20 19:51:21'),(314,310,62,62,1.0000,0.0000,0.0000,32000.0000,32000.0000,'fixed',0.0000,32000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:41','2025-04-20 20:46:41'),(315,310,128,128,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:41','2025-04-20 20:46:41'),(316,310,167,167,1.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(317,310,94,94,1.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(318,310,196,196,1.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(319,310,195,195,2.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(320,310,29,29,1.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(321,310,62,62,1.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(322,310,167,167,1.0000,0.0000,0.0000,24000.0000,24000.0000,'fixed',0.0000,24000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(323,310,43,43,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(324,310,106,106,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(325,310,71,71,2.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(326,310,46,46,1.0000,0.0000,0.0000,37000.0000,37000.0000,'fixed',0.0000,37000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(327,310,126,126,6.0000,0.0000,0.0000,2000.0000,2000.0000,'fixed',0.0000,2000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(328,310,70,70,2.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(329,310,201,201,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(330,310,46,46,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(331,310,157,157,7.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(332,310,196,196,1.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(333,310,195,195,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(334,310,164,164,1.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(335,310,70,70,5.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(336,310,188,188,2.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(337,310,201,201,2.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(338,310,44,44,1.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(339,310,94,94,1.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(340,310,142,142,5.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(341,310,199,199,3.0000,0.0000,0.0000,39000.0000,39000.0000,'fixed',0.0000,39000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(342,310,188,188,2.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(343,310,202,202,1.0000,0.0000,0.0000,50000.0000,50000.0000,'fixed',0.0000,50000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(344,310,203,203,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(345,310,196,196,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(346,310,195,195,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(347,310,75,75,2.0000,0.0000,0.0000,30000.0000,30000.0000,'fixed',0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(348,310,94,94,1.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(349,310,196,196,1.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(350,310,124,124,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(351,310,200,200,2.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(352,310,197,197,1.0000,0.0000,0.0000,65000.0000,65000.0000,'fixed',0.0000,65000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(353,310,203,203,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(354,310,167,167,3.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(355,310,61,61,2.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(356,310,41,41,1.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(357,310,111,111,3.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(358,310,165,165,1.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(359,310,157,157,7.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(360,310,109,109,1.0000,0.0000,0.0000,3000.0000,3000.0000,'fixed',0.0000,3000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(361,310,210,210,2.0000,0.0000,0.0000,33000.0000,33000.0000,'fixed',0.0000,33000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(362,310,67,67,14.0000,0.0000,0.0000,7500.0000,7500.0000,'fixed',0.0000,7500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(363,310,82,82,2.0000,0.0000,0.0000,19000.0000,19000.0000,'fixed',0.0000,19000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(364,310,29,29,2.0000,0.0000,0.0000,7500.0000,7500.0000,'fixed',0.0000,7500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(365,310,119,119,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(366,310,188,188,2.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:42','2025-04-20 20:46:42'),(367,310,197,197,1.0000,0.0000,0.0000,65000.0000,65000.0000,'fixed',0.0000,65000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:43','2025-04-20 20:46:43'),(368,310,199,199,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:43','2025-04-20 20:46:43'),(369,310,125,125,1.0000,0.0000,0.0000,39000.0000,39000.0000,'fixed',0.0000,39000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:43','2025-04-20 20:46:43'),(370,310,91,91,1.0000,0.0000,0.0000,21000.0000,21000.0000,'fixed',0.0000,21000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-20 20:46:43','2025-04-20 20:46:43'),(371,311,47,47,31.0000,0.0000,0.0000,22000.0000,22000.0000,'fixed',0.0000,22000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 07:56:03','2025-04-21 07:56:03'),(372,311,212,212,73.0000,0.0000,0.0000,22000.0000,22000.0000,'fixed',0.0000,22000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 07:56:03','2025-04-21 07:56:03'),(373,312,147,147,60.0000,0.0000,0.0000,4800.0000,4800.0000,NULL,0.0000,4800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 08:17:09','2025-04-21 08:17:09'),(374,314,122,122,3.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 08:44:09','2025-04-21 08:44:09'),(375,314,94,94,4.0000,0.0000,0.0000,41000.0000,41000.0000,'fixed',0.0000,41000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 08:44:09','2025-04-21 08:44:09'),(376,315,46,46,2.0000,0.0000,0.0000,43000.0000,43000.0000,'fixed',0.0000,43000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 09:03:05','2025-04-21 09:03:05'),(377,317,213,213,50.0000,0.0000,0.0000,4500.0000,4500.0000,NULL,0.0000,4500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 09:20:50','2025-04-21 09:20:50'),(378,319,127,127,5.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 09:30:33','2025-04-21 09:30:33'),(379,320,40,40,3.0000,0.0000,0.0000,25000.0000,25000.0000,'fixed',0.0000,25000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(380,320,67,67,6.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(381,320,209,209,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(382,320,122,122,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(383,320,128,128,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'Half Dazen pc 5',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(384,320,36,36,7.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(385,320,95,95,1.0000,0.0000,0.0000,110000.0000,110000.0000,'fixed',0.0000,110000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:18:04','2025-04-21 11:18:04'),(386,321,143,143,2.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 11:25:31','2025-04-21 11:25:31'),(387,322,196,196,1.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(388,322,196,196,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(389,322,195,195,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(390,322,46,46,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(391,322,57,57,20.0000,0.0000,0.0000,1800.0000,1800.0000,'fixed',0.0000,1800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(392,322,88,88,1.0000,0.0000,0.0000,12000.0000,12000.0000,'fixed',0.0000,12000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 12:16:15','2025-04-21 12:16:15'),(393,323,14,14,3.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:13:00','2025-04-21 13:13:00'),(394,324,195,195,2.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(395,324,147,147,3.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(396,324,57,57,1.0000,0.0000,0.0000,1900.0000,1900.0000,'fixed',0.0000,1900.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(397,324,141,141,1.0000,0.0000,0.0000,33000.0000,33000.0000,'fixed',0.0000,33000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(398,324,143,143,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(399,324,124,124,2.0000,0.0000,0.0000,13000.0000,12500.0000,'fixed',500.0000,12500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(400,324,212,212,2.0000,0.0000,0.0000,22000.0000,22000.0000,'fixed',0.0000,22000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(401,324,127,127,2.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(402,324,119,119,1.0000,0.0000,0.0000,15000.0000,12000.0000,'fixed',3000.0000,12000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(403,324,143,143,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(404,324,199,199,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 13:51:01','2025-04-21 13:51:01'),(405,325,41,41,1.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:33','2025-04-21 14:17:33'),(406,325,196,196,3.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:33','2025-04-21 14:17:33'),(407,325,188,188,2.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:33','2025-04-21 14:17:33'),(408,325,187,187,3.0000,0.0000,0.0000,29000.0000,29000.0000,'fixed',0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:34','2025-04-21 14:17:34'),(409,325,29,29,3.0000,0.0000,0.0000,7500.0000,7500.0000,'fixed',0.0000,7500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:34','2025-04-21 14:17:34'),(410,325,43,43,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:34','2025-04-21 14:17:34'),(411,325,46,46,1.0000,0.0000,0.0000,37000.0000,37000.0000,'fixed',0.0000,37000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:34','2025-04-21 14:17:34'),(412,325,80,80,2.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:17:34','2025-04-21 14:17:34'),(413,326,141,141,40.0000,0.0000,0.0000,26475.0000,26475.0000,NULL,0.0000,26475.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(414,326,206,206,50.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(415,326,167,167,100.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(416,326,197,197,14.0000,0.0000,0.0000,28000.0000,28000.0000,NULL,0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(417,326,200,200,40.0000,0.0000,0.0000,8470.0000,8470.0000,NULL,0.0000,8470.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(418,326,144,144,100.0000,0.0000,0.0000,4000.0000,4000.0000,NULL,0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(419,326,199,199,50.0000,0.0000,0.0000,23000.0000,23000.0000,NULL,0.0000,23000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(420,326,210,210,40.0000,0.0000,0.0000,30000.0000,30000.0000,NULL,0.0000,30000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 14:42:55','2025-04-21 14:42:55'),(421,328,75,75,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 15:17:57','2025-04-21 15:17:57'),(422,329,75,75,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(423,329,75,75,1.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(424,330,187,187,4.0000,0.0000,0.0000,29000.0000,29000.0000,'fixed',0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(425,330,124,124,3.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(426,330,196,196,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(427,330,197,197,1.0000,0.0000,0.0000,65000.0000,65000.0000,'fixed',0.0000,65000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(428,330,127,127,1.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(429,330,143,143,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(430,330,111,111,3.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(431,330,69,69,4.0000,0.0000,0.0000,4500.0000,4500.0000,'fixed',0.0000,4500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(432,330,157,157,6.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(433,330,118,118,1.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(434,330,197,197,2.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(435,330,199,199,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:27:37','2025-04-21 17:27:37'),(436,331,167,167,1.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-21 17:30:54','2025-04-21 17:30:54'),(437,334,59,59,24.0000,0.0000,0.0000,28000.0000,28000.0000,'fixed',0.0000,28000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:51','2025-04-22 08:42:51'),(438,334,187,187,34.0000,0.0000,0.0000,29000.0000,29000.0000,'fixed',0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:54','2025-04-22 08:42:54'),(439,334,188,188,40.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:54','2025-04-22 08:42:54'),(440,334,61,61,67.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:54','2025-04-22 08:42:54'),(441,334,144,144,100.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(442,334,41,41,58.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(443,334,157,157,374.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(444,334,34,34,23.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(445,334,25,25,7.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(446,334,22,22,4.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(447,334,27,27,6.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(448,334,111,111,25.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(449,334,20,20,8.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(450,334,158,158,2.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(451,334,82,82,25.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(452,334,28,28,127.0000,0.0000,0.0000,70000.0000,70000.0000,'fixed',0.0000,70000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(453,334,70,70,14.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(454,334,80,80,4.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(455,334,186,186,124.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(456,334,30,30,21.0000,0.0000,0.0000,37000.0000,37000.0000,'fixed',0.0000,37000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(457,334,31,31,23.0000,0.0000,0.0000,27000.0000,27000.0000,'fixed',0.0000,27000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(458,334,56,56,42.0000,0.0000,0.0000,85000.0000,85000.0000,'fixed',0.0000,85000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(459,334,63,63,1.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(460,334,43,43,24.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(461,334,137,137,107.0000,0.0000,0.0000,38000.0000,38000.0000,'fixed',0.0000,38000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(462,334,57,57,590.0000,0.0000,0.0000,1700.0000,1700.0000,'fixed',0.0000,1700.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(463,334,133,133,26.0000,0.0000,0.0000,3500.0000,3500.0000,'fixed',0.0000,3500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(464,334,113,113,52.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(465,334,111,111,7.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(466,334,51,51,3.0000,0.0000,0.0000,10000.0000,10000.0000,'fixed',0.0000,10000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(467,334,110,110,5.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(468,334,143,143,21.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(469,334,118,118,7.0000,0.0000,0.0000,11000.0000,11000.0000,'fixed',0.0000,11000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(470,334,93,93,55.0000,0.0000,0.0000,80000.0000,80000.0000,'fixed',0.0000,80000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(471,334,49,49,1.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(472,334,141,141,15.0000,0.0000,0.0000,31000.0000,31000.0000,'fixed',0.0000,31000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(473,334,176,176,3.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:55','2025-04-22 08:42:55'),(474,334,84,84,1.0000,0.0000,0.0000,65000.0000,65000.0000,'fixed',0.0000,65000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(475,334,164,164,57.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(476,334,120,120,4.0000,0.0000,0.0000,45000.0000,45000.0000,'fixed',0.0000,45000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(477,334,75,75,1.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'20 metre',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(478,334,196,196,144.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(479,334,195,195,489.0000,0.0000,0.0000,13000.0000,13000.0000,'fixed',0.0000,13000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(480,334,201,201,126.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(481,334,202,202,46.0000,0.0000,0.0000,48000.0000,48000.0000,'fixed',0.0000,48000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(482,334,203,203,97.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(483,334,204,204,34.0000,0.0000,0.0000,100000.0000,100000.0000,'fixed',0.0000,100000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(484,334,36,36,100.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(485,334,119,119,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(486,334,200,200,31.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(487,334,197,197,1.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(488,334,197,197,45.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(489,334,69,69,5.0000,0.0000,0.0000,4500.0000,4500.0000,'fixed',0.0000,4500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(490,334,209,209,45.0000,0.0000,0.0000,4500.0000,4500.0000,'fixed',0.0000,4500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(491,334,75,75,3.0000,0.0000,0.0000,35000.0000,35000.0000,'fixed',0.0000,35000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(492,334,92,92,10.0000,0.0000,0.0000,29000.0000,29000.0000,'fixed',0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(493,334,198,198,25.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:56','2025-04-22 08:42:56'),(494,334,78,78,50.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:57','2025-04-22 08:42:57'),(495,334,147,147,24.0000,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 08:42:57','2025-04-22 08:42:57'),(496,335,142,142,1.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 09:06:21','2025-04-22 09:06:21'),(497,335,199,199,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 09:06:21','2025-04-22 09:06:21'),(498,335,93,93,3.0000,0.0000,0.0000,8000.0000,8000.0000,'fixed',0.0000,8000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 09:06:21','2025-04-22 09:06:21'),(499,335,195,195,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 09:06:21','2025-04-22 09:06:21'),(500,335,166,166,10.0000,0.0000,0.0000,1800.0000,1800.0000,'fixed',0.0000,1800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 09:06:21','2025-04-22 09:06:21'),(501,340,199,199,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 10:21:27','2025-04-22 10:21:27'),(502,340,46,46,8.0000,0.0000,0.0000,36000.0000,36000.0000,'fixed',0.0000,36000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 10:21:27','2025-04-22 10:21:27'),(503,340,94,94,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 10:21:27','2025-04-22 10:21:27'),(504,340,195,195,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 10:21:27','2025-04-22 10:21:27'),(505,340,123,123,6.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 10:21:27','2025-04-22 10:21:27'),(506,341,143,143,1.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:04:36','2025-04-22 11:04:36'),(507,341,157,157,4.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:04:36','2025-04-22 11:04:36'),(508,341,34,34,4.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:04:36','2025-04-22 11:04:36'),(509,341,163,163,2.0000,0.0000,0.0000,12000.0000,12000.0000,'fixed',0.0000,12000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:04:36','2025-04-22 11:04:36'),(510,341,127,127,26.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:04:36','2025-04-22 11:04:36'),(511,342,2,2,5.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:15:45','2025-04-22 11:15:45'),(512,343,26,26,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 11:42:53','2025-04-22 11:43:45'),(513,344,26,26,3.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:06:10','2025-04-22 12:06:10'),(514,345,112,112,1.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(515,345,123,123,2.0000,0.0000,0.0000,24000.0000,24000.0000,'fixed',0.0000,24000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(516,345,29,29,1.0000,0.0000,0.0000,7500.0000,7500.0000,'fixed',0.0000,7500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(517,345,70,70,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(518,345,142,142,2.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(519,345,196,196,1.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(520,345,88,88,1.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(521,345,28,28,1.0000,0.0000,0.0000,75000.0000,75000.0000,'fixed',0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(522,345,34,34,6.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(523,345,140,140,1.0000,0.0000,0.0000,21000.0000,21000.0000,'fixed',0.0000,21000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(524,345,157,157,6.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(525,345,61,61,11.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 12:44:16','2025-04-22 12:44:16'),(526,353,127,127,5.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 13:36:51','2025-04-22 13:36:51'),(527,353,56,56,2.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 13:36:51','2025-04-22 13:36:51'),(528,353,49,49,1.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 13:36:51','2025-04-22 13:36:51'),(529,354,195,195,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:08:29','2025-04-22 14:08:29'),(530,354,197,197,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:08:29','2025-04-22 14:08:29'),(531,354,124,124,2.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:08:29','2025-04-22 14:08:29'),(532,354,196,196,1.0000,0.0000,0.0000,7000.0000,7000.0000,'fixed',0.0000,7000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:08:29','2025-04-22 14:08:29'),(533,355,16,16,3.0000,0.0000,0.0000,3500.0000,3500.0000,'fixed',0.0000,3500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:31:22','2025-04-22 14:31:22'),(534,356,82,82,1.0000,0.0000,0.0000,23000.0000,23000.0000,'fixed',0.0000,23000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:48:57','2025-04-22 14:48:57'),(535,356,195,195,2.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:48:57','2025-04-22 14:48:57'),(536,356,56,56,2.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:48:57','2025-04-22 14:48:57'),(537,356,127,127,10.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:48:57','2025-04-22 14:48:57'),(538,356,187,187,5.0000,0.0000,0.0000,29000.0000,29000.0000,'fixed',0.0000,29000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:48:57','2025-04-22 14:48:57'),(539,356,16,16,7.0000,0.0000,0.0000,3500.0000,3500.0000,'fixed',0.0000,3500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 14:48:57','2025-04-22 14:48:57'),(540,357,46,46,40.0000,0.0000,0.0000,36000.0000,36000.0000,'fixed',0.0000,36000.0000,0.0000,NULL,NULL,NULL,'MWANYIKA MBEYA',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:27:53','2025-04-22 15:30:54'),(541,357,188,188,6.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:27:53','2025-04-22 15:30:54'),(542,357,94,94,10.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:27:53','2025-04-22 15:30:54'),(543,357,143,143,2.0000,0.0000,0.0000,20000.0000,20000.0000,'fixed',0.0000,20000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:27:53','2025-04-22 15:30:54'),(544,357,41,41,5.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:27:53','2025-04-22 15:30:54'),(545,357,6,6,6.0000,0.0000,0.0000,16000.0000,14166.7000,'fixed',1833.3000,14167.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:27:53','2025-04-22 15:30:54'),(546,358,195,195,1.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:42:53','2025-04-22 15:42:53'),(547,358,196,196,1.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:42:57','2025-04-22 15:42:57'),(548,358,94,94,1.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:42:57','2025-04-22 15:42:57'),(549,358,34,34,4.0000,0.0000,0.0000,6000.0000,6000.0000,'fixed',0.0000,6000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 15:42:57','2025-04-22 15:42:57'),(550,359,202,202,2.0000,0.0000,0.0000,70000.0000,70000.0000,'fixed',0.0000,70000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 16:02:19','2025-04-22 16:02:19'),(551,359,195,195,1.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 16:02:19','2025-04-22 16:02:19'),(552,359,196,196,1.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 16:02:19','2025-04-22 16:02:19'),(553,360,13,13,3.0000,0.0000,0.0000,15000.0000,15000.0000,'fixed',0.0000,15000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-22 16:05:33','2025-04-22 16:05:33'),(554,361,127,127,30.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 09:43:32','2025-04-23 09:43:32'),(555,361,56,56,2.0000,0.0000,0.0000,90000.0000,90000.0000,'fixed',0.0000,90000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 09:43:35','2025-04-23 09:43:35'),(556,361,196,196,2.0000,0.0000,0.0000,4000.0000,4000.0000,'fixed',0.0000,4000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 09:43:35','2025-04-23 09:43:35'),(557,361,195,195,2.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 09:43:35','2025-04-23 09:43:35'),(558,361,197,197,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 09:43:35','2025-04-23 09:43:35'),(559,362,154,154,12.0000,0.0000,0.0000,25833.3330,25833.3330,'fixed',0.0000,25833.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 10:08:03','2025-04-23 10:08:03'),(560,363,112,112,2.0000,0.0000,0.0000,16000.0000,16000.0000,'fixed',0.0000,16000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:51','2025-04-23 11:25:51'),(561,363,29,29,4.0000,0.0000,0.0000,7500.0000,7500.0000,'fixed',0.0000,7500.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:51','2025-04-23 11:25:51'),(562,363,40,40,12.0000,0.0000,0.0000,18000.0000,18000.0000,'fixed',0.0000,18000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:51','2025-04-23 11:25:51'),(563,363,94,94,3.0000,0.0000,0.0000,40000.0000,40000.0000,'fixed',0.0000,40000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:51','2025-04-23 11:25:51'),(564,363,166,166,100.0000,0.0000,0.0000,1800.0000,1800.0000,'fixed',0.0000,1800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:52','2025-04-23 11:25:52'),(565,363,197,197,1.0000,0.0000,0.0000,55000.0000,55000.0000,'fixed',0.0000,55000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:52','2025-04-23 11:25:52'),(566,363,151,151,4.0000,0.0000,0.0000,27000.0000,27000.0000,'fixed',0.0000,27000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:25:52','2025-04-23 11:25:52'),(567,364,166,166,50.0000,0.0000,0.0000,1800.0000,1800.0000,'fixed',0.0000,1800.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:53:14','2025-04-23 11:53:14'),(568,365,203,203,1.0000,0.0000,0.0000,60000.0000,60000.0000,'fixed',0.0000,60000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:58:22','2025-04-23 11:58:22'),(569,365,124,124,2.0000,0.0000,0.0000,14000.0000,14000.0000,'fixed',0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:58:22','2025-04-23 11:58:22'),(570,365,196,196,1.0000,0.0000,0.0000,5000.0000,5000.0000,'fixed',0.0000,5000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:58:22','2025-04-23 11:58:22'),(571,365,123,123,1.0000,0.0000,0.0000,26000.0000,26000.0000,'fixed',0.0000,26000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:58:22','2025-04-23 11:58:22'),(572,365,163,163,4.0000,0.0000,0.0000,9000.0000,9000.0000,'fixed',0.0000,9000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 11:58:23','2025-04-23 11:58:23'),(573,366,194,194,76.0000,0.0000,0.0000,6284.0000,6284.0000,NULL,0.0000,6284.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(574,366,191,191,142.0000,0.0000,0.0000,4700.0000,4700.0000,NULL,0.0000,4700.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(575,366,193,193,112.0000,0.0000,0.0000,8402.0000,8402.0000,NULL,0.0000,8402.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(576,366,167,167,100.0000,0.0000,0.0000,14000.0000,14000.0000,NULL,0.0000,14000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(577,366,150,150,60.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47'),(578,366,148,148,50.0000,0.0000,0.0000,75000.0000,75000.0000,NULL,0.0000,75000.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-04-23 12:26:47','2025-04-23 12:26:47');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB AUTO_INCREMENT=564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,NULL,1,147,103.0000,0.0000,'2025-04-15 16:42:37','2025-04-15 16:42:37'),(26,33,NULL,136,1.0000,0.0000,'2025-04-17 07:00:33','2025-04-17 07:00:33'),(27,34,NULL,122,37.0000,0.0000,'2025-04-17 08:14:17','2025-04-17 08:14:17'),(28,35,NULL,122,37.0000,0.0000,'2025-04-17 08:16:54','2025-04-17 08:16:54'),(29,36,NULL,116,5.0000,0.0000,'2025-04-17 08:38:25','2025-04-17 08:38:25'),(30,37,NULL,121,36.0000,0.0000,'2025-04-17 08:50:15','2025-04-17 08:50:15'),(31,38,NULL,42,30.0000,0.0000,'2025-04-17 08:53:08','2025-04-17 08:53:08'),(32,39,NULL,50,17.0000,0.0000,'2025-04-17 08:56:30','2025-04-17 08:56:30'),(33,40,NULL,57,70.0000,0.0000,'2025-04-17 09:09:13','2025-04-17 09:09:13'),(34,41,NULL,126,234.0000,0.0000,'2025-04-17 09:22:10','2025-04-17 09:22:10'),(35,42,NULL,118,3.0000,0.0000,'2025-04-17 09:34:13','2025-04-17 09:34:13'),(36,43,NULL,92,60.0000,0.0000,'2025-04-17 09:43:55','2025-04-17 09:43:55'),(37,44,NULL,22,1.0000,0.0000,'2025-04-17 09:51:36','2025-04-17 09:51:36'),(38,45,NULL,26,10.0000,0.0000,'2025-04-17 09:51:36','2025-04-17 09:51:36'),(39,46,NULL,34,152.0000,0.0000,'2025-04-17 10:30:40','2025-04-17 10:30:40'),(40,47,NULL,108,31.0000,0.0000,'2025-04-17 10:30:41','2025-04-17 10:30:41'),(41,48,NULL,55,13.0000,0.0000,'2025-04-17 10:30:41','2025-04-17 10:30:41'),(42,49,NULL,32,351.0000,0.0000,'2025-04-17 10:30:41','2025-04-17 10:30:41'),(43,50,NULL,80,14.0000,0.0000,'2025-04-17 10:30:41','2025-04-17 10:30:41'),(44,51,NULL,45,131.0000,0.0000,'2025-04-17 10:30:41','2025-04-17 10:30:41'),(45,52,NULL,35,11.0000,0.0000,'2025-04-17 10:41:41','2025-04-17 10:41:41'),(46,53,NULL,20,8.0000,0.0000,'2025-04-17 10:51:21','2025-04-17 10:51:21'),(47,54,NULL,109,30.0000,0.0000,'2025-04-17 10:51:21','2025-04-17 10:51:21'),(48,55,NULL,17,11.0000,0.0000,'2025-04-17 10:51:21','2025-04-17 10:51:21'),(49,56,NULL,110,32.0000,0.0000,'2025-04-17 10:51:21','2025-04-17 10:51:21'),(50,57,NULL,27,2.0000,0.0000,'2025-04-17 11:15:42','2025-04-17 11:15:42'),(51,58,NULL,131,1.0000,0.0000,'2025-04-17 12:20:23','2025-04-17 12:20:23'),(52,59,NULL,87,3.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(53,60,NULL,75,5.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(54,61,NULL,46,45.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(55,62,NULL,28,77.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(56,63,NULL,90,35.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(57,64,NULL,112,1.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(58,65,NULL,48,4.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(59,66,NULL,93,47.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(60,67,NULL,70,59.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(61,68,NULL,89,1.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(62,69,NULL,79,13.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(63,70,NULL,58,27.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(64,71,NULL,65,9.0000,0.0000,'2025-04-17 12:20:24','2025-04-17 12:20:24'),(65,72,NULL,84,9.0000,0.0000,'2025-04-17 12:20:26','2025-04-17 12:20:26'),(66,73,NULL,86,25.0000,0.0000,'2025-04-17 12:20:27','2025-04-17 12:20:27'),(75,90,NULL,136,23.0000,0.0000,'2025-04-18 08:53:58','2025-04-18 08:53:58'),(76,91,NULL,166,200.0000,0.0000,'2025-04-18 09:05:37','2025-04-18 09:05:37'),(77,92,NULL,136,552.0000,0.0000,'2025-04-18 09:10:15','2025-04-18 09:10:15'),(78,93,NULL,163,300.0000,0.0000,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(79,94,NULL,156,4200.0000,0.0000,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(80,95,NULL,162,1500.0000,0.0000,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(81,96,NULL,144,160.0000,0.0000,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(82,97,NULL,165,5000.0000,0.0000,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(83,98,NULL,237,240.0000,0.0000,'2025-04-18 09:30:50','2025-04-18 09:30:50'),(84,99,NULL,249,112.0000,0.0000,'2025-04-18 09:46:11','2025-04-18 09:46:11'),(85,100,NULL,139,80.0000,0.0000,'2025-04-18 09:48:45','2025-04-18 09:48:45'),(86,101,NULL,150,390.0000,0.0000,'2025-04-18 10:04:11','2025-04-18 10:04:11'),(87,102,NULL,141,900.0000,0.0000,'2025-04-18 10:04:11','2025-04-18 10:04:11'),(88,103,NULL,141,200.0000,0.0000,'2025-04-18 10:12:46','2025-04-18 10:12:46'),(89,104,NULL,201,10.0000,0.0000,'2025-04-18 10:12:46','2025-04-18 10:12:46'),(90,105,NULL,196,16.0000,0.0000,'2025-04-18 10:12:46','2025-04-18 10:12:46'),(91,106,NULL,194,60.0000,0.0000,'2025-04-18 10:12:47','2025-04-18 10:12:47'),(92,107,NULL,198,30.0000,0.0000,'2025-04-18 10:12:47','2025-04-18 10:12:47'),(93,108,NULL,239,900.0000,0.0000,'2025-04-18 10:35:47','2025-04-18 10:35:47'),(94,109,NULL,140,80.0000,0.0000,'2025-04-18 10:35:47','2025-04-18 10:35:47'),(95,110,NULL,164,120.0000,0.0000,'2025-04-18 10:35:47','2025-04-18 10:35:47'),(96,111,NULL,169,250.0000,0.0000,'2025-04-18 10:35:47','2025-04-18 10:35:47'),(97,112,NULL,171,20.0000,0.0000,'2025-04-18 10:35:47','2025-04-18 10:35:47'),(98,113,NULL,168,30.0000,0.0000,'2025-04-18 10:35:47','2025-04-18 10:35:47'),(99,114,NULL,138,400.0000,0.0000,'2025-04-18 10:43:56','2025-04-18 10:43:56'),(100,115,NULL,153,60.0000,0.0000,'2025-04-18 10:43:56','2025-04-18 10:43:56'),(101,116,NULL,142,75.0000,0.0000,'2025-04-18 10:43:56','2025-04-18 10:43:56'),(102,117,NULL,202,16.0000,0.0000,'2025-04-18 11:24:25','2025-04-18 11:24:25'),(103,118,NULL,147,60.0000,0.0000,'2025-04-18 11:25:14','2025-04-18 11:25:14'),(104,119,NULL,148,60.0000,0.0000,'2025-04-18 11:25:14','2025-04-18 11:25:14'),(105,120,NULL,200,384.0000,0.0000,'2025-04-18 11:25:14','2025-04-18 11:25:14'),(106,121,NULL,201,220.0000,0.0000,'2025-04-18 11:25:14','2025-04-18 11:25:14'),(107,122,NULL,202,208.0000,0.0000,'2025-04-18 11:25:14','2025-04-18 11:25:14'),(108,123,NULL,203,78.0000,0.0000,'2025-04-18 11:56:27','2025-04-18 11:56:27'),(109,124,NULL,197,150.0000,0.0000,'2025-04-18 11:56:27','2025-04-18 11:56:27'),(110,125,NULL,199,240.0000,0.0000,'2025-04-18 11:56:28','2025-04-18 11:56:28'),(111,126,NULL,196,152.0000,0.0000,'2025-04-18 11:56:28','2025-04-18 11:56:28'),(112,127,NULL,195,3289.0000,0.0000,'2025-04-18 11:56:28','2025-04-18 11:56:28'),(113,128,NULL,194,3600.0000,0.0000,'2025-04-18 11:56:28','2025-04-18 11:56:28'),(114,129,NULL,159,300.0000,0.0000,'2025-04-18 11:56:28','2025-04-18 11:56:28'),(115,130,NULL,146,120.0000,0.0000,'2025-04-18 11:56:29','2025-04-18 11:56:29'),(116,131,NULL,175,48.0000,0.0000,'2025-04-18 11:56:29','2025-04-18 11:56:29'),(117,132,NULL,140,80.0000,0.0000,'2025-04-18 12:00:38','2025-04-18 12:00:38'),(118,133,NULL,239,50.0000,0.0000,'2025-04-18 12:00:39','2025-04-18 12:00:39'),(119,134,NULL,202,8.0000,0.0000,'2025-04-18 12:00:39','2025-04-18 12:00:39'),(120,135,NULL,140,80.0000,0.0000,'2025-04-18 12:01:31','2025-04-18 12:01:31'),(121,136,NULL,239,50.0000,0.0000,'2025-04-18 12:01:32','2025-04-18 12:01:32'),(122,137,NULL,202,8.0000,0.0000,'2025-04-18 12:01:32','2025-04-18 12:01:32'),(123,138,NULL,201,10.0000,0.0000,'2025-04-18 12:55:12','2025-04-18 12:55:12'),(124,139,NULL,203,6.0000,0.0000,'2025-04-18 12:55:12','2025-04-18 12:55:12'),(125,140,NULL,139,40.0000,0.0000,'2025-04-18 12:55:12','2025-04-18 12:55:12'),(126,141,NULL,194,40.0000,0.0000,'2025-04-18 12:55:12','2025-04-18 12:55:12'),(127,142,NULL,294,100.0000,0.0000,'2025-04-18 13:31:14','2025-04-18 13:31:14'),(128,143,NULL,295,40.0000,0.0000,'2025-04-18 13:34:46','2025-04-18 13:34:46'),(129,144,NULL,165,1000.0000,0.0000,'2025-04-18 13:41:39','2025-04-18 13:41:39'),(130,145,NULL,185,300.0000,0.0000,'2025-04-18 13:44:14','2025-04-18 13:44:14'),(131,146,NULL,137,1.0000,0.0000,'2025-04-18 13:49:18','2025-04-18 13:49:18'),(132,147,NULL,180,48.0000,0.0000,'2025-04-18 14:05:32','2025-04-18 14:05:32'),(133,148,NULL,198,490.0000,0.0000,'2025-04-18 14:19:08','2025-04-18 14:19:08'),(134,149,NULL,46,64.0000,0.0000,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(135,150,NULL,126,450.0000,0.0000,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(136,151,NULL,39,495.0000,0.0000,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(137,152,NULL,45,144.0000,0.0000,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(138,153,NULL,122,48.0000,0.0000,'2025-04-18 15:10:02','2025-04-18 15:10:02'),(139,154,NULL,85,2.0000,0.0000,'2025-04-18 15:10:03','2025-04-18 15:10:03'),(140,156,NULL,303,2.0000,0.0000,'2025-04-18 19:57:36','2025-04-18 19:57:36'),(141,157,NULL,302,108.0000,0.0000,'2025-04-19 07:39:47','2025-04-19 07:39:47'),(142,158,NULL,245,309.0000,0.0000,'2025-04-19 07:46:36','2025-04-19 07:46:36'),(143,159,NULL,66,110.0000,0.0000,'2025-04-19 07:46:36','2025-04-19 07:46:36'),(144,160,NULL,266,110.0000,0.0000,'2025-04-19 07:46:36','2025-04-19 07:46:36'),(145,161,NULL,283,29.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(146,162,NULL,75,2.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(147,163,NULL,28,152.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(148,164,NULL,90,27.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(149,165,NULL,48,3.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(150,166,NULL,302,25.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(151,167,NULL,70,60.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(152,168,NULL,79,35.0000,0.0000,'2025-04-19 10:10:47','2025-04-19 10:10:47'),(153,169,NULL,58,32.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(154,170,NULL,61,1.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(155,171,NULL,65,3.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(156,172,NULL,84,3.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(157,173,NULL,86,6.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(158,174,NULL,40,37.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(159,175,NULL,16,20.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(160,176,NULL,127,3.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(161,177,NULL,81,66.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(162,178,NULL,33,31.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(163,179,NULL,66,6.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(164,180,NULL,247,658.0000,0.0000,'2025-04-19 10:10:48','2025-04-19 10:10:48'),(165,181,NULL,145,1.0000,0.0000,'2025-04-19 11:13:25','2025-04-19 11:13:25'),(166,182,NULL,187,112.0000,0.0000,'2025-04-19 11:27:37','2025-04-19 11:27:37'),(167,183,NULL,186,112.0000,0.0000,'2025-04-19 11:27:37','2025-04-19 11:27:37'),(168,184,NULL,188,112.0000,0.0000,'2025-04-19 11:27:37','2025-04-19 11:27:37'),(169,185,NULL,157,42.0000,0.0000,'2025-04-19 11:36:29','2025-04-19 11:36:29'),(170,186,NULL,149,240.0000,0.0000,'2025-04-19 11:41:06','2025-04-19 11:41:06'),(171,187,NULL,148,60.0000,0.0000,'2025-04-19 11:41:06','2025-04-19 11:41:06'),(172,188,NULL,280,147.0000,0.0000,'2025-04-19 13:23:57','2025-04-19 13:23:57'),(173,189,NULL,260,685.0000,0.0000,'2025-04-19 13:23:57','2025-04-19 13:23:57'),(174,190,NULL,68,93.0000,0.0000,'2025-04-19 13:23:57','2025-04-19 13:23:57'),(175,191,NULL,76,26.0000,0.0000,'2025-04-19 13:23:57','2025-04-19 13:23:57'),(176,192,NULL,88,55.0000,0.0000,'2025-04-19 13:23:57','2025-04-19 13:23:57'),(177,193,NULL,112,18.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(178,194,NULL,43,115.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(179,195,NULL,77,1.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(180,196,NULL,248,45.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(181,197,NULL,85,3.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(182,198,NULL,69,95.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(183,199,NULL,79,30.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(184,200,NULL,272,45.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(185,201,NULL,273,56.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(186,202,NULL,274,65.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(187,203,NULL,275,12.0000,0.0000,'2025-04-19 13:23:58','2025-04-19 13:23:58'),(188,204,NULL,124,3.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(189,205,NULL,277,95.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(190,206,NULL,278,38.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(191,207,NULL,254,143.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(192,208,NULL,279,348.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(193,209,NULL,91,4.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(194,210,NULL,276,57.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(195,211,NULL,132,8.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(196,212,NULL,251,39.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(197,213,NULL,95,3.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(198,214,NULL,120,1.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(199,215,NULL,45,136.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(200,216,NULL,280,818.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(201,217,NULL,279,251.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(202,218,NULL,32,116.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(203,219,NULL,99,1.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(204,220,NULL,121,32.0000,0.0000,'2025-04-19 13:23:59','2025-04-19 13:23:59'),(205,221,NULL,60,56.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(206,222,NULL,254,153.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(207,223,NULL,302,58.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(208,224,NULL,62,2.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(209,225,NULL,34,70.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(210,226,NULL,245,6.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(211,227,NULL,305,7.0000,0.0000,'2025-04-19 13:24:00','2025-04-19 13:24:00'),(212,228,NULL,311,500.0000,0.0000,'2025-04-19 13:46:21','2025-04-19 13:46:21'),(213,229,NULL,109,9.0000,0.0000,'2025-04-19 14:50:18','2025-04-19 14:50:18'),(214,230,NULL,110,3.0000,0.0000,'2025-04-19 14:50:19','2025-04-19 14:50:19'),(215,231,NULL,25,10.0000,0.0000,'2025-04-19 14:50:19','2025-04-19 14:50:19'),(216,232,NULL,27,1.0000,0.0000,'2025-04-19 14:50:19','2025-04-19 14:50:19'),(217,233,NULL,87,1.0000,0.0000,'2025-04-19 14:50:19','2025-04-19 14:50:19'),(218,234,NULL,50,1.0000,0.0000,'2025-04-19 14:54:06','2025-04-19 14:54:06'),(219,235,NULL,13,19.0000,0.0000,'2025-04-19 15:11:24','2025-04-19 15:11:24'),(220,236,NULL,243,112.0000,0.0000,'2025-04-19 15:16:05','2025-04-19 15:16:05'),(221,237,NULL,195,60.0000,0.0000,'2025-04-19 15:49:18','2025-04-19 15:49:18'),(222,238,NULL,197,50.0000,0.0000,'2025-04-19 15:49:18','2025-04-19 15:49:18'),(223,239,NULL,142,75.0000,0.0000,'2025-04-19 15:49:19','2025-04-19 15:49:19'),(224,240,NULL,315,90.0000,0.0000,'2025-04-19 15:49:19','2025-04-19 15:49:19'),(225,241,NULL,150,60.0000,0.0000,'2025-04-19 15:49:19','2025-04-19 15:49:19'),(226,242,NULL,198,20.0000,0.0000,'2025-04-19 15:49:19','2025-04-19 15:49:19'),(227,243,NULL,272,1.0000,0.0000,'2025-04-20 18:31:59','2025-04-20 18:31:59'),(228,244,NULL,90,2.0000,0.0000,'2025-04-20 18:31:59','2025-04-20 18:31:59'),(229,245,NULL,38,2.0000,0.0000,'2025-04-20 18:31:59','2025-04-20 18:31:59'),(230,246,NULL,68,2.0000,0.0000,'2025-04-20 18:31:59','2025-04-20 18:31:59'),(231,247,NULL,279,10.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(232,248,NULL,55,3.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(233,249,NULL,11,2.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(234,250,NULL,3,4.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(235,251,NULL,279,1.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(236,252,NULL,123,3.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(237,253,NULL,253,1.0000,0.0000,'2025-04-20 18:32:00','2025-04-20 18:32:00'),(238,254,NULL,91,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(239,255,NULL,302,5.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(240,256,NULL,60,6.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(241,257,NULL,81,2.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(242,258,NULL,106,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(243,259,NULL,251,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(244,260,NULL,39,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(245,261,NULL,275,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(246,262,NULL,6,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(247,263,NULL,307,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(248,264,NULL,90,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(249,265,NULL,276,1.0000,0.0000,'2025-04-20 18:32:01','2025-04-20 18:32:01'),(250,266,NULL,60,2.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(251,267,NULL,247,20.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(252,268,NULL,3,1.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(253,269,NULL,299,2.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(254,270,NULL,299,2.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(255,271,NULL,37,6.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(256,272,NULL,297,1.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(257,273,NULL,17,3.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(258,274,NULL,90,1.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(259,275,NULL,76,1.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(260,276,NULL,113,1.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(261,277,NULL,244,2.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(262,278,NULL,244,3.0000,0.0000,'2025-04-20 18:32:02','2025-04-20 18:32:02'),(263,279,NULL,254,2.0000,0.0000,'2025-04-20 18:32:03','2025-04-20 18:32:03'),(264,280,NULL,93,1.0000,0.0000,'2025-04-20 19:37:13','2025-04-20 19:37:13'),(265,281,NULL,121,3.0000,0.0000,'2025-04-20 19:37:13','2025-04-20 19:37:13'),(266,282,NULL,90,1.0000,0.0000,'2025-04-20 19:37:13','2025-04-20 19:37:13'),(267,283,NULL,254,12.0000,0.0000,'2025-04-20 19:37:13','2025-04-20 19:37:13'),(268,284,NULL,116,1.0000,0.0000,'2025-04-20 19:37:13','2025-04-20 19:37:13'),(269,285,NULL,274,1.0000,0.0000,'2025-04-20 19:37:14','2025-04-20 19:37:14'),(270,286,NULL,54,1.0000,0.0000,'2025-04-20 19:37:14','2025-04-20 19:37:14'),(271,287,NULL,61,1.0000,0.0000,'2025-04-20 19:37:14','2025-04-20 19:37:14'),(272,288,NULL,245,1.0000,0.0000,'2025-04-20 19:37:14','2025-04-20 19:37:14'),(273,289,NULL,90,1.0000,0.0000,'2025-04-20 19:37:14','2025-04-20 19:37:14'),(274,290,NULL,280,1.0000,0.0000,'2025-04-20 19:37:14','2025-04-20 19:37:14'),(275,291,NULL,60,10.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(276,292,NULL,77,1.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(277,293,NULL,45,1.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(278,294,NULL,299,2.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(279,295,NULL,60,1.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(280,296,NULL,40,1.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(281,297,NULL,244,10.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(282,298,NULL,90,1.0000,0.0000,'2025-04-20 19:37:15','2025-04-20 19:37:15'),(283,299,NULL,70,1.0000,0.0000,'2025-04-20 19:37:16','2025-04-20 19:37:16'),(284,300,NULL,296,1.0000,0.0000,'2025-04-20 19:37:16','2025-04-20 19:37:16'),(285,301,NULL,122,1.0000,0.0000,'2025-04-20 19:37:16','2025-04-20 19:37:16'),(286,302,NULL,72,1.0000,0.0000,'2025-04-20 19:37:16','2025-04-20 19:37:16'),(287,303,NULL,60,10.0000,0.0000,'2025-04-20 19:51:31','2025-04-20 19:51:31'),(288,304,NULL,272,1.0000,0.0000,'2025-04-20 19:51:31','2025-04-20 19:51:31'),(289,305,NULL,33,3.0000,0.0000,'2025-04-20 19:51:32','2025-04-20 19:51:32'),(290,306,NULL,61,1.0000,0.0000,'2025-04-20 19:51:32','2025-04-20 19:51:32'),(291,307,NULL,50,2.0000,0.0000,'2025-04-20 19:51:32','2025-04-20 19:51:32'),(292,308,NULL,60,1.0000,0.0000,'2025-04-20 19:51:32','2025-04-20 19:51:32'),(293,309,NULL,42,1.0000,0.0000,'2025-04-20 19:51:32','2025-04-20 19:51:32'),(294,310,NULL,81,1.0000,0.0000,'2025-04-20 19:51:32','2025-04-20 19:51:32'),(295,311,NULL,122,1.0000,0.0000,'2025-04-20 19:51:33','2025-04-20 19:51:33'),(296,312,NULL,110,4.0000,0.0000,'2025-04-20 19:51:33','2025-04-20 19:51:33'),(297,313,NULL,29,1.0000,0.0000,'2025-04-20 19:51:33','2025-04-20 19:51:33'),(298,314,NULL,61,1.0000,0.0000,'2025-04-20 20:46:48','2025-04-20 20:46:48'),(299,315,NULL,127,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(300,316,NULL,241,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(301,317,NULL,93,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(302,318,NULL,279,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(303,319,NULL,280,2.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(304,320,NULL,29,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(305,321,NULL,61,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(306,322,NULL,241,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(307,323,NULL,42,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(308,324,NULL,105,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(309,325,NULL,70,2.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(310,326,NULL,45,1.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(311,327,NULL,125,6.0000,0.0000,'2025-04-20 20:46:49','2025-04-20 20:46:49'),(312,328,NULL,69,2.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(313,329,NULL,272,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(314,330,NULL,45,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(315,331,NULL,244,7.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(316,332,NULL,279,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(317,333,NULL,280,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(318,334,NULL,243,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(319,335,NULL,69,5.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(320,336,NULL,305,2.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(321,337,NULL,272,2.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(322,338,NULL,43,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(323,339,NULL,93,1.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(324,340,NULL,254,5.0000,0.0000,'2025-04-20 20:46:50','2025-04-20 20:46:50'),(325,341,NULL,302,3.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(326,342,NULL,305,2.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(327,343,NULL,273,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(328,344,NULL,274,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(329,345,NULL,279,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(330,346,NULL,280,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(331,347,NULL,74,2.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(332,348,NULL,93,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(333,349,NULL,279,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(334,350,NULL,123,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(335,351,NULL,277,2.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(336,352,NULL,278,1.0000,0.0000,'2025-04-20 20:46:51','2025-04-20 20:46:51'),(337,353,NULL,274,1.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(338,354,NULL,241,3.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(339,355,NULL,60,2.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(340,356,NULL,40,1.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(341,357,NULL,110,3.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(342,358,NULL,262,1.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(343,359,NULL,244,7.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(344,360,NULL,108,1.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(345,361,NULL,297,2.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(346,362,NULL,66,14.0000,0.0000,'2025-04-20 20:46:52','2025-04-20 20:46:52'),(347,363,NULL,81,2.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(348,364,NULL,29,2.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(349,365,NULL,118,1.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(350,366,NULL,305,2.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(351,367,NULL,278,1.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(352,368,NULL,302,1.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(353,369,NULL,124,1.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(354,370,NULL,90,1.0000,0.0000,'2025-04-20 20:46:53','2025-04-20 20:46:53'),(355,371,NULL,46,31.0000,0.0000,'2025-04-21 07:56:04','2025-04-21 07:56:04'),(356,372,NULL,312,73.0000,0.0000,'2025-04-21 07:56:04','2025-04-21 07:56:04'),(357,373,NULL,146,60.0000,0.0000,'2025-04-21 08:17:09','2025-04-21 08:17:09'),(358,374,NULL,121,3.0000,0.0000,'2025-04-21 08:44:10','2025-04-21 08:44:10'),(359,375,NULL,93,4.0000,0.0000,'2025-04-21 08:44:10','2025-04-21 08:44:10'),(360,376,NULL,45,2.0000,0.0000,'2025-04-21 09:03:06','2025-04-21 09:03:06'),(361,377,NULL,323,50.0000,0.0000,'2025-04-21 09:20:51','2025-04-21 09:20:51'),(362,378,NULL,126,5.0000,0.0000,'2025-04-21 09:30:34','2025-04-21 09:30:34'),(363,379,NULL,39,3.0000,0.0000,'2025-04-21 11:18:05','2025-04-21 11:18:05'),(364,380,NULL,66,6.0000,0.0000,'2025-04-21 11:18:05','2025-04-21 11:18:05'),(365,381,NULL,296,1.0000,0.0000,'2025-04-21 11:18:05','2025-04-21 11:18:05'),(366,382,NULL,121,1.0000,0.0000,'2025-04-21 11:18:05','2025-04-21 11:18:05'),(367,383,NULL,127,1.0000,0.0000,'2025-04-21 11:18:06','2025-04-21 11:18:06'),(368,384,NULL,35,7.0000,0.0000,'2025-04-21 11:18:06','2025-04-21 11:18:06'),(369,385,NULL,94,1.0000,0.0000,'2025-04-21 11:18:06','2025-04-21 11:18:06'),(370,386,NULL,268,2.0000,0.0000,'2025-04-21 11:25:38','2025-04-21 11:25:38'),(371,387,NULL,279,1.0000,0.0000,'2025-04-21 12:16:16','2025-04-21 12:16:16'),(372,388,NULL,279,1.0000,0.0000,'2025-04-21 12:16:16','2025-04-21 12:16:16'),(373,389,NULL,280,1.0000,0.0000,'2025-04-21 12:16:17','2025-04-21 12:16:17'),(374,390,NULL,45,1.0000,0.0000,'2025-04-21 12:16:17','2025-04-21 12:16:17'),(375,391,NULL,56,20.0000,0.0000,'2025-04-21 12:16:17','2025-04-21 12:16:17'),(376,392,NULL,87,1.0000,0.0000,'2025-04-21 12:16:17','2025-04-21 12:16:17'),(377,393,NULL,14,3.0000,0.0000,'2025-04-21 13:13:01','2025-04-21 13:13:01'),(378,394,NULL,280,2.0000,0.0000,'2025-04-21 13:51:05','2025-04-21 13:51:05'),(379,395,NULL,282,3.0000,0.0000,'2025-04-21 13:51:06','2025-04-21 13:51:06'),(380,396,NULL,56,1.0000,0.0000,'2025-04-21 13:51:06','2025-04-21 13:51:06'),(381,397,NULL,261,1.0000,0.0000,'2025-04-21 13:51:07','2025-04-21 13:51:07'),(382,398,NULL,268,1.0000,0.0000,'2025-04-21 13:51:07','2025-04-21 13:51:07'),(383,399,NULL,123,2.0000,0.0000,'2025-04-21 13:51:07','2025-04-21 13:51:07'),(384,400,NULL,312,2.0000,0.0000,'2025-04-21 13:51:07','2025-04-21 13:51:07'),(385,401,NULL,126,2.0000,0.0000,'2025-04-21 13:51:07','2025-04-21 13:51:07'),(386,402,NULL,118,1.0000,0.0000,'2025-04-21 13:51:08','2025-04-21 13:51:08'),(387,403,NULL,268,1.0000,0.0000,'2025-04-21 13:51:08','2025-04-21 13:51:08'),(388,404,NULL,302,1.0000,0.0000,'2025-04-21 13:51:08','2025-04-21 13:51:08'),(389,405,NULL,40,1.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(390,406,NULL,279,3.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(391,407,NULL,305,2.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(392,408,NULL,306,3.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(393,409,NULL,29,3.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(394,410,NULL,42,1.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(395,411,NULL,45,1.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(396,412,NULL,79,2.0000,0.0000,'2025-04-21 14:17:40','2025-04-21 14:17:40'),(397,413,NULL,140,40.0000,0.0000,'2025-04-21 14:43:09','2025-04-21 14:43:09'),(398,414,NULL,239,50.0000,0.0000,'2025-04-21 14:43:09','2025-04-21 14:43:09'),(399,415,NULL,166,100.0000,0.0000,'2025-04-21 14:43:10','2025-04-21 14:43:10'),(400,416,NULL,196,14.0000,0.0000,'2025-04-21 14:43:10','2025-04-21 14:43:10'),(401,417,NULL,199,40.0000,0.0000,'2025-04-21 14:43:10','2025-04-21 14:43:10'),(402,418,NULL,143,100.0000,0.0000,'2025-04-21 14:43:10','2025-04-21 14:43:10'),(403,419,NULL,198,50.0000,0.0000,'2025-04-21 14:43:10','2025-04-21 14:43:10'),(404,420,NULL,295,40.0000,0.0000,'2025-04-21 14:43:11','2025-04-21 14:43:11'),(405,421,NULL,74,1.0000,0.0000,'2025-04-21 15:17:58','2025-04-21 15:17:58'),(406,422,NULL,74,1.0000,0.0000,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(407,423,NULL,74,1.0000,0.0000,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(408,424,NULL,306,4.0000,0.0000,'2025-04-21 17:27:38','2025-04-21 17:27:38'),(409,425,NULL,123,3.0000,0.0000,'2025-04-21 17:27:38','2025-04-21 17:27:38'),(410,426,NULL,279,1.0000,0.0000,'2025-04-21 17:27:38','2025-04-21 17:27:38'),(411,427,NULL,278,1.0000,0.0000,'2025-04-21 17:27:38','2025-04-21 17:27:38'),(412,428,NULL,126,1.0000,0.0000,'2025-04-21 17:27:38','2025-04-21 17:27:38'),(413,429,NULL,268,1.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(414,430,NULL,110,3.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(415,431,NULL,68,4.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(416,432,NULL,244,6.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(417,433,NULL,117,1.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(418,434,NULL,278,2.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(419,435,NULL,302,1.0000,0.0000,'2025-04-21 17:27:39','2025-04-21 17:27:39'),(420,436,NULL,241,1.0000,0.0000,'2025-04-21 17:30:55','2025-04-21 17:30:55'),(421,437,NULL,58,24.0000,0.0000,'2025-04-22 08:43:04','2025-04-22 08:43:04'),(422,438,NULL,306,34.0000,0.0000,'2025-04-22 08:43:05','2025-04-22 08:43:05'),(423,439,NULL,305,40.0000,0.0000,'2025-04-22 08:43:05','2025-04-22 08:43:05'),(424,440,NULL,60,67.0000,0.0000,'2025-04-22 08:43:05','2025-04-22 08:43:05'),(425,441,NULL,330,100.0000,0.0000,'2025-04-22 08:43:05','2025-04-22 08:43:05'),(426,442,NULL,40,58.0000,0.0000,'2025-04-22 08:43:05','2025-04-22 08:43:05'),(427,443,NULL,244,374.0000,0.0000,'2025-04-22 08:43:05','2025-04-22 08:43:05'),(428,444,NULL,34,23.0000,0.0000,'2025-04-22 08:43:06','2025-04-22 08:43:06'),(429,445,NULL,25,7.0000,0.0000,'2025-04-22 08:43:06','2025-04-22 08:43:06'),(430,446,NULL,22,4.0000,0.0000,'2025-04-22 08:43:06','2025-04-22 08:43:06'),(431,447,NULL,27,6.0000,0.0000,'2025-04-22 08:43:06','2025-04-22 08:43:06'),(432,448,NULL,110,25.0000,0.0000,'2025-04-22 08:43:06','2025-04-22 08:43:06'),(433,449,NULL,20,8.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(434,450,NULL,308,2.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(435,451,NULL,81,25.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(436,452,NULL,28,127.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(437,453,NULL,69,14.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(438,454,NULL,79,4.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(439,455,NULL,299,124.0000,0.0000,'2025-04-22 08:43:07','2025-04-22 08:43:07'),(440,456,NULL,30,21.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(441,457,NULL,31,23.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(442,458,NULL,55,42.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(443,459,NULL,62,1.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(444,460,NULL,42,24.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(445,461,NULL,240,23.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(446,461,NULL,242,84.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(447,462,NULL,56,590.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(448,463,NULL,132,26.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(449,464,NULL,112,52.0000,0.0000,'2025-04-22 08:43:08','2025-04-22 08:43:08'),(450,465,NULL,110,7.0000,0.0000,'2025-04-22 08:43:09','2025-04-22 08:43:09'),(451,466,NULL,50,3.0000,0.0000,'2025-04-22 08:43:09','2025-04-22 08:43:09'),(452,467,NULL,109,5.0000,0.0000,'2025-04-22 08:43:09','2025-04-22 08:43:09'),(453,468,NULL,268,21.0000,0.0000,'2025-04-22 08:43:10','2025-04-22 08:43:10'),(454,469,NULL,117,7.0000,0.0000,'2025-04-22 08:43:10','2025-04-22 08:43:10'),(455,470,NULL,92,55.0000,0.0000,'2025-04-22 08:43:10','2025-04-22 08:43:10'),(456,471,NULL,48,1.0000,0.0000,'2025-04-22 08:43:10','2025-04-22 08:43:10'),(457,472,NULL,261,15.0000,0.0000,'2025-04-22 08:43:10','2025-04-22 08:43:10'),(458,473,NULL,283,3.0000,0.0000,'2025-04-22 08:43:11','2025-04-22 08:43:11'),(459,474,NULL,83,1.0000,0.0000,'2025-04-22 08:43:11','2025-04-22 08:43:11'),(460,475,NULL,243,57.0000,0.0000,'2025-04-22 08:43:12','2025-04-22 08:43:12'),(461,476,NULL,119,4.0000,0.0000,'2025-04-22 08:43:12','2025-04-22 08:43:12'),(462,477,NULL,74,1.0000,0.0000,'2025-04-22 08:43:12','2025-04-22 08:43:12'),(463,478,NULL,279,144.0000,0.0000,'2025-04-22 08:43:12','2025-04-22 08:43:12'),(464,479,NULL,280,489.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(465,480,NULL,272,126.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(466,481,NULL,273,46.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(467,482,NULL,274,97.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(468,483,NULL,275,34.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(469,484,NULL,35,100.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(470,485,NULL,118,1.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(471,486,NULL,277,31.0000,0.0000,'2025-04-22 08:43:13','2025-04-22 08:43:13'),(472,487,NULL,278,1.0000,0.0000,'2025-04-22 08:43:14','2025-04-22 08:43:14'),(473,488,NULL,278,45.0000,0.0000,'2025-04-22 08:43:15','2025-04-22 08:43:15'),(474,489,NULL,68,5.0000,0.0000,'2025-04-22 08:43:15','2025-04-22 08:43:15'),(475,490,NULL,296,45.0000,0.0000,'2025-04-22 08:43:15','2025-04-22 08:43:15'),(476,491,NULL,74,3.0000,0.0000,'2025-04-22 08:43:15','2025-04-22 08:43:15'),(477,492,NULL,91,10.0000,0.0000,'2025-04-22 08:43:16','2025-04-22 08:43:16'),(478,493,NULL,276,25.0000,0.0000,'2025-04-22 08:43:17','2025-04-22 08:43:17'),(479,494,NULL,77,50.0000,0.0000,'2025-04-22 08:43:17','2025-04-22 08:43:17'),(480,495,NULL,282,24.0000,0.0000,'2025-04-22 08:43:18','2025-04-22 08:43:18'),(481,496,NULL,254,1.0000,0.0000,'2025-04-22 09:06:23','2025-04-22 09:06:23'),(482,497,NULL,302,1.0000,0.0000,'2025-04-22 09:06:23','2025-04-22 09:06:23'),(483,498,NULL,92,3.0000,0.0000,'2025-04-22 09:06:23','2025-04-22 09:06:23'),(484,499,NULL,280,1.0000,0.0000,'2025-04-22 09:06:23','2025-04-22 09:06:23'),(485,500,NULL,247,10.0000,0.0000,'2025-04-22 09:06:23','2025-04-22 09:06:23'),(486,501,NULL,302,1.0000,0.0000,'2025-04-22 10:21:28','2025-04-22 10:21:28'),(487,502,NULL,45,8.0000,0.0000,'2025-04-22 10:21:28','2025-04-22 10:21:28'),(488,503,NULL,93,1.0000,0.0000,'2025-04-22 10:21:28','2025-04-22 10:21:28'),(489,504,NULL,280,1.0000,0.0000,'2025-04-22 10:21:28','2025-04-22 10:21:28'),(490,505,NULL,122,6.0000,0.0000,'2025-04-22 10:21:28','2025-04-22 10:21:28'),(491,506,NULL,268,1.0000,0.0000,'2025-04-22 11:04:37','2025-04-22 11:04:37'),(492,507,NULL,244,4.0000,0.0000,'2025-04-22 11:04:37','2025-04-22 11:04:37'),(493,508,NULL,34,4.0000,0.0000,'2025-04-22 11:04:37','2025-04-22 11:04:37'),(494,509,NULL,245,2.0000,0.0000,'2025-04-22 11:04:37','2025-04-22 11:04:37'),(495,510,NULL,126,26.0000,0.0000,'2025-04-22 11:04:38','2025-04-22 11:04:38'),(496,511,NULL,2,5.0000,0.0000,'2025-04-22 11:15:45','2025-04-22 11:15:45'),(497,512,NULL,26,1.0000,0.0000,'2025-04-22 11:42:54','2025-04-22 11:42:54'),(498,513,NULL,26,3.0000,0.0000,'2025-04-22 12:06:10','2025-04-22 12:06:10'),(499,514,NULL,111,1.0000,0.0000,'2025-04-22 12:44:18','2025-04-22 12:44:18'),(500,515,NULL,122,2.0000,0.0000,'2025-04-22 12:44:18','2025-04-22 12:44:18'),(501,516,NULL,29,1.0000,0.0000,'2025-04-22 12:44:18','2025-04-22 12:44:18'),(502,517,NULL,69,1.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(503,518,NULL,254,2.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(504,519,NULL,279,1.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(505,520,NULL,87,1.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(506,521,NULL,28,1.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(507,522,NULL,34,6.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(508,523,NULL,252,1.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(509,524,NULL,244,6.0000,0.0000,'2025-04-22 12:44:19','2025-04-22 12:44:19'),(510,525,NULL,60,11.0000,0.0000,'2025-04-22 12:44:20','2025-04-22 12:44:20'),(511,526,NULL,126,5.0000,0.0000,'2025-04-22 13:36:52','2025-04-22 13:36:52'),(512,527,NULL,55,2.0000,0.0000,'2025-04-22 13:36:52','2025-04-22 13:36:52'),(513,528,NULL,48,1.0000,0.0000,'2025-04-22 13:36:52','2025-04-22 13:36:52'),(514,529,NULL,280,1.0000,0.0000,'2025-04-22 14:08:30','2025-04-22 14:08:30'),(515,530,NULL,278,1.0000,0.0000,'2025-04-22 14:08:30','2025-04-22 14:08:30'),(516,531,NULL,123,2.0000,0.0000,'2025-04-22 14:08:30','2025-04-22 14:08:30'),(517,532,NULL,279,1.0000,0.0000,'2025-04-22 14:08:30','2025-04-22 14:08:30'),(518,533,NULL,16,3.0000,0.0000,'2025-04-22 14:31:29','2025-04-22 14:31:29'),(519,534,NULL,81,1.0000,0.0000,'2025-04-22 14:48:59','2025-04-22 14:48:59'),(520,535,NULL,280,2.0000,0.0000,'2025-04-22 14:48:59','2025-04-22 14:48:59'),(521,536,NULL,55,2.0000,0.0000,'2025-04-22 14:48:59','2025-04-22 14:48:59'),(522,537,NULL,126,10.0000,0.0000,'2025-04-22 14:48:59','2025-04-22 14:48:59'),(523,538,NULL,306,5.0000,0.0000,'2025-04-22 14:48:59','2025-04-22 14:48:59'),(524,539,NULL,16,7.0000,0.0000,'2025-04-22 14:49:00','2025-04-22 14:49:00'),(525,540,NULL,45,40.0000,0.0000,'2025-04-22 15:27:57','2025-04-22 15:27:57'),(526,541,NULL,305,6.0000,0.0000,'2025-04-22 15:27:57','2025-04-22 15:27:57'),(527,542,NULL,93,10.0000,0.0000,'2025-04-22 15:27:57','2025-04-22 15:27:57'),(528,543,NULL,268,2.0000,0.0000,'2025-04-22 15:27:57','2025-04-22 15:27:57'),(529,544,NULL,40,5.0000,0.0000,'2025-04-22 15:27:58','2025-04-22 15:27:58'),(530,545,NULL,6,6.0000,0.0000,'2025-04-22 15:27:58','2025-04-22 15:27:58'),(531,546,NULL,280,1.0000,0.0000,'2025-04-22 15:43:01','2025-04-22 15:43:01'),(532,547,NULL,279,1.0000,0.0000,'2025-04-22 15:43:02','2025-04-22 15:43:02'),(533,548,NULL,93,1.0000,0.0000,'2025-04-22 15:43:02','2025-04-22 15:43:02'),(534,549,NULL,34,4.0000,0.0000,'2025-04-22 15:43:02','2025-04-22 15:43:02'),(535,550,NULL,273,2.0000,0.0000,'2025-04-22 16:02:20','2025-04-22 16:02:20'),(536,551,NULL,280,1.0000,0.0000,'2025-04-22 16:02:20','2025-04-22 16:02:20'),(537,552,NULL,279,1.0000,0.0000,'2025-04-22 16:02:20','2025-04-22 16:02:20'),(538,553,NULL,13,3.0000,0.0000,'2025-04-22 16:05:35','2025-04-22 16:05:35'),(539,554,NULL,126,30.0000,0.0000,'2025-04-23 09:43:38','2025-04-23 09:43:38'),(540,555,NULL,55,2.0000,0.0000,'2025-04-23 09:43:38','2025-04-23 09:43:38'),(541,556,NULL,279,2.0000,0.0000,'2025-04-23 09:43:38','2025-04-23 09:43:38'),(542,557,NULL,280,2.0000,0.0000,'2025-04-23 09:43:38','2025-04-23 09:43:38'),(543,558,NULL,278,1.0000,0.0000,'2025-04-23 09:43:38','2025-04-23 09:43:38'),(544,559,NULL,267,12.0000,0.0000,'2025-04-23 10:08:04','2025-04-23 10:08:04'),(545,560,NULL,111,2.0000,0.0000,'2025-04-23 11:25:53','2025-04-23 11:25:53'),(546,561,NULL,29,4.0000,0.0000,'2025-04-23 11:25:53','2025-04-23 11:25:53'),(547,562,NULL,39,12.0000,0.0000,'2025-04-23 11:25:53','2025-04-23 11:25:53'),(548,563,NULL,93,3.0000,0.0000,'2025-04-23 11:25:53','2025-04-23 11:25:53'),(549,564,NULL,247,100.0000,0.0000,'2025-04-23 11:25:53','2025-04-23 11:25:53'),(550,565,NULL,278,1.0000,0.0000,'2025-04-23 11:25:53','2025-04-23 11:25:53'),(551,566,NULL,253,4.0000,0.0000,'2025-04-23 11:25:54','2025-04-23 11:25:54'),(552,567,NULL,247,50.0000,0.0000,'2025-04-23 11:53:15','2025-04-23 11:53:15'),(553,568,NULL,274,1.0000,0.0000,'2025-04-23 11:58:24','2025-04-23 11:58:24'),(554,569,NULL,123,2.0000,0.0000,'2025-04-23 11:58:24','2025-04-23 11:58:24'),(555,570,NULL,279,1.0000,0.0000,'2025-04-23 11:58:24','2025-04-23 11:58:24'),(556,571,NULL,122,1.0000,0.0000,'2025-04-23 11:58:24','2025-04-23 11:58:24'),(557,572,NULL,245,4.0000,0.0000,'2025-04-23 11:58:24','2025-04-23 11:58:24'),(558,573,NULL,193,76.0000,0.0000,'2025-04-23 12:26:49','2025-04-23 12:26:49'),(559,574,NULL,190,142.0000,0.0000,'2025-04-23 12:26:49','2025-04-23 12:26:49'),(560,575,NULL,192,112.0000,0.0000,'2025-04-23 12:26:49','2025-04-23 12:26:49'),(561,576,NULL,166,100.0000,0.0000,'2025-04-23 12:26:49','2025-04-23 12:26:49'),(562,577,NULL,315,60.0000,0.0000,'2025-04-23 12:26:49','2025-04-23 12:26:49'),(563,578,NULL,147,50.0000,0.0000,'2025-04-23 12:26:49','2025-04-23 12:26:49');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `is_kitchen_order` tinyint(1) NOT NULL DEFAULT 0,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `sub_type` varchar(20) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `sub_status` varchar(191) DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT 0,
  `payment_status` enum('paid','due','partial') DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') DEFAULT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) DEFAULT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `source` varchar(191) DEFAULT NULL,
  `subscription_no` varchar(191) DEFAULT NULL,
  `subscription_repeat_on` varchar(191) DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `discount_type` enum('fixed','percentage') DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT 0.0000,
  `rp_redeemed` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `shipping_status` varchar(191) DEFAULT NULL,
  `delivered_to` varchar(191) DEFAULT NULL,
  `delivery_person` bigint(20) DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `shipping_custom_field_1` varchar(191) DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) DEFAULT NULL,
  `additional_notes` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_fields_info` longtext DEFAULT NULL,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_2` varchar(191) DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_3` varchar(191) DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_4` varchar(191) DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_sub_category_id` int(11) DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT 0,
  `is_suspend` tinyint(1) NOT NULL DEFAULT 0,
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `purchase_requisition_ids` text DEFAULT NULL,
  `prefer_payment_method` varchar(191) DEFAULT NULL,
  `prefer_payment_account` int(11) DEFAULT NULL,
  `sales_order_ids` text DEFAULT NULL,
  `purchase_order_ids` text DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `service_custom_field_1` text DEFAULT NULL,
  `service_custom_field_2` text DEFAULT NULL,
  `service_custom_field_3` text DEFAULT NULL,
  `service_custom_field_4` text DEFAULT NULL,
  `service_custom_field_5` text DEFAULT NULL,
  `service_custom_field_6` text DEFAULT NULL,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT 0,
  `rp_earned` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `order_addresses` text DEFAULT NULL,
  `is_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  KEY `transactions_status_index` (`status`),
  KEY `transactions_sub_status_index` (`sub_status`),
  KEY `transactions_res_table_id_index` (`res_table_id`),
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`),
  KEY `transactions_res_order_status_index` (`res_order_status`),
  KEY `transactions_payment_status_index` (`payment_status`),
  KEY `transactions_discount_type_index` (`discount_type`),
  KEY `transactions_commission_agent_index` (`commission_agent`),
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`),
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`),
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`),
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`),
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `transactions_delivery_date_index` (`delivery_date`),
  KEY `transactions_delivery_person_index` (`delivery_person`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=369 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',42000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,42000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 11:10:44'),(2,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',112000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,112000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 11:11:55'),(3,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',1008000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1008000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(4,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',840000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,840000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(5,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',28000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,28000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 11:10:09'),(6,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',187500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,187500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 15:26:56'),(7,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',825000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,825000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(8,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',825000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,825000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,8,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(9,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',294666.6100,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,294666.6100,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,9,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 09:55:42'),(10,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',173330.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,173330.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,10,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 11:11:25'),(11,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',259995.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,259995.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,11,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 11:47:09'),(12,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',86666.6650,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,86666.6650,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-23 10:02:33'),(13,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',242000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,242000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,13,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-22 16:07:05'),(14,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',143000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,143000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,14,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-21 13:11:29'),(15,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',1056000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1056000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,15,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(16,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',600600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,16,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(17,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',2024200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2024200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(18,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',1776000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1776000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,18,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(19,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',2880000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2880000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,19,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(20,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',67281.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,67281.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,20,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(21,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',64500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,64500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,21,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(22,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',266435.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,266435.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,22,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(23,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',108000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,108000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,23,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(24,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',256000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,256000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,24,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(25,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',771550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,771550.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,25,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(26,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',329000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,329000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,26,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(27,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',270558.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270558.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,27,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(28,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',3377400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3377400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,28,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(29,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',589410.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,589410.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,29,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(30,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',663600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,663600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,30,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(31,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:57',1209825.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1209825.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,31,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(32,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1802400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1802400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(33,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',433950.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,433950.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,33,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(34,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1214400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1214400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,34,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(35,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1528000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1528000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,36,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(36,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1530000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1530000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,37,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(37,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',393600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,393600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,38,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(38,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',192000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,192000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,39,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(39,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',11046000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11046000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,40,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(40,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1362192.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1362192.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,41,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(41,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',465500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,465500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,42,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(42,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1812600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1812600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,43,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(43,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',11278350.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11278350.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,44,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(44,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',2190960.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2190960.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,45,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(45,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',18000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,18000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,46,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(46,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',2660000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2660000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,47,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(47,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',938000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,938000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,48,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(48,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1324980.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1324980.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,49,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(49,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',216000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,216000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,50,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(50,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',3874000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3874000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,51,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(51,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',638000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,638000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,52,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(52,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',312000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,312000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,53,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(53,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',448000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,448000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,54,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(54,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',870000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,870000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,55,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(55,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',4342800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4342800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,56,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(56,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1632400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1632400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,57,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(57,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',2583360.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2583360.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,58,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-18 15:51:28'),(58,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1452500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1452500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,59,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(59,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',156000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,156000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,60,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(60,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',796000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,796000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,61,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(61,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',108000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,108000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,62,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(62,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',800000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,800000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,63,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(63,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1800000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,64,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(64,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',2750000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2750000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,65,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(65,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',182000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,182000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,66,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(66,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1300000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1300000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,67,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(67,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',877500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,877500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,68,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(68,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',343200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,343200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,69,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(69,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1758000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1758000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,70,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(70,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',826800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,826800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,71,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(71,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',3342800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3342800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,72,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(72,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',60000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,60000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,73,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(73,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',100000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,74,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(74,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',4747200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4747200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,75,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(75,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',111100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,111100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,76,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(76,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',567000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,567000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,77,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(77,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',620000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,620000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,78,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(78,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',44000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,44000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,79,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(79,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',656580.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,656580.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(80,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',74130.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,74130.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,81,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(81,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',2656500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2656500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,82,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(82,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',66000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,66000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,83,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(83,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',100000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,84,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(84,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',113400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,113400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,85,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(85,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',319200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,319200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,86,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(86,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',560000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,560000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,87,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(87,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',816400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,816400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,88,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(88,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',246000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,246000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,89,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(89,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',910000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,910000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,90,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(90,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:58',1120000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1120000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,91,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(91,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',1116000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1116000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,92,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(92,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',1227200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1227200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,93,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(93,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',2378340.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2378340.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,94,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(94,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',920000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,920000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,95,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(95,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',225000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,96,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-23 12:45:59'),(96,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',608000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,608000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,97,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(97,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',112000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,112000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,98,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(98,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',374000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,374000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,99,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(99,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',420000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,420000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,100,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(100,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',368000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,368000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,101,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(101,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',408000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,408000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,102,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(102,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',418000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,418000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,103,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(103,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',504000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,504000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,104,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(104,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',198000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,198000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,105,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(105,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',270000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,106,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(106,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',378000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,378000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,107,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(107,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',252000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,252000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,108,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(108,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',838200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,838200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,109,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(109,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',479600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,479600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,110,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(110,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',643200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,643200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,111,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(111,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,112,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(112,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',184000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,184000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,113,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(113,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',329640.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,329640.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,114,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(114,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',316800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,316800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,115,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(115,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',138600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,138600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,116,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(116,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',1825000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1825000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,117,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(117,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',255340.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,255340.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,118,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(118,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',264000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,264000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,119,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(119,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',786600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,786600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,120,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(120,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',344400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,344400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,121,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(121,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',825000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,825000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,122,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(122,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',4522000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4522000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,123,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(123,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',333000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,333000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,124,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(124,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',578000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,578000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,125,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(125,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',364800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,364800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,126,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(126,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',14210000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,14210000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,127,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(127,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:00',280000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,280000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,128,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-21 14:04:39'),(128,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',165000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,165000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,129,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(129,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',90000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,90000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,130,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(130,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',1320000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1320000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,131,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(131,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',720000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,720000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,132,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(132,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',108000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,108000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,133,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(133,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',30000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,30000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,134,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(134,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 14:15:59',884000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,884000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,135,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(135,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:20',21000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,21000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,136,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:20','2025-04-15 13:47:20'),(136,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',18316800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,18316800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,137,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:21','2025-04-17 13:24:00'),(137,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',7794000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,7794000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,138,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:22','2025-04-17 13:25:33'),(138,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',19296000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,19296000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,139,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:23','2025-04-17 13:24:45'),(139,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',14720000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,14720000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,140,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-17 13:26:57'),(140,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',13767000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,13767000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,141,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-17 13:27:47'),(141,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',25200000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25200000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,142,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-17 13:28:54'),(142,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2475000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2475000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,143,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-17 13:37:45'),(143,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1920000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1920000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,144,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-17 13:42:07'),(144,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',4480000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4480000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,145,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:24','2025-04-17 13:40:39'),(145,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',11000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,146,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:25','2025-04-17 13:44:46'),(146,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',6336000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6336000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,147,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:25','2025-04-17 13:46:32'),(147,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',76575000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,76575000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,148,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:25','2025-04-17 13:48:35'),(148,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',22500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,149,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:26','2025-04-17 13:51:33'),(149,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',18000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,18000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,150,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:26','2025-04-17 13:53:52'),(150,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',15810000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15810000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,151,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:27','2025-04-23 09:59:43'),(151,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',353599.3200,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,353599.3200,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,152,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:27','2025-04-23 10:00:24'),(152,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',15840000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15840000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,153,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:28','2025-04-17 14:07:09'),(153,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',5927886.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5927886.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,154,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:30','2025-04-23 10:47:40'),(154,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:31',997575.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,997575.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,155,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:31','2025-04-15 13:47:31'),(155,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:32',1074400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1074400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,156,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:32','2025-04-15 13:47:32'),(156,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',12960000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12960000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,157,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:33','2025-04-17 14:48:27'),(157,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',903000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,903000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,158,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:34','2025-04-17 14:52:05'),(158,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2925000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2925000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,159,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:34','2025-04-17 15:07:28'),(159,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',780000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,780000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,160,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:35','2025-04-17 15:08:45'),(160,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',16941600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,16941600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,161,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:35','2025-04-17 15:12:53'),(161,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',6000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,162,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:36','2025-04-17 15:17:18'),(162,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',6750000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6750000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,163,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:36','2025-04-17 15:18:47'),(163,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2022500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2022500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,164,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:37','2025-04-17 15:21:00'),(164,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',27636000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,27636000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,165,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:37','2025-04-17 15:23:29'),(165,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',25300000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25300000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,166,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:38','2025-04-17 15:25:12'),(166,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',15400000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15400000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,167,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:39','2025-04-17 15:26:32'),(167,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',612500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,612500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,168,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:39','2025-04-17 15:28:08'),(168,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',435000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,435000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,169,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:39','2025-04-17 15:29:36'),(169,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,170,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:40','2025-04-17 15:31:14'),(170,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2720000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2720000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,171,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:40','2025-04-17 16:24:21'),(171,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',124000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,124000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,172,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:41','2025-04-17 15:33:04'),(172,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1425600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1425600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,173,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:41','2025-04-17 15:33:57'),(173,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1296000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1296000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,174,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:43','2025-04-17 15:35:01'),(174,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',23000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,23000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,175,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:35:46'),(175,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',340272.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,340272.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,176,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:36:35'),(176,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',7452000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,7452000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,177,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:37:18'),(177,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1440000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1440000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,178,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:43:58'),(178,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',440000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,440000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,179,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:45:18'),(179,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',22032000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22032000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,180,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:47:08'),(180,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',16704000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,16704000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,181,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:48:51'),(181,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',9396000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,9396000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,182,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:44','2025-04-17 15:49:45'),(182,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',547200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,547200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 15:50:40'),(183,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',600000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,184,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 15:51:18'),(184,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1296000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1296000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 15:52:27'),(185,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2106000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2106000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,186,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 16:01:42'),(186,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',3672000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3672000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,187,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:45','2025-04-17 16:03:08'),(187,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',3945600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3945600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,188,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:46','2025-04-17 16:04:07'),(188,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2851200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2851200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,189,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:46','2025-04-17 16:04:51'),(189,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1623500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1623500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:46','2025-04-17 16:05:41'),(190,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',2256000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2256000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,191,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:47','2025-04-17 16:06:14'),(191,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',1340000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1340000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,192,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:47','2025-04-17 16:06:50'),(192,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',5041200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5041200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:48','2025-04-22 12:10:52'),(193,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',3016320.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3016320.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:48','2025-04-17 16:08:41'),(194,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',51840000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,51840000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,195,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:49','2025-04-17 16:10:25'),(195,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',11668800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11668800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,196,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:49','2025-04-17 16:11:02'),(196,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',5600000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5600000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:50','2025-04-17 16:11:40'),(197,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',8338500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,8338500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,198,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:50','2025-04-17 16:12:21'),(198,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',22080000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22080000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,199,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:50','2025-04-18 14:10:18'),(199,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',3388000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3388000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,200,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:51','2025-04-17 16:14:37'),(200,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',9120000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,9120000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,201,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:51','2025-04-17 16:15:32'),(201,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',10540000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10540000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,202,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:51','2025-04-18 11:12:48'),(202,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',10800000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10800000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,203,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:52','2025-04-17 16:16:14'),(203,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 15:47:00',5940000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5940000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,204,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 13:47:52','2025-04-17 16:16:59'),(204,1,2,0,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'SA2025/0001',NULL,NULL,NULL,'2025-04-15 18:40:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,7725000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-15 16:42:36','2025-04-15 16:42:36'),(207,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0001',NULL,NULL,NULL,'2025-04-17 08:56:00',31800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'23 Bellos From Store to Shop',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,31800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 07:00:33','2025-04-17 07:00:33'),(208,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0001',NULL,NULL,NULL,'2025-04-17 08:56:00',31800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'23 Bellos From Store to Shop',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,31800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,207,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 07:00:33','2025-04-17 07:00:33'),(209,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0001','',NULL,NULL,NULL,'2025-03-18 09:59:00',888000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,888000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'88a71f3614f818eeab035fe30c8f0d1c',NULL,NULL,NULL,'2025-04-17 08:14:15','2025-04-17 08:14:18'),(210,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0002','',NULL,NULL,NULL,'2025-03-18 09:59:00',888000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,888000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 08:16:53','2025-04-17 08:16:54'),(211,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0003','',NULL,NULL,NULL,'2025-03-18 10:34:00',100000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 08:38:24','2025-04-17 08:38:25'),(212,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0004','',NULL,NULL,NULL,'2025-03-18 10:39:00',720000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,720000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 08:50:14','2025-04-17 08:50:15'),(213,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0005','',NULL,NULL,NULL,'2025-03-18 10:51:00',1140000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1140000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 08:53:07','2025-04-17 08:53:08'),(214,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0006','',NULL,NULL,NULL,'2025-03-18 10:54:00',170000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,170000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 08:56:29','2025-04-17 08:56:30'),(215,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0007','',NULL,NULL,NULL,'2025-03-18 10:56:00',1750000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1750000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 09:09:12','2025-04-17 09:09:13'),(216,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0008','',NULL,NULL,NULL,'2025-03-18 11:09:00',3978000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3978000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 09:22:09','2025-04-17 09:22:09'),(217,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0009','',NULL,NULL,NULL,'2025-03-18 11:24:00',45000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,45000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 09:34:12','2025-04-17 09:34:13'),(218,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0010','',NULL,NULL,NULL,'2025-03-18 11:41:00',4800000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4800000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 09:43:42','2025-04-17 09:43:54'),(219,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0011','',NULL,NULL,NULL,'2025-03-18 11:44:00',690000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,690000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 09:51:34','2025-04-17 09:51:36'),(220,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0012','',NULL,NULL,NULL,'2025-03-18 11:52:00',8252500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,8252500.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 10:30:38','2025-04-17 10:30:40'),(221,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0013','',NULL,NULL,NULL,'2025-03-18 12:36:00',77000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,77000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 10:41:39','2025-04-17 10:41:41'),(222,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0014','',NULL,NULL,NULL,'2025-03-18 12:42:00',530000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,530000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 10:51:14','2025-04-17 10:51:21'),(223,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0015','',NULL,NULL,NULL,'2025-03-18 13:10:00',120000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,120000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 11:15:39','2025-04-17 11:15:42'),(224,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0016','',NULL,NULL,NULL,'2025-03-18 13:16:00',10967000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10967000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 12:20:17','2025-04-17 12:20:23'),(226,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 16:22:00',12690000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12690000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,205,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-17 14:22:19','2025-04-17 14:36:46'),(227,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:18:00',100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,207,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 08:19:06','2025-04-18 08:19:06'),(228,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0001',NULL,NULL,NULL,'2025-04-18 10:24:00',21000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,21000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-18 08:48:35','2025-04-18 08:48:35'),(229,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0002',NULL,NULL,NULL,'2025-03-18 10:52:00',731400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,731400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 08:53:58','2025-04-18 08:53:58'),(230,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0002',NULL,NULL,NULL,'2025-03-18 10:52:00',731400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,731400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,229,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 08:53:58','2025-04-18 08:53:58'),(231,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0003',NULL,NULL,NULL,'2025-03-18 10:54:00',2800000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2800000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:05:35','2025-04-18 09:05:35'),(232,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0003',NULL,NULL,NULL,'2025-03-18 10:54:00',2800000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2800000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,231,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:05:36','2025-04-18 09:05:36'),(233,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0004',NULL,NULL,NULL,'2025-03-18 11:08:00',17553600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,17553600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:10:14','2025-04-18 09:10:14'),(234,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0004',NULL,NULL,NULL,'2025-03-18 11:08:00',17553600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,17553600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,233,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:10:14','2025-04-18 09:10:14'),(235,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0005',NULL,NULL,NULL,'2025-03-18 11:10:00',25783500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25783500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:25:24','2025-04-18 09:25:24'),(236,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0005',NULL,NULL,NULL,'2025-03-18 11:10:00',25783500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25783500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,235,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:25:24','2025-04-18 09:25:24'),(237,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0006',NULL,NULL,NULL,'2025-03-18 11:25:00',6480000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6480000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:30:49','2025-04-18 09:30:49'),(238,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0006',NULL,NULL,NULL,'2025-03-18 11:25:00',6480000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6480000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,237,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:30:49','2025-04-18 09:30:49'),(239,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 11:37:40',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,208,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:37:40','2025-04-18 09:37:40'),(240,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0002',NULL,NULL,NULL,'2025-04-18 11:39:00',8595200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,8595200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:44:03','2025-04-18 09:44:03'),(241,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0007',NULL,NULL,NULL,'2025-03-18 11:30:00',3539200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3539200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:46:11','2025-04-18 09:46:11'),(242,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0007',NULL,NULL,NULL,'2025-03-18 11:30:00',3539200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3539200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,241,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:46:11','2025-04-18 09:46:11'),(243,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0008',NULL,NULL,NULL,'2025-03-18 11:46:00',1280000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1280000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:48:45','2025-04-18 09:48:45'),(244,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0008',NULL,NULL,NULL,'2025-03-18 11:46:00',1280000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1280000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,243,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 09:48:45','2025-04-18 09:48:45'),(245,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0009',NULL,NULL,NULL,'2025-03-18 12:00:00',53160000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,53160000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:04:10','2025-04-18 10:04:10'),(246,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0009',NULL,NULL,NULL,'2025-03-18 12:00:00',53160000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,53160000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,245,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:04:10','2025-04-18 10:04:10'),(247,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0010',NULL,NULL,NULL,'2025-04-16 12:04:00',4758000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4758000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(248,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0010',NULL,NULL,NULL,'2025-04-16 12:04:00',4758000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4758000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,247,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:12:44','2025-04-18 10:12:44'),(249,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0011',NULL,NULL,NULL,'2025-03-18 12:14:00',23673000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,23673000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(250,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0011',NULL,NULL,NULL,'2025-03-18 12:14:00',23673000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,23673000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,249,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:35:45','2025-04-18 10:35:45'),(251,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0012',NULL,NULL,NULL,'2025-03-18 12:36:00',10281000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10281000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:43:55','2025-04-18 10:43:55'),(252,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0012',NULL,NULL,NULL,'2025-03-18 12:36:00',10281000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10281000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,251,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 10:43:55','2025-04-18 10:43:55'),(253,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0013',NULL,NULL,NULL,'2025-04-16 13:22:00',720000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,720000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 11:24:24','2025-04-18 11:24:24'),(254,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0013',NULL,NULL,NULL,'2025-04-16 13:22:00',720000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,720000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,253,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 11:24:24','2025-04-18 11:24:24'),(255,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0014',NULL,NULL,NULL,'2025-03-18 12:50:00',33136000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,33136000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 11:25:12','2025-04-18 11:25:12'),(256,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0014',NULL,NULL,NULL,'2025-03-18 12:50:00',33136000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,33136000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,255,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 11:25:13','2025-04-18 11:25:13'),(257,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0015',NULL,NULL,NULL,'2025-03-18 13:25:00',52040181.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,52040181.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(258,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0015',NULL,NULL,NULL,'2025-03-18 13:25:00',52040181.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,52040181.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,257,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 11:56:25','2025-04-18 11:56:25'),(259,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0016',NULL,NULL,NULL,'2025-04-17 13:57:00',3178000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3178000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(260,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0016',NULL,NULL,NULL,'2025-04-17 13:57:00',3178000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3178000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,259,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 12:00:36','2025-04-18 12:00:36'),(261,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0017',NULL,NULL,NULL,'2025-04-17 13:57:00',3178000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3178000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 12:01:25','2025-04-18 12:01:25'),(262,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0017',NULL,NULL,NULL,'2025-04-17 13:57:00',3178000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3178000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,261,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 12:01:26','2025-04-18 12:01:26'),(263,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0018',NULL,NULL,NULL,'2025-04-17 14:48:00',1696000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1696000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 12:55:10','2025-04-18 12:55:10'),(264,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0018',NULL,NULL,NULL,'2025-04-17 14:48:00',1696000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1696000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,263,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 12:55:11','2025-04-18 12:55:11'),(265,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0003',NULL,NULL,NULL,'2025-04-18 15:09:00',825000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,825000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-18 13:18:37','2025-04-18 13:18:37'),(266,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0004',NULL,NULL,NULL,'2025-04-18 15:19:00',61200000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,61200000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-18 13:27:29','2025-04-18 13:27:29'),(267,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0019',NULL,NULL,NULL,'2025-04-17 15:28:00',330000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,330000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:31:13','2025-04-18 13:31:13'),(268,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0019',NULL,NULL,NULL,'2025-04-17 15:28:00',330000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,330000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,267,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:31:13','2025-04-18 13:31:13'),(269,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0020',NULL,NULL,NULL,'2025-04-17 15:32:00',1200000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1200000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:34:46','2025-04-18 13:34:46'),(270,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0020',NULL,NULL,NULL,'2025-04-17 15:32:00',1200000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1200000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,269,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:34:46','2025-04-18 13:34:46'),(271,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0021',NULL,NULL,NULL,'2025-03-18 15:37:00',1100000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:41:38','2025-04-18 13:41:38'),(272,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0021',NULL,NULL,NULL,'2025-03-18 15:37:00',1100000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,271,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:41:38','2025-04-18 13:41:38'),(273,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0022',NULL,NULL,NULL,'2025-03-18 15:42:00',1053000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1053000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:44:13','2025-04-18 13:44:13'),(274,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0022',NULL,NULL,NULL,'2025-03-18 15:42:00',1053000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1053000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,273,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:44:13','2025-04-18 13:44:13'),(275,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0023',NULL,NULL,NULL,'2025-03-18 15:46:00',38970.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,38970.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:49:17','2025-04-18 13:49:17'),(276,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0023',NULL,NULL,NULL,'2025-03-18 15:46:00',38970.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,38970.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,275,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 13:49:17','2025-04-18 13:49:17'),(277,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0024',NULL,NULL,NULL,'2025-03-18 16:03:00',1392000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1392000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 14:05:31','2025-04-18 14:05:31'),(278,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0024',NULL,NULL,NULL,'2025-03-18 16:03:00',1392000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1392000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,277,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 14:05:31','2025-04-18 14:05:31'),(279,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0025',NULL,NULL,NULL,'2025-03-17 16:17:00',11270000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11270000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 14:19:08','2025-04-18 14:19:08'),(280,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0025',NULL,NULL,NULL,'2025-03-17 16:17:00',11270000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11270000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,279,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 14:19:08','2025-04-18 14:19:08'),(281,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0017','',NULL,NULL,NULL,'2025-04-17 16:59:00',23038000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,23038000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 15:10:01','2025-04-18 15:10:02'),(282,2,3,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 21:47:04',12000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2400000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,211,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 19:47:04','2025-04-18 19:47:04'),(283,2,3,0,NULL,NULL,NULL,'sell',NULL,'draft','proforma',0,NULL,NULL,5,NULL,'2025/0001','',NULL,NULL,NULL,'2025-04-18 21:47:00',15000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,'shipped','the client: Juma kalimbalize',4,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,'mafuta ya Boda0',5000.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,20000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'150a918cec4d4331e6cf90bd6c5670ff',NULL,NULL,NULL,'2025-04-18 19:48:29','2025-04-18 19:48:29'),(284,2,3,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,5,NULL,'2025/0002','',NULL,NULL,NULL,'2025-04-18 21:50:00',30000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,30000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 19:51:12','2025-04-18 19:57:36'),(285,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0018','',NULL,NULL,NULL,'2025-04-17 09:38:00',4104000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4104000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 07:39:46','2025-04-19 07:39:47'),(286,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0019','',NULL,NULL,NULL,'2025-04-17 09:40:00',4287000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4287000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 07:46:35','2025-04-19 07:46:36'),(287,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0020','',NULL,NULL,NULL,'2025-03-19 09:51:00',17945100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,17945100.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 10:10:44','2025-04-19 10:10:47'),(288,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0026',NULL,NULL,NULL,'2025-03-18 12:57:00',550000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'METRE',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,550000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:13:24','2025-04-19 11:13:24'),(289,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0026',NULL,NULL,NULL,'2025-03-18 12:57:00',550000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'METRE',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,550000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,288,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:13:24','2025-04-19 11:13:24'),(290,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0027',NULL,NULL,NULL,'2025-03-18 13:15:00',5656000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5656000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:27:33','2025-04-19 11:27:33'),(291,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0027',NULL,NULL,NULL,'2025-03-18 13:15:00',5656000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5656000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,290,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:27:35','2025-04-19 11:27:35'),(292,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0028',NULL,NULL,NULL,'2025-03-18 13:30:00',541800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,541800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:36:28','2025-04-19 11:36:28'),(293,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0028',NULL,NULL,NULL,'2025-03-18 13:30:00',541800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,541800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,292,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:36:28','2025-04-19 11:36:28'),(294,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0029',NULL,NULL,NULL,'2025-03-18 13:37:00',22500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:41:05','2025-04-19 11:41:05'),(295,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0029',NULL,NULL,NULL,'2025-03-18 13:37:00',22500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,294,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 11:41:05','2025-04-19 11:41:05'),(296,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0021','',NULL,NULL,NULL,'2025-03-18 13:45:00',65721250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,65721250.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 13:23:54','2025-04-19 13:23:57'),(297,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0005',NULL,NULL,NULL,'2025-04-19 15:38:00',26600000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,26600000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-19 13:43:29','2025-04-19 13:43:29'),(298,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0030',NULL,NULL,NULL,'2025-03-18 15:44:00',9500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,9500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 13:46:20','2025-04-19 13:46:20'),(299,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0030',NULL,NULL,NULL,'2025-03-18 15:44:00',9500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,9500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,298,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 13:46:20','2025-04-19 13:46:20'),(300,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0022','',NULL,NULL,NULL,'2025-03-18 16:20:00',700000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 14:50:17','2025-04-19 14:50:18'),(301,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0023','',NULL,NULL,NULL,'2025-03-18 16:52:00',10000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 14:54:06','2025-04-19 14:54:06'),(302,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0024','',NULL,NULL,NULL,'2025-04-18 16:54:00',2964000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2964000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 15:11:22','2025-04-19 15:11:24'),(303,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0025','',NULL,NULL,NULL,'2025-03-25 17:12:00',672000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,672000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 15:16:05','2025-04-23 10:28:04'),(304,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,6,NULL,NULL,'PO2025/0006',NULL,NULL,NULL,'2025-04-19 17:25:00',90000000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,90000000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-19 15:35:14','2025-04-19 15:35:14'),(305,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0031',NULL,NULL,NULL,'2025-04-19 17:38:00',15254710.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15254710.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(306,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0031',NULL,NULL,NULL,'2025-04-19 17:38:00',15254710.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15254710.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,305,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-19 15:49:17','2025-04-19 15:49:17'),(307,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0026','',NULL,NULL,NULL,'2025-04-18 18:54:00',1780000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1780000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 18:31:49','2025-04-20 18:31:58'),(308,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0027','',NULL,NULL,NULL,'2025-04-18 20:52:00',817500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,817500.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 19:36:49','2025-04-20 19:37:12'),(309,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0028','',NULL,NULL,NULL,'2025-04-18 21:37:00',282000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,282000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 19:51:16','2025-04-20 19:51:28'),(310,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0029','',NULL,NULL,NULL,'2025-04-19 21:51:00',2153000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2153000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 20:46:41','2025-04-20 20:46:48'),(311,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0030','',NULL,NULL,NULL,'2025-03-18 09:30:00',2288000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2288000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 07:56:03','2025-04-21 07:56:03'),(312,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0032',NULL,NULL,NULL,'2025-04-18 10:05:00',288000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,288000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 08:17:08','2025-04-21 08:17:08'),(313,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0032',NULL,NULL,NULL,'2025-04-18 10:05:00',288000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,288000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,312,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 08:17:08','2025-04-21 08:17:08'),(314,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0031','',NULL,NULL,NULL,'2025-04-21 10:17:00',224000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,224000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 08:44:09','2025-04-21 08:44:09'),(315,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0032','',NULL,NULL,NULL,'2025-04-21 10:57:00',86000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,86000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 09:03:05','2025-04-21 09:03:06'),(316,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0007',NULL,NULL,NULL,'2025-04-21 11:07:00',2700000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2700000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-21 09:10:09','2025-04-21 09:10:09'),(317,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0033',NULL,NULL,NULL,'2025-04-18 11:10:00',225000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 09:20:50','2025-04-21 09:20:50'),(318,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0033',NULL,NULL,NULL,'2025-04-18 11:10:00',225000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,317,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 09:20:50','2025-04-21 09:20:50'),(319,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0033','',NULL,NULL,NULL,'2025-04-21 11:16:00',90000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,90000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2025-04-21 09:30:33','2025-04-21 09:30:34'),(320,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0034','',NULL,NULL,NULL,'2025-04-21 12:53:00',328000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,328000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 11:18:04','2025-04-21 11:18:05'),(321,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0035','',NULL,NULL,NULL,'2025-04-21 13:21:00',40000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,40000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 11:25:28','2025-04-21 11:25:38'),(322,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0036','',NULL,NULL,NULL,'2025-04-21 13:49:00',111000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,111000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 12:16:15','2025-04-21 12:16:16'),(323,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0037','',NULL,NULL,NULL,'2025-04-21 14:57:00',54000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,54000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 13:13:00','2025-04-21 13:13:00'),(324,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0038','',NULL,NULL,NULL,'2025-04-21 15:32:00',280900.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,280900.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 13:51:01','2025-04-21 13:51:05'),(325,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0039','',NULL,NULL,NULL,'2025-04-21 16:11:00',276500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,276500.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 14:17:32','2025-04-21 14:17:40'),(326,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0034',NULL,NULL,NULL,'2025-04-21 16:23:00',6639800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6639800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 14:42:54','2025-04-21 14:42:54'),(327,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0034',NULL,NULL,NULL,'2025-04-21 16:23:00',6639800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6639800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,326,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 14:42:54','2025-04-21 14:42:54'),(328,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0040','',NULL,NULL,NULL,'2025-04-18 17:17:00',35000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,35000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 15:17:56','2025-04-21 15:17:57'),(329,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0041','',NULL,NULL,NULL,'2025-04-19 17:21:00',85000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,85000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 15:26:38','2025-04-21 15:26:38'),(330,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0042','',NULL,NULL,NULL,'2025-04-21 18:56:00',495000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,495000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 17:27:37','2025-04-21 17:27:38'),(331,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0043','',NULL,NULL,NULL,'2025-04-21 19:29:00',26000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,26000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 17:30:54','2025-04-21 17:30:55'),(332,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0001',NULL,NULL,NULL,'2025-04-21 19:33:00',14000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'2,000 × 7 employees',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,14000.0000,1,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 17:39:36','2025-04-21 17:39:36'),(333,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0002',NULL,NULL,NULL,'2025-04-21 19:40:00',30000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,30000.0000,2,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-21 17:41:29','2025-04-21 17:41:30'),(334,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0044','',NULL,NULL,NULL,'2025-04-13 09:05:00',63773000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,63773000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 08:42:45','2025-04-22 08:43:04'),(335,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0045','',NULL,NULL,NULL,'2025-04-22 10:52:00',115000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,115000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 09:06:20','2025-04-22 09:06:23'),(336,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0003',NULL,NULL,NULL,'2025-04-21 11:23:00',150000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'RENT PER DAY',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150000.0000,3,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 09:26:33','2025-04-22 11:18:01'),(337,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0004',NULL,NULL,NULL,'2025-04-21 11:27:00',1600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1600.0000,4,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 09:28:20','2025-04-22 11:17:42'),(338,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0005',NULL,NULL,NULL,'2025-04-21 11:29:00',80000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,80000.0000,6,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 09:30:13','2025-04-22 11:17:19'),(339,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0006',NULL,NULL,NULL,'2025-04-21 11:31:00',1700.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1700.0000,7,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 09:32:48','2025-04-22 09:32:48'),(340,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0046','',NULL,NULL,NULL,'2025-04-22 12:17:00',538000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,538000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 10:21:26','2025-04-22 10:21:28'),(341,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0047','',NULL,NULL,NULL,'2025-04-22 12:51:00',556000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,556000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 11:04:36','2025-04-22 11:04:37'),(342,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0048','',NULL,NULL,NULL,'2025-04-22 13:14:00',45000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,45000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 11:15:45','2025-04-22 11:15:45'),(343,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0049','',NULL,NULL,NULL,'2025-04-19 13:42:00',60000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,60000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 11:42:53','2025-04-22 11:43:45'),(344,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0050','',NULL,NULL,NULL,'2025-04-18 13:54:00',180000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,180000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 12:06:09','2025-04-22 12:06:10'),(345,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0051','',NULL,NULL,NULL,'2025-04-22 14:27:00',355500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,355500.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 12:44:16','2025-04-22 12:44:18'),(346,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0007',NULL,NULL,NULL,'2025-04-22 14:52:00',14000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,14000.0000,1,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 12:55:36','2025-04-22 12:55:36'),(347,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0008',NULL,NULL,NULL,'2025-04-22 15:03:00',30000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,30000.0000,2,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:04:43','2025-04-22 13:04:43'),(348,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0009',NULL,NULL,NULL,'2025-04-22 15:04:00',150000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150000.0000,3,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:06:25','2025-04-22 13:06:26'),(349,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0010',NULL,NULL,NULL,'2025-04-22 15:08:00',1600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1600.0000,4,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:10:01','2025-04-22 13:10:02'),(350,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0011',NULL,NULL,NULL,'2025-04-22 15:10:00',1000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1000.0000,5,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:15:10','2025-04-22 13:15:10'),(351,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0012',NULL,NULL,NULL,'2025-04-22 15:15:00',80000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,80000.0000,6,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:19:35','2025-04-22 13:19:36'),(352,1,1,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'EP2025/0013',NULL,NULL,NULL,'2025-04-22 15:20:00',1700.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1700.0000,7,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:20:53','2025-04-22 13:20:58'),(353,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0052','',NULL,NULL,NULL,'2025-04-22 15:31:00',335000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,335000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 13:36:51','2025-04-22 13:36:51'),(354,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0053','',NULL,NULL,NULL,'2025-04-22 16:00:00',111000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,111000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 14:08:29','2025-04-22 14:08:29'),(355,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0054','',NULL,NULL,NULL,'2025-04-22 16:25:00',10500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10500.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 14:31:19','2025-04-22 14:31:26'),(356,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0055','',NULL,NULL,NULL,'2025-04-22 16:42:00',580500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,580500.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 14:48:57','2025-04-22 14:48:58'),(357,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0056','',NULL,NULL,NULL,'2025-04-22 16:56:00',2201002.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2201000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:27:51','2025-04-22 15:30:53'),(358,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0057','',NULL,NULL,NULL,'2025-04-22 17:38:00',83000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,83000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 15:42:48','2025-04-22 15:43:00'),(359,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0058','',NULL,NULL,NULL,'2025-04-22 17:58:00',158000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,158000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 16:02:19','2025-04-22 16:02:20'),(360,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0059','',NULL,NULL,NULL,'2025-04-22 18:04:00',45000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,45000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-22 16:05:33','2025-04-22 16:05:34'),(361,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0060','',NULL,NULL,NULL,'2025-04-23 11:37:00',816000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,816000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 09:43:32','2025-04-23 09:43:37'),(362,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0061','',NULL,NULL,NULL,'2025-04-23 11:44:00',309996.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,310000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 10:08:02','2025-04-23 10:08:04'),(363,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0062','',NULL,NULL,NULL,'2025-04-23 13:11:00',741000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,741000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 11:25:51','2025-04-23 11:25:53'),(364,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0063','',NULL,NULL,NULL,'2025-04-23 13:51:00',90000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,90000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 11:53:14','2025-04-23 11:53:15'),(365,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'2025-0064','',NULL,NULL,NULL,'2025-04-23 13:53:00',155000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,155000.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 11:58:22','2025-04-23 11:58:24'),(366,1,2,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0035',NULL,NULL,NULL,'2025-04-23 14:13:00',11736008.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11736008.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 12:26:45','2025-04-23 12:26:45'),(367,1,1,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2025/0035',NULL,NULL,NULL,'2025-04-23 14:13:00',11736008.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,11736008.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,366,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-23 12:26:46','2025-04-23 12:26:46'),(368,1,2,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,3,NULL,NULL,'PO2025/0008',NULL,NULL,NULL,'2025-04-01 15:02:00',1500000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'days',NULL,'2025-04-23 13:11:31','2025-04-23 13:11:31');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `types_of_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `location_price_group` text DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) NOT NULL,
  `short_name` varchar(191) NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pc(s)',0,NULL,NULL,2,NULL,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(2,1,'Bello','Bello',0,NULL,NULL,1,NULL,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(3,1,'Box','Box',0,NULL,NULL,1,NULL,'2025-04-15 12:40:23','2025-04-15 12:40:23'),(4,1,'Carton5','Carton',0,1,5.0000,1,NULL,'2025-04-15 12:40:23','2025-04-17 08:45:31'),(5,1,'Set','Set',0,1,NULL,1,NULL,'2025-04-15 16:58:18','2025-04-15 16:58:18'),(6,1,'Rolls','Rolls',0,1,NULL,1,NULL,'2025-04-15 17:03:51','2025-04-15 17:03:51'),(7,1,'Bello23','Bello23',0,1,23.0000,1,NULL,'2025-04-17 08:42:51','2025-04-17 08:45:43'),(8,1,'CTN41','CTN41',0,1,41.0000,1,NULL,'2025-04-17 08:45:14','2025-04-17 08:45:14'),(9,1,'bello13','bello13',0,1,13.0000,2,NULL,'2025-04-17 08:55:37','2025-04-17 08:55:37'),(10,1,'CTN 9','CTN 9',1,1,9.0000,1,NULL,'2025-04-17 08:56:59','2025-04-17 08:56:59'),(11,1,'CTN 12','CTN 12',1,1,12.0000,2,NULL,'2025-04-17 08:58:26','2025-04-17 08:58:26'),(12,1,'CTN 8','CTN 8',1,1,8.0000,2,NULL,'2025-04-17 08:59:21','2025-04-17 08:59:21'),(13,1,'ROLLS 20','ROLLS 20',1,1,20.0000,2,NULL,'2025-04-17 09:02:31','2025-04-17 09:02:31'),(14,1,'CTN 22','CTN 22',1,1,22.0000,2,NULL,'2025-04-17 09:03:49','2025-04-17 09:03:49'),(15,1,'CTN 155','CTN 155',1,NULL,155.0000,2,NULL,'2025-04-17 09:05:12','2025-04-17 09:05:12'),(16,1,'CTN 50','CTN 50',1,1,50.0000,2,NULL,'2025-04-17 09:05:56','2025-04-17 09:05:56'),(17,1,'CTN 40','CTN 40',1,1,40.0000,2,NULL,'2025-04-17 09:06:40','2025-04-17 09:06:40'),(18,1,'CTN 34','CTN 34',1,1,34.0000,2,NULL,'2025-04-17 09:08:48','2025-04-17 09:08:48'),(19,1,'CTN 10','CTN 10',1,1,10.0000,2,NULL,'2025-04-17 09:12:43','2025-04-17 09:12:43'),(20,1,'CTN 57','CTN 57',1,1,57.0000,2,NULL,'2025-04-17 09:13:30','2025-04-17 09:13:30'),(21,1,'BOX 47','BOX 47',1,1,47.0000,2,NULL,'2025-04-17 09:14:37','2025-04-17 09:14:37'),(22,1,'BOX 34','BOX 34',1,1,34.0000,2,NULL,'2025-04-17 09:15:18','2025-04-17 09:15:18'),(23,1,'BOX 18','BOX 18',1,1,18.0000,2,NULL,'2025-04-17 09:15:59','2025-04-17 09:15:59'),(24,1,'BOX 5','BOX 5',1,1,5.0000,2,NULL,'2025-04-17 09:16:35','2025-04-17 09:16:35'),(25,1,'BELLO 3','BELLO 3',1,1,3.0000,2,NULL,'2025-04-17 09:17:55','2025-04-17 09:17:55'),(26,2,'Pieces','Pc(s)',0,NULL,NULL,4,NULL,'2025-04-18 16:44:05','2025-04-18 16:44:05');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_contact_access_user_id_index` (`user_id`),
  KEY `user_contact_access_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) NOT NULL DEFAULT 'user',
  `surname` char(10) DEFAULT NULL,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `password` varchar(191) DEFAULT NULL,
  `language` char(7) NOT NULL DEFAULT 'en',
  `contact_no` char(15) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `available_at` datetime DEFAULT NULL COMMENT 'Service staff avilable at. Calculated from product preparation_time_in_minutes',
  `paused_at` datetime DEFAULT NULL COMMENT 'Service staff available time paused at, Will be nulled on resume.',
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT 1,
  `status` enum('active','inactive','terminated') NOT NULL DEFAULT 'active',
  `is_enable_service_staff_pin` tinyint(1) NOT NULL DEFAULT 0,
  `service_staff_pin` text DEFAULT NULL,
  `crm_contact_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT 0,
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT 0.00,
  `selected_contacts` tinyint(1) NOT NULL DEFAULT 0,
  `dob` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') DEFAULT NULL,
  `blood_group` char(10) DEFAULT NULL,
  `contact_number` char(20) DEFAULT NULL,
  `alt_number` varchar(191) DEFAULT NULL,
  `family_number` varchar(191) DEFAULT NULL,
  `fb_link` varchar(191) DEFAULT NULL,
  `twitter_link` varchar(191) DEFAULT NULL,
  `social_media_1` varchar(191) DEFAULT NULL,
  `social_media_2` varchar(191) DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `guardian_name` varchar(191) DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `bank_details` longtext DEFAULT NULL,
  `id_proof_name` varchar(191) DEFAULT NULL,
  `id_proof_number` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  KEY `users_crm_contact_id_foreign` (`crm_contact_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_crm_contact_id_foreign` FOREIGN KEY (`crm_contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'user','Mr','Epimark','Massawe','epimark','epimackmassaweg8@gmail.com','$2y$10$zPsY/JbptElxj6sICOz3/et5I7P7AWuGWtEkThI27S6WB3fQsaxlS','en',NULL,NULL,NULL,1,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,'male',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2025-04-15 12:40:23','2025-04-15 17:52:14'),(2,'user','Mr','Nelson','Mboya','nelsonm','nelson.jmboya@gmail.com','$2y$10$4onx6OMvW/2rCVPGy3.F1uV28K7iLllV0y1gLeLsNDYnqo0sHZU4W','en',NULL,NULL,NULL,1,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,'1990-03-07','male','married',NULL,'0652543553',NULL,NULL,NULL,NULL,NULL,NULL,'Makongo Juu, Dar es salaam',NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2025-04-15 10:20:33','2025-04-15 10:20:33'),(3,'user','Mr','Muzamil','Iddy','Muzamil','muzahiddy@gmail.com','$2y$10$0s7jt98T1ncadnFxVR6TPeMleVJa9mlA4fL3AU08CECiTwhBkdwGe','en',NULL,NULL,'Kfc9y11jLO9RyrzpqI0l3XrKGWUM9ycUydr7IB2CMT6hqPSgImYdyZVuFGk0',1,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2025-04-16 16:11:58','2025-04-16 16:11:58'),(4,'user','Mr','Nelson','Mboya','neliemboya','neliemboya@hotmail.com','$2y$10$m4sx3FKpyTxuaUBbCiME7ebP1UXbUxkgepz28nPfst/1rWi5SLM0W','en',NULL,NULL,NULL,2,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 16:44:03','2025-04-18 16:44:03');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `price_type` varchar(191) NOT NULL DEFAULT 'fixed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=290 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,1,1,1,1,6.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(2,2,2,2,1,11.0000,'2025-04-15 11:15:57','2025-04-22 11:15:45'),(3,3,3,3,1,7.0000,'2025-04-15 11:15:57','2025-04-20 18:31:56'),(4,4,4,4,1,10.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(5,5,5,5,1,4.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(6,6,6,6,1,8.0000,'2025-04-15 11:15:57','2025-04-22 15:27:56'),(7,7,7,7,1,11.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(8,8,8,8,1,11.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(9,9,9,9,1,17.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(10,10,10,10,1,10.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(11,11,11,11,1,13.0000,'2025-04-15 11:15:57','2025-04-20 18:31:55'),(12,12,12,12,1,5.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(13,13,13,13,1,0.0000,'2025-04-15 11:15:57','2025-04-22 16:05:34'),(14,14,14,14,1,10.0000,'2025-04-15 11:15:57','2025-04-21 13:13:00'),(15,15,15,15,1,8.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(16,16,16,16,1,432.0000,'2025-04-15 11:15:57','2025-04-22 14:48:58'),(17,17,17,17,1,335.0000,'2025-04-15 11:15:57','2025-04-20 18:31:57'),(18,18,18,18,1,111.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(19,19,19,19,1,128.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(20,20,20,20,1,25.0000,'2025-04-15 11:15:57','2025-04-22 08:42:59'),(21,21,21,21,1,5.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(22,22,22,22,1,0.0000,'2025-04-15 11:15:57','2025-04-22 08:42:59'),(23,23,23,23,1,2.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(24,24,24,24,1,8.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57'),(25,25,25,25,1,9.0000,'2025-04-15 11:15:57','2025-04-22 08:42:58'),(26,26,26,26,1,0.0000,'2025-04-15 11:15:57','2025-04-22 12:06:10'),(27,27,27,27,1,0.0000,'2025-04-15 11:15:57','2025-04-22 08:42:59'),(28,28,28,28,1,509.0000,'2025-04-15 11:15:57','2025-04-22 12:44:17'),(29,29,29,29,1,165.0000,'2025-04-15 11:15:57','2025-04-23 11:25:52'),(30,30,30,30,1,0.0000,'2025-04-15 11:15:57','2025-04-22 08:43:00'),(31,31,31,31,1,34.0000,'2025-04-15 11:15:57','2025-04-22 08:43:00'),(32,32,32,32,1,284.0000,'2025-04-15 11:15:58','2025-04-19 13:23:57'),(33,33,33,33,1,229.0000,'2025-04-15 11:15:58','2025-04-20 19:51:26'),(34,34,34,34,1,247.0000,'2025-04-15 11:15:58','2025-04-22 15:43:00'),(35,36,36,36,1,264.0000,'2025-04-15 11:15:58','2025-04-22 08:43:04'),(36,37,37,37,1,85.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(37,38,38,38,1,90.0000,'2025-04-15 11:15:58','2025-04-20 18:31:57'),(38,39,39,39,1,22.0000,'2025-04-15 11:15:58','2025-04-20 18:31:55'),(39,40,40,40,1,278.0000,'2025-04-15 11:15:58','2025-04-23 11:25:52'),(40,41,41,41,1,15.0000,'2025-04-15 11:15:58','2025-04-22 15:27:56'),(41,42,42,42,1,19.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(42,43,43,43,1,0.0000,'2025-04-15 11:15:58','2025-04-22 08:43:00'),(43,44,44,44,1,310.0000,'2025-04-15 11:15:58','2025-04-20 20:46:45'),(44,45,45,45,1,358.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(45,46,46,46,1,134.0000,'2025-04-15 11:15:58','2025-04-22 15:27:55'),(46,47,47,47,1,0.0000,'2025-04-15 11:15:58','2025-04-21 07:56:03'),(47,48,48,48,1,268.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(48,49,49,49,1,25.0000,'2025-04-15 11:15:58','2025-04-22 13:36:51'),(49,50,50,50,1,36.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(50,51,51,51,1,573.0000,'2025-04-15 11:15:58','2025-04-22 08:43:01'),(51,52,52,52,1,22.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(52,53,53,53,1,6.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(53,54,54,54,1,56.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(54,55,55,55,1,59.0000,'2025-04-15 11:15:58','2025-04-20 19:37:10'),(55,56,56,56,1,2.0000,'2025-04-15 11:15:58','2025-04-23 09:43:37'),(56,57,57,57,1,873.0000,'2025-04-15 11:15:58','2025-04-22 08:43:01'),(57,58,58,58,1,86.0000,'2025-04-15 11:15:58','2025-04-18 15:51:28'),(58,59,59,59,1,0.0000,'2025-04-15 11:15:58','2025-04-22 08:42:58'),(59,60,60,60,1,12.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(60,61,61,61,1,33.0000,'2025-04-15 11:15:58','2025-04-22 12:44:17'),(61,62,62,62,1,1.0000,'2025-04-15 11:15:58','2025-04-20 20:46:44'),(62,63,63,63,1,29.0000,'2025-04-15 11:15:58','2025-04-22 08:43:00'),(63,64,64,64,1,5.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(64,65,65,65,1,5.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(65,66,66,66,1,2.0000,'2025-04-15 11:15:58','2025-04-19 10:10:46'),(66,67,67,67,1,189.0000,'2025-04-15 11:15:58','2025-04-21 11:18:05'),(67,68,68,68,1,135.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(68,69,69,69,1,0.0000,'2025-04-15 11:15:58','2025-04-22 08:43:04'),(69,70,70,70,1,762.0000,'2025-04-15 11:15:58','2025-04-22 12:44:17'),(70,71,71,71,1,514.0000,'2025-04-15 11:15:58','2025-04-20 20:46:44'),(71,72,72,72,1,548.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(72,73,73,73,1,1.0000,'2025-04-15 11:15:58','2025-04-20 19:37:12'),(73,74,74,74,1,5.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(74,75,75,75,1,175.0000,'2025-04-15 11:15:58','2025-04-22 08:43:04'),(75,76,76,76,1,94.0000,'2025-04-15 11:15:58','2025-04-19 10:10:46'),(76,77,77,77,1,33.0000,'2025-04-15 11:15:58','2025-04-20 18:31:57'),(77,78,78,78,1,72.0000,'2025-04-15 11:15:58','2025-04-22 08:43:04'),(78,79,79,79,1,20.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(79,80,80,80,1,102.0000,'2025-04-15 11:15:58','2025-04-22 08:42:59'),(80,81,81,81,1,7.0000,'2025-04-15 11:15:58','2025-04-17 10:30:40'),(81,82,82,82,1,156.0000,'2025-04-15 11:15:58','2025-04-22 14:48:58'),(82,83,83,83,1,30.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58'),(83,84,84,84,1,24.0000,'2025-04-15 11:15:58','2025-04-22 08:43:02'),(84,85,85,85,1,2.0000,'2025-04-15 11:15:58','2025-04-19 10:10:46'),(85,86,86,86,1,71.0000,'2025-04-15 11:15:58','2025-04-19 13:23:56'),(86,87,87,87,1,129.0000,'2025-04-15 11:15:58','2025-04-19 10:10:46'),(87,88,88,88,1,151.0000,'2025-04-15 11:15:58','2025-04-22 12:44:17'),(88,89,89,89,1,5.0000,'2025-04-15 11:15:58','2025-04-19 13:23:55'),(89,90,90,90,1,13.0000,'2025-04-15 11:15:58','2025-04-17 12:20:22'),(90,91,91,91,1,0.0000,'2025-04-15 11:15:59','2025-04-20 20:46:48'),(91,92,92,92,1,47.0000,'2025-04-15 11:15:59','2025-04-22 08:43:04'),(92,93,93,93,1,118.0000,'2025-04-15 11:15:59','2025-04-22 09:06:22'),(93,94,94,94,1,3.0000,'2025-04-15 11:15:59','2025-04-23 11:25:52'),(94,95,95,95,1,22.0000,'2025-04-15 11:15:59','2025-04-21 11:18:05'),(95,96,96,96,1,297.0000,'2025-04-15 11:15:59','2025-04-23 12:44:15'),(96,97,97,97,1,19.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(97,98,98,98,1,4.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(98,99,99,99,1,17.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(99,100,100,100,1,39.0000,'2025-04-15 11:15:59','2025-04-19 13:23:57'),(100,101,101,101,1,16.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(101,102,102,102,1,24.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(102,103,103,103,1,19.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(103,104,104,104,1,24.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(104,105,105,105,1,18.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(105,106,106,106,1,14.0000,'2025-04-15 11:15:59','2025-04-20 20:46:44'),(106,107,107,107,1,20.0000,'2025-04-15 11:15:59','2025-04-20 18:31:56'),(107,108,108,108,1,18.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(108,109,109,109,1,603.0000,'2025-04-15 11:15:59','2025-04-20 20:46:47'),(109,110,110,110,1,174.0000,'2025-04-15 11:15:59','2025-04-22 08:43:02'),(110,111,111,111,1,124.0000,'2025-04-15 11:15:59','2025-04-22 08:43:01'),(111,112,112,112,1,47.0000,'2025-04-15 11:15:59','2025-04-23 11:25:52'),(112,113,113,113,1,9.0000,'2025-04-15 11:15:59','2025-04-22 08:43:01'),(113,114,114,114,1,40.0000,'2025-04-15 11:15:59','2025-04-20 18:31:57'),(114,115,115,115,1,16.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(115,116,116,116,1,7.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(116,117,117,117,1,140.0000,'2025-04-15 11:15:59','2025-04-20 19:37:09'),(117,118,118,118,1,26.0000,'2025-04-15 11:15:59','2025-04-22 08:43:02'),(118,119,119,119,1,27.0000,'2025-04-15 11:15:59','2025-04-22 08:43:04'),(119,120,120,120,1,19.0000,'2025-04-15 11:15:59','2025-04-22 08:43:03'),(120,121,121,121,1,163.0000,'2025-04-15 11:15:59','2025-04-19 13:23:56'),(121,122,122,122,1,0.0000,'2025-04-15 11:15:59','2025-04-21 11:18:05'),(122,123,123,123,1,190.0000,'2025-04-15 11:15:59','2025-04-23 11:58:23'),(123,124,124,124,1,24.0000,'2025-04-15 11:15:59','2025-04-23 11:58:23'),(124,125,125,125,1,30.0000,'2025-04-15 11:15:59','2025-04-20 20:46:48'),(125,126,126,126,1,378.0000,'2025-04-15 11:15:59','2025-04-20 20:46:44'),(126,127,127,127,1,252.0000,'2025-04-15 11:15:59','2025-04-23 09:43:37'),(127,128,128,128,1,23.0000,'2025-04-15 11:15:59','2025-04-21 14:04:36'),(128,129,129,129,1,3.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(129,130,130,130,1,2.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(130,131,131,131,1,44.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(131,132,132,132,1,17.0000,'2025-04-15 11:15:59','2025-04-17 12:20:21'),(132,133,133,133,1,26.0000,'2025-04-15 11:15:59','2025-04-22 08:43:01'),(133,134,134,134,1,1.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(134,135,135,135,1,17.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59'),(135,136,136,136,2,5.0000,'2025-04-15 13:47:20','2025-04-15 13:47:20'),(136,137,137,137,2,0.0000,'2025-04-15 13:47:22','2025-04-18 09:10:15'),(137,138,138,138,2,199.0000,'2025-04-15 13:47:22','2025-04-18 13:49:18'),(138,139,139,139,2,2000.0000,'2025-04-15 13:47:23','2025-04-18 10:43:55'),(139,140,140,140,2,800.0000,'2025-04-15 13:47:24','2025-04-18 12:55:11'),(140,141,141,141,2,240.0000,'2025-04-15 13:47:24','2025-04-21 14:42:55'),(141,142,142,142,2,700.0000,'2025-04-15 13:47:24','2025-04-18 10:12:44'),(142,143,143,143,2,75.0000,'2025-04-15 13:47:24','2025-04-19 15:49:17'),(143,144,144,144,2,380.0000,'2025-04-15 13:47:24','2025-04-21 14:43:00'),(144,145,145,145,2,160.0000,'2025-04-15 13:47:25','2025-04-18 09:25:25'),(145,146,146,146,2,19.0000,'2025-04-15 13:47:25','2025-04-19 11:13:25'),(146,147,147,147,2,1140.0000,'2025-04-15 13:47:25','2025-04-21 08:17:09'),(147,148,148,148,2,1108.0000,'2025-04-15 13:47:25','2025-04-23 12:26:49'),(148,149,149,149,2,480.0000,'2025-04-15 13:47:26','2025-04-19 15:35:14'),(149,150,150,150,2,450.0000,'2025-04-15 13:47:26','2025-04-23 12:26:49'),(150,151,151,151,2,480.0000,'2025-04-15 13:47:27','2025-04-19 15:49:18'),(151,152,152,152,2,204.0000,'2025-04-15 13:47:28','2025-04-17 14:02:40'),(152,153,153,153,2,120.0000,'2025-04-15 13:47:29','2025-04-17 14:07:09'),(153,154,154,154,2,282.0000,'2025-04-15 13:47:30','2025-04-18 10:43:55'),(154,155,155,155,2,47.0000,'2025-04-15 13:47:31','2025-04-15 13:47:31'),(155,156,156,156,2,34.0000,'2025-04-15 13:47:32','2025-04-15 13:47:32'),(156,157,157,157,2,1200.0000,'2025-04-15 13:47:33','2025-04-18 09:25:25'),(157,158,158,158,2,28.0000,'2025-04-15 13:47:34','2025-04-19 11:36:28'),(158,159,159,159,2,45.0000,'2025-04-15 13:47:34','2025-04-17 15:07:28'),(159,160,160,160,2,300.0000,'2025-04-15 13:47:35','2025-04-18 11:56:26'),(160,161,161,161,2,520.0000,'2025-04-15 13:47:35','2025-04-17 15:12:53'),(161,162,162,162,2,1500.0000,'2025-04-15 13:47:36','2025-04-17 15:17:18'),(162,163,163,163,2,0.0000,'2025-04-15 13:47:37','2025-04-18 09:25:25'),(163,164,164,164,2,200.0000,'2025-04-15 13:47:37','2025-04-18 09:25:25'),(164,165,165,165,2,300.0000,'2025-04-15 13:47:38','2025-04-18 10:35:46'),(165,166,166,166,2,17000.0000,'2025-04-15 13:47:39','2025-04-18 13:41:38'),(166,167,167,167,2,700.0000,'2025-04-15 13:47:39','2025-04-23 12:26:48'),(167,168,168,168,2,175.0000,'2025-04-15 13:47:39','2025-04-17 15:28:08'),(168,169,169,169,2,0.0000,'2025-04-15 13:47:40','2025-04-18 10:35:46'),(169,170,170,170,2,0.0000,'2025-04-15 13:47:40','2025-04-18 10:35:46'),(170,171,171,171,2,400.0000,'2025-04-15 13:47:41','2025-04-17 15:32:17'),(171,172,172,172,2,0.0000,'2025-04-15 13:47:41','2025-04-18 10:35:46'),(172,173,173,173,2,72.0000,'2025-04-15 13:47:42','2025-04-17 15:33:57'),(173,174,174,174,2,36.0000,'2025-04-15 13:47:43','2025-04-17 15:35:01'),(174,175,175,175,2,1000.0000,'2025-04-15 13:47:44','2025-04-17 15:35:46'),(175,176,176,176,2,0.0000,'2025-04-15 13:47:44','2025-04-18 11:56:27'),(176,177,177,177,2,324.0000,'2025-04-15 13:47:44','2025-04-17 15:37:18'),(177,178,178,178,2,240.0000,'2025-04-15 13:47:44','2025-04-17 15:43:34'),(178,179,179,179,2,40.0000,'2025-04-15 13:47:44','2025-04-17 15:45:18'),(179,180,180,180,2,1296.0000,'2025-04-15 13:47:44','2025-04-17 15:47:08'),(180,181,181,181,2,528.0000,'2025-04-15 13:47:44','2025-04-18 14:05:31'),(181,182,182,182,2,324.0000,'2025-04-15 13:47:44','2025-04-17 15:49:45'),(182,183,183,183,2,16.0000,'2025-04-15 13:47:45','2025-04-17 15:50:40'),(183,184,184,184,2,24.0000,'2025-04-15 13:47:45','2025-04-17 15:51:18'),(184,185,185,185,2,72.0000,'2025-04-15 13:47:45','2025-04-17 15:52:27'),(185,186,186,186,2,300.0000,'2025-04-15 13:47:45','2025-04-18 13:44:13'),(186,187,187,187,2,104.0000,'2025-04-15 13:47:45','2025-04-19 11:27:36'),(187,188,188,188,2,176.0000,'2025-04-15 13:47:46','2025-04-19 11:27:36'),(188,189,189,189,2,32.0000,'2025-04-15 13:47:46','2025-04-19 11:27:36'),(189,190,190,190,2,500.0000,'2025-04-15 13:47:46','2025-04-17 16:05:41'),(190,191,191,191,2,338.0000,'2025-04-15 13:47:47','2025-04-23 12:26:48'),(191,192,192,192,2,400.0000,'2025-04-15 13:47:47','2025-04-17 16:06:50'),(192,193,193,193,2,488.0000,'2025-04-15 13:47:48','2025-04-23 12:26:48'),(193,194,194,194,2,404.0000,'2025-04-15 13:47:48','2025-04-23 12:26:48'),(194,195,195,195,2,2780.0000,'2025-04-15 13:47:49','2025-04-18 12:55:12'),(195,196,196,196,2,1451.0000,'2025-04-15 13:47:49','2025-04-19 15:49:17'),(196,197,197,197,2,18.0000,'2025-04-15 13:47:50','2025-04-21 14:42:57'),(197,198,198,198,2,300.0000,'2025-04-15 13:47:50','2025-04-19 15:49:17'),(198,199,199,199,2,370.0000,'2025-04-15 13:47:50','2025-04-21 14:43:01'),(199,200,200,200,2,120.0000,'2025-04-15 13:47:51','2025-04-21 14:42:59'),(200,201,201,201,2,96.0000,'2025-04-15 13:47:51','2025-04-18 11:25:13'),(201,202,202,202,2,70.0000,'2025-04-15 13:47:52','2025-04-18 12:55:11'),(202,203,203,203,2,0.0000,'2025-04-15 13:47:52','2025-04-18 12:01:30'),(203,204,204,204,2,6.0000,'2025-04-15 13:47:52','2025-04-18 12:55:11'),(227,137,137,137,1,469.0000,'2025-04-17 07:00:33','2025-04-22 08:43:01'),(228,205,205,205,2,230.0000,'2025-04-17 14:22:19','2025-04-18 09:30:50'),(229,207,207,207,2,1.0000,'2025-04-18 08:19:06','2025-04-18 08:19:06'),(230,206,206,206,2,450.0000,'2025-04-18 08:48:35','2025-04-21 14:42:56'),(231,167,167,167,1,394.0000,'2025-04-18 09:05:36','2025-04-23 12:26:49'),(232,164,164,164,1,130.0000,'2025-04-18 09:25:25','2025-04-22 08:43:03'),(233,157,157,157,1,3781.0000,'2025-04-18 09:25:25','2025-04-22 12:44:17'),(234,163,163,163,1,1178.0000,'2025-04-18 09:25:25','2025-04-23 11:58:23'),(235,145,145,145,1,160.0000,'2025-04-18 09:25:25','2025-04-18 09:25:25'),(236,166,166,166,1,5162.0000,'2025-04-18 09:25:25','2025-04-23 11:53:15'),(237,205,205,205,1,195.0000,'2025-04-18 09:30:50','2025-04-19 13:23:56'),(238,208,208,208,2,432.0000,'2025-04-18 09:37:40','2025-04-18 09:46:11'),(239,208,208,208,1,72.0000,'2025-04-18 09:46:11','2025-04-20 18:31:56'),(240,140,140,140,1,119.0000,'2025-04-18 09:48:45','2025-04-22 12:44:17'),(241,151,151,151,1,445.0000,'2025-04-18 10:04:10','2025-04-23 11:25:53'),(242,142,142,142,1,782.0000,'2025-04-18 10:04:11','2025-04-22 12:44:17'),(243,202,202,202,1,135.0000,'2025-04-18 10:12:44','2025-04-22 16:02:20'),(244,197,197,197,1,90.0000,'2025-04-18 10:12:45','2025-04-23 11:25:52'),(245,195,195,195,1,2229.0000,'2025-04-18 10:12:45','2025-04-23 09:43:37'),(246,199,199,199,1,386.0000,'2025-04-18 10:12:45','2025-04-22 10:21:27'),(247,206,206,206,1,365.0000,'2025-04-18 10:35:45','2025-04-21 14:42:56'),(248,141,141,141,1,264.0000,'2025-04-18 10:35:45','2025-04-22 08:43:02'),(249,165,165,165,1,119.0000,'2025-04-18 10:35:46','2025-04-20 20:46:47'),(250,170,170,170,1,250.0000,'2025-04-18 10:35:46','2025-04-18 10:35:46'),(251,172,172,172,1,20.0000,'2025-04-18 10:35:46','2025-04-18 10:35:46'),(252,169,169,169,1,30.0000,'2025-04-18 10:35:46','2025-04-18 10:35:46'),(253,139,139,139,1,290.0000,'2025-04-18 10:43:55','2025-04-19 07:46:36'),(254,154,154,154,1,48.0000,'2025-04-18 10:43:55','2025-04-23 10:08:03'),(255,143,143,143,1,121.0000,'2025-04-18 10:43:55','2025-04-22 15:27:56'),(256,203,203,203,1,74.0000,'2025-04-18 11:24:25','2025-04-23 11:58:23'),(257,148,148,148,1,110.0000,'2025-04-18 11:25:13','2025-04-23 12:26:49'),(258,149,149,149,1,120.0000,'2025-04-18 11:25:13','2025-04-19 11:41:06'),(259,201,201,201,1,208.0000,'2025-04-18 11:25:13','2025-04-22 08:43:03'),(260,204,204,204,1,37.0000,'2025-04-18 11:56:26','2025-04-22 08:43:04'),(261,198,198,198,1,117.0000,'2025-04-18 11:56:26','2025-04-22 08:43:04'),(262,200,200,200,1,152.0000,'2025-04-18 11:56:26','2025-04-22 08:43:04'),(263,196,196,196,1,2578.0000,'2025-04-18 11:56:26','2025-04-23 11:58:23'),(264,160,160,160,1,300.0000,'2025-04-18 11:56:27','2025-04-18 11:56:27'),(265,147,147,147,1,153.0000,'2025-04-18 11:56:27','2025-04-22 08:43:04'),(266,176,176,176,1,16.0000,'2025-04-18 11:56:27','2025-04-22 08:43:02'),(267,209,209,209,2,150.0000,'2025-04-18 13:18:37','2025-04-18 13:31:13'),(268,210,210,210,2,1960.0000,'2025-04-18 13:27:30','2025-04-21 14:43:03'),(269,209,209,209,1,53.0000,'2025-04-18 13:31:13','2025-04-22 08:43:04'),(270,210,210,210,1,77.0000,'2025-04-18 13:34:46','2025-04-21 14:43:03'),(271,186,186,186,1,170.0000,'2025-04-18 13:44:13','2025-04-22 08:42:59'),(272,138,138,138,1,1.0000,'2025-04-18 13:49:18','2025-04-18 13:49:18'),(273,181,181,181,1,48.0000,'2025-04-18 14:05:32','2025-04-18 14:05:32'),(274,211,211,211,3,198.0000,'2025-04-18 19:47:04','2025-04-18 19:57:36'),(275,146,146,146,1,1.0000,'2025-04-19 11:13:25','2025-04-19 11:13:25'),(276,188,188,188,1,51.0000,'2025-04-19 11:27:36','2025-04-22 15:27:56'),(277,187,187,187,1,66.0000,'2025-04-19 11:27:36','2025-04-22 14:48:58'),(278,189,189,189,1,111.0000,'2025-04-19 11:27:36','2025-04-20 18:31:56'),(279,158,158,158,1,40.0000,'2025-04-19 11:36:28','2025-04-22 08:42:59'),(280,150,150,150,1,390.0000,'2025-04-19 11:41:05','2025-04-23 12:26:49'),(281,212,212,212,2,900.0000,'2025-04-19 13:43:30','2025-04-19 13:46:21'),(282,212,212,212,1,425.0000,'2025-04-19 13:46:21','2025-04-21 13:51:04'),(283,213,213,213,2,550.0000,'2025-04-21 09:10:09','2025-04-21 09:20:50'),(284,213,213,213,1,50.0000,'2025-04-21 09:20:50','2025-04-21 09:20:50'),(285,144,144,144,1,0.0000,'2025-04-21 14:43:01','2025-04-22 08:42:58'),(286,194,194,194,1,76.0000,'2025-04-23 12:26:48','2025-04-23 12:26:48'),(287,191,191,191,1,142.0000,'2025-04-23 12:26:48','2025-04-23 12:26:48'),(288,193,193,193,1,112.0000,'2025-04-23 12:26:48','2025-04-23 12:26:48'),(289,215,215,215,2,2000.0000,'2025-04-23 13:11:32','2025-04-23 13:11:32');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(22,4) DEFAULT NULL,
  `dpp_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `profit_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `default_sell_price` decimal(22,4) DEFAULT NULL,
  `sell_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `combo_variations` text DEFAULT NULL COMMENT 'Contains the combo variation details',
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'0001',1,NULL,84000.0000,84000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(2,'DUMMY',2,'0002',2,NULL,84000.0000,84000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(3,'DUMMY',3,'0003',3,NULL,84000.0000,84000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(4,'DUMMY',4,'0004',4,NULL,84000.0000,84000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(5,'DUMMY',5,'0005',5,NULL,84000.0000,84000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(6,'DUMMY',6,'0006',6,NULL,75000.0000,75000.0000,25.0000,96000.0000,96000.0000,'2025-04-15 11:15:57','2025-04-17 09:35:57',NULL,'[]'),(7,'DUMMY',7,'0007',7,NULL,75000.0000,75000.0000,25.0000,96000.0000,96000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(8,'DUMMY',8,'0008',8,NULL,75000.0000,75000.0000,25.0000,96000.0000,96000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(9,'DUMMY',9,'0009',9,NULL,104000.0000,104000.0000,25.0000,155000.0000,155000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(10,'DUMMY',10,'0010',10,NULL,104000.0000,104000.0000,25.0000,155000.0000,155000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(11,'DUMMY',11,'0011',11,NULL,104000.0000,104000.0000,25.0000,155000.0000,155000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(12,'DUMMY',12,'0012',12,NULL,132000.0000,132000.0000,25.0000,156000.0000,156000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(13,'DUMMY',13,'0013',13,NULL,132000.0000,132000.0000,25.0000,156000.0000,156000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(14,'DUMMY',14,'0014',14,NULL,132000.0000,132000.0000,25.0000,156000.0000,156000.0000,'2025-04-15 11:15:57','2025-04-21 13:08:19',NULL,'[]'),(15,'DUMMY',15,'0015',15,NULL,132000.0000,132000.0000,25.0000,156000.0000,156000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(16,'DUMMY',16,'0016',16,NULL,1300.0000,1300.0000,25.0000,35000.0000,35000.0000,'2025-04-15 11:15:57','2025-04-22 14:29:52',NULL,'[]'),(17,'DUMMY',17,'0017',17,NULL,5800.0000,5800.0000,25.0000,8000.0000,8000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(18,'DUMMY',18,'0018',18,NULL,16000.0000,16000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(19,'DUMMY',19,'0019',19,NULL,22500.0000,22500.0000,25.0000,35000.0000,35000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(20,'DUMMY',20,'0020',20,NULL,1641.0000,1641.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(21,'DUMMY',21,'0021',21,NULL,12900.0000,12900.0000,25.0000,20000.0000,20000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(22,'DUMMY',22,'0022',22,NULL,53287.0000,53287.0000,25.0000,90000.0000,90000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(23,'DUMMY',23,'0023',23,NULL,54000.0000,54000.0000,25.0000,80000.0000,80000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(24,'DUMMY',24,'0024',24,NULL,32000.0000,32000.0000,25.0000,53000.0000,53000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(25,'DUMMY',25,'0025',25,NULL,29675.0000,29675.0000,25.0000,55000.0000,55000.0000,'2025-04-15 11:15:57','2025-04-19 14:25:47',NULL,'[]'),(26,'DUMMY',26,'0026',26,NULL,23500.0000,23500.0000,25.0000,60000.0000,60000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(27,'DUMMY',27,'0027',27,NULL,30062.0000,30062.0000,25.0000,60000.0000,60000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(28,'DUMMY',28,'0028',28,NULL,3900.0000,3900.0000,25.0000,70000.0000,70000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(29,'DUMMY',29,'0029',29,NULL,3330.0000,3330.0000,25.0000,6000.0000,6000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(30,'DUMMY',30,'0030',30,NULL,31600.0000,31600.0000,25.0000,37000.0000,37000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(31,'DUMMY',31,'0031',31,NULL,21225.0000,21225.0000,25.0000,27000.0000,27000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(32,'DUMMY',32,'0032',32,NULL,2400.0000,2400.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:57','2025-04-15 11:15:57',NULL,'[]'),(33,'DUMMY',33,'0033',33,NULL,1650.0000,1650.0000,25.0000,3500.0000,3500.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(34,'DUMMY',34,'0034',34,NULL,2400.0000,2400.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(35,'DUMMY',35,'0035',35,NULL,4500.0000,4500.0000,25.0000,8000.0000,8000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(36,'DUMMY',36,'0036',36,NULL,4000.0000,4000.0000,25.0000,7000.0000,7000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(37,'DUMMY',37,'0037',37,NULL,18000.0000,18000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(38,'DUMMY',38,'0038',38,NULL,4100.0000,4100.0000,25.0000,6500.0000,6500.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(39,'DUMMY',39,'0039',39,NULL,8000.0000,8000.0000,25.0000,13000.0000,13000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(40,'DUMMY',40,'0040',40,NULL,14000.0000,14000.0000,25.0000,16000.0000,16000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(41,'DUMMY',41,'0041',41,NULL,11544.0000,11544.0000,25.0000,16000.0000,16000.0000,'2025-04-15 11:15:58','2025-04-19 09:36:27',NULL,'[]'),(42,'DUMMY',42,'0042',42,NULL,24500.0000,24500.0000,25.0000,45000.0000,45000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(43,'DUMMY',43,'0043',43,NULL,31800.0000,31800.0000,25.0000,38000.0000,38000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(44,'DUMMY',44,'0044',44,NULL,26475.0000,26475.0000,25.0000,31000.0000,31000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(45,'DUMMY',45,'0045',45,NULL,6120.0000,6120.0000,25.0000,9000.0000,9000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(46,'DUMMY',46,'0046',46,NULL,30000.0000,30000.0000,25.0000,34000.0000,34000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(47,'DUMMY',47,'0047',47,NULL,19000.0000,19000.0000,25.0000,22000.0000,22000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(48,'DUMMY',48,'0048',48,NULL,3500.0000,3500.0000,25.0000,4375.0000,4375.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(49,'DUMMY',49,'0049',49,NULL,38970.0000,38970.0000,25.0000,55000.0000,55000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(50,'DUMMY',50,'0050',50,NULL,6000.0000,6000.0000,25.0000,9000.0000,9000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(51,'DUMMY',51,'0051',51,NULL,6500.0000,6500.0000,25.0000,10000.0000,10000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(52,'DUMMY',52,'0052',52,NULL,29000.0000,29000.0000,25.0000,45000.0000,45000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(53,'DUMMY',53,'0053',53,NULL,52000.0000,52000.0000,25.0000,80000.0000,80000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(54,'DUMMY',54,'0054',54,NULL,8000.0000,8000.0000,25.0000,13000.0000,13000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(55,'DUMMY',55,'0055',55,NULL,14500.0000,14500.0000,25.0000,25000.0000,25000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(56,'DUMMY',56,'0056',56,NULL,65800.0000,65800.0000,25.0000,85000.0000,85000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(57,'DUMMY',57,'0057',57,NULL,1100.0000,1100.0000,25.0000,1700.0000,1700.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(58,'DUMMY',58,'0058',58,NULL,16560.0000,16560.0000,25.0000,25000.0000,25000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(59,'DUMMY',59,'0059',59,NULL,17500.0000,17500.0000,25.0000,28000.0000,28000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(60,'DUMMY',60,'0060',60,NULL,13000.0000,13000.0000,25.0000,20000.0000,20000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(61,'DUMMY',61,'0061',61,NULL,4000.0000,4000.0000,25.0000,6000.0000,6000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(62,'DUMMY',62,'0062',62,NULL,18000.0000,18000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(63,'DUMMY',63,'0063',63,NULL,25000.0000,25000.0000,25.0000,45000.0000,45000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(64,'DUMMY',64,'0064',64,NULL,360000.0000,360000.0000,25.0000,520000.0000,520000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(65,'DUMMY',65,'0065',65,NULL,550000.0000,550000.0000,25.0000,700000.0000,700000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(66,'DUMMY',66,'0066',66,NULL,13000.0000,13000.0000,25.0000,20000.0000,20000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(67,'DUMMY',67,'0067',67,NULL,4000.0000,4000.0000,25.0000,6500.0000,6500.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(68,'DUMMY',68,'0068',68,NULL,6500.0000,6500.0000,25.0000,10000.0000,10000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(69,'DUMMY',69,'0069',69,NULL,3300.0000,3300.0000,25.0000,4500.0000,4500.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(70,'DUMMY',70,'0070',70,NULL,2000.0000,2000.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(71,'DUMMY',71,'0071',71,NULL,1300.0000,1300.0000,25.0000,4000.0000,4000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(72,'DUMMY',72,'0072',72,NULL,6100.0000,6100.0000,25.0000,8000.0000,8000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(73,'DUMMY',73,'0073',73,NULL,30000.0000,30000.0000,25.0000,40000.0000,40000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(74,'DUMMY',74,'0074',74,NULL,20000.0000,20000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(75,'DUMMY',75,'0075',75,NULL,25800.0000,25800.0000,25.0000,35000.0000,35000.0000,'2025-04-15 11:15:58','2025-04-21 15:16:06',NULL,'[]'),(76,'DUMMY',76,'0076',76,NULL,1100.0000,1100.0000,25.0000,25000.0000,25000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(77,'DUMMY',77,'0077',77,NULL,9450.0000,9450.0000,25.0000,14000.0000,14000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(78,'DUMMY',78,'0078',78,NULL,5000.0000,5000.0000,25.0000,7000.0000,7000.0000,'2025-04-15 11:15:58','2025-04-21 09:18:25',NULL,'[]'),(79,'DUMMY',79,'0079',79,NULL,2200.0000,2200.0000,25.0000,4000.0000,4000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(80,'DUMMY',80,'0080',80,NULL,3530.0000,3530.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(81,'DUMMY',81,'0081',81,NULL,3530.0000,3530.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(82,'DUMMY',82,'0082',82,NULL,10500.0000,10500.0000,25.0000,18000.0000,18000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(83,'DUMMY',83,'0083',83,NULL,2200.0000,2200.0000,25.0000,4000.0000,4000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(84,'DUMMY',84,'0084',84,NULL,4000.0000,4000.0000,25.0000,65000.0000,65000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(85,'DUMMY',85,'0085',85,NULL,8100.0000,8100.0000,25.0000,12000.0000,12000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(86,'DUMMY',86,'0086',86,NULL,4200.0000,4200.0000,25.0000,6000.0000,6000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(87,'DUMMY',87,'0087',87,NULL,3500.0000,3500.0000,25.0000,6000.0000,6000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(88,'DUMMY',88,'0088',88,NULL,5200.0000,5200.0000,25.0000,9000.0000,9000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(89,'DUMMY',89,'0089',89,NULL,4100.0000,4100.0000,25.0000,6500.0000,6500.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(90,'DUMMY',90,'0090',90,NULL,65000.0000,65000.0000,25.0000,80000.0000,80000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(91,'DUMMY',91,'0091',91,NULL,16000.0000,16000.0000,25.0000,20000.0000,20000.0000,'2025-04-15 11:15:58','2025-04-15 11:15:58',NULL,'[]'),(92,'DUMMY',92,'0092',92,NULL,18000.0000,18000.0000,25.0000,29000.0000,29000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(93,'DUMMY',93,'0093',93,NULL,5200.0000,5200.0000,25.0000,80000.0000,80000.0000,'2025-04-15 11:15:59','2025-04-17 09:41:09',NULL,'[]'),(94,'DUMMY',94,'0094',94,NULL,32580.0000,32580.0000,25.0000,40000.0000,40000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(95,'DUMMY',95,'0095',95,NULL,40000.0000,40000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(96,'DUMMY',96,'0096',96,NULL,750.0000,750.0000,25.0000,31750.0000,31750.0000,'2025-04-15 11:15:59','2025-04-23 12:42:49',NULL,'[]'),(97,'DUMMY',97,'0097',97,NULL,32000.0000,32000.0000,25.0000,45000.0000,45000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(98,'DUMMY',98,'0098',98,NULL,28000.0000,28000.0000,25.0000,40000.0000,40000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(99,'DUMMY',99,'0099',99,NULL,22000.0000,22000.0000,25.0000,38000.0000,38000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(100,'DUMMY',100,'0100',100,NULL,10500.0000,10500.0000,25.0000,15000.0000,15000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(101,'DUMMY',101,'0101',101,NULL,23000.0000,23000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(102,'DUMMY',102,'0102',102,NULL,17000.0000,17000.0000,25.0000,28000.0000,28000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(103,'DUMMY',103,'0103',103,NULL,22000.0000,22000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(104,'DUMMY',104,'0104',104,NULL,21000.0000,21000.0000,25.0000,35000.0000,35000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(105,'DUMMY',105,'0105',105,NULL,11000.0000,11000.0000,25.0000,18000.0000,18000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(106,'DUMMY',106,'0106',106,NULL,18000.0000,18000.0000,25.0000,32000.0000,32000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(107,'DUMMY',107,'0107',107,NULL,18000.0000,18000.0000,25.0000,32000.0000,32000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(108,'DUMMY',108,'0108',108,NULL,14000.0000,14000.0000,25.0000,28000.0000,28000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(109,'DUMMY',109,'0109',109,NULL,1320.0000,1320.0000,25.0000,3500.0000,3500.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(110,'DUMMY',110,'0110',110,NULL,2200.0000,2200.0000,25.0000,7000.0000,7000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(111,'DUMMY',111,'0111',111,NULL,3200.0000,3200.0000,25.0000,6000.0000,6000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(112,'DUMMY',112,'0112',112,NULL,10000.0000,10000.0000,25.0000,15000.0000,15000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(113,'DUMMY',113,'0113',113,NULL,2300.0000,2300.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(114,'DUMMY',114,'0114',114,NULL,8040.0000,8040.0000,25.0000,10000.0000,10000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(115,'DUMMY',115,'0115',115,NULL,19800.0000,19800.0000,25.0000,33000.0000,33000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(116,'DUMMY',116,'0116',116,NULL,19800.0000,19800.0000,25.0000,33000.0000,33000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(117,'DUMMY',117,'0117',117,NULL,12500.0000,12500.0000,25.0000,20000.0000,20000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(118,'DUMMY',118,'0118',118,NULL,7510.0000,7510.0000,25.0000,11000.0000,11000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(119,'DUMMY',119,'0119',119,NULL,8000.0000,8000.0000,25.0000,15000.0000,15000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(120,'DUMMY',120,'0120',120,NULL,34200.0000,34200.0000,25.0000,45000.0000,45000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(121,'DUMMY',121,'0121',121,NULL,2100.0000,2100.0000,25.0000,5000.0000,5000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(122,'DUMMY',122,'0122',122,NULL,11000.0000,11000.0000,25.0000,20000.0000,20000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(123,'DUMMY',123,'0123',123,NULL,14000.0000,14000.0000,25.0000,24000.0000,24000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(124,'DUMMY',124,'0124',124,NULL,9000.0000,9000.0000,25.0000,13000.0000,13000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(125,'DUMMY',125,'0125',125,NULL,17000.0000,17000.0000,25.0000,39000.0000,39000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(126,'DUMMY',126,'0126',126,NULL,950.0000,950.0000,25.0000,2000.0000,2000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(127,'DUMMY',127,'0127',127,NULL,14000.0000,14000.0000,25.0000,17000.0000,17000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(128,'DUMMY',128,'0128',128,NULL,20000.0000,20000.0000,25.0000,40000.0000,40000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(129,'DUMMY',129,'0129',129,NULL,55000.0000,55000.0000,25.0000,80000.0000,80000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(130,'DUMMY',130,'0130',130,NULL,45000.0000,45000.0000,25.0000,80000.0000,80000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(131,'DUMMY',131,'0131',131,NULL,30000.0000,30000.0000,25.0000,45000.0000,45000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(132,'DUMMY',132,'0132',132,NULL,40000.0000,40000.0000,25.0000,55000.0000,55000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(133,'DUMMY',133,'0133',133,NULL,1800.0000,1800.0000,25.0000,3500.0000,3500.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(134,'DUMMY',134,'0134',134,NULL,30000.0000,30000.0000,25.0000,50000.0000,50000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(135,'DUMMY',135,'0135',135,NULL,52000.0000,52000.0000,25.0000,90000.0000,90000.0000,'2025-04-15 11:15:59','2025-04-15 11:15:59',NULL,'[]'),(136,'DUMMY',136,'0136',136,NULL,4200.0000,4200.0000,25.0000,6000.0000,6000.0000,'2025-04-15 13:47:20','2025-04-15 13:47:20',NULL,'[]'),(137,'DUMMY',137,'0137',137,NULL,31800.0000,31800.0000,25.0000,38000.0000,38000.0000,'2025-04-15 13:47:21','2025-04-15 13:47:21',NULL,'[]'),(138,'DUMMY',138,'0138',138,NULL,38970.0000,38970.0000,25.0000,55000.0000,55000.0000,'2025-04-15 13:47:22','2025-04-15 13:47:22',NULL,'[]'),(139,'DUMMY',139,'0139',139,NULL,8040.0000,8040.0000,25.0000,10000.0000,10000.0000,'2025-04-15 13:47:23','2025-04-15 13:47:23',NULL,'[]'),(140,'DUMMY',140,'0140',140,NULL,16000.0000,16000.0000,25.0000,20000.0000,20000.0000,'2025-04-15 13:47:24','2025-04-15 13:47:24',NULL,'[]'),(141,'DUMMY',141,'0141',141,NULL,26475.0000,26475.0000,25.0000,31000.0000,31000.0000,'2025-04-15 13:47:24','2025-04-15 13:47:24',NULL,'[]'),(142,'DUMMY',142,'0142',142,NULL,14000.0000,14000.0000,25.0000,17000.0000,17000.0000,'2025-04-15 13:47:24','2025-04-17 13:29:39',NULL,'[]'),(143,'DUMMY',143,'0143',143,NULL,11000.0000,11000.0000,25.0000,20000.0000,20000.0000,'2025-04-15 13:47:24','2025-04-17 13:34:06',NULL,'[]'),(144,'DUMMY',144,'0144',144,NULL,4000.0000,4000.0000,25.0000,6000.0000,6000.0000,'2025-04-15 13:47:24','2025-04-15 13:47:24',NULL,'[]'),(145,'DUMMY',145,'0145',145,NULL,14000.0000,14000.0000,25.0000,16000.0000,16000.0000,'2025-04-15 13:47:24','2025-04-15 13:47:24',NULL,'[]'),(146,'DUMMY',146,'0146',146,NULL,550000.0000,550000.0000,25.0000,700000.0000,700000.0000,'2025-04-15 13:47:25','2025-04-15 13:47:25',NULL,'[]'),(147,'DUMMY',147,'0147',147,NULL,4800.0000,4800.0000,25.0000,6500.0000,6500.0000,'2025-04-15 13:47:25','2025-04-15 13:47:25',NULL,'[]'),(148,'DUMMY',148,'0148',148,NULL,75000.0000,75000.0000,25.0000,96000.0000,96000.0000,'2025-04-15 13:47:25','2025-04-15 13:47:25',NULL,'[]'),(149,'DUMMY',149,'0149',149,NULL,75000.0000,75000.0000,25.0000,96000.0000,96000.0000,'2025-04-15 13:47:26','2025-04-15 13:47:26',NULL,'[]'),(150,'DUMMY',150,'0150',150,NULL,75000.0000,75000.0000,25.0000,96000.0000,96000.0000,'2025-04-15 13:47:26','2025-04-15 13:47:26',NULL,'[]'),(151,'DUMMY',151,'0151',151,NULL,104000.0000,104000.0000,25.0000,155000.0000,155000.0000,'2025-04-15 13:47:27','2025-04-15 13:47:27',NULL,'[]'),(152,'DUMMY',152,'0152',152,NULL,104000.0000,104000.0000,25.0000,155000.0000,155000.0000,'2025-04-15 13:47:27','2025-04-15 13:47:27',NULL,'[]'),(153,'DUMMY',153,'0153',153,NULL,132000.0000,132000.0000,25.0000,156000.0000,156000.0000,'2025-04-15 13:47:28','2025-04-15 13:47:28',NULL,'[]'),(154,'DUMMY',154,'0154',154,NULL,104000.0000,104000.0000,25.0000,155000.0000,155000.0000,'2025-04-15 13:47:30','2025-04-23 13:24:54',NULL,'[]'),(155,'DUMMY',155,'0155',155,NULL,21225.0000,21225.0000,25.0000,27000.0000,27000.0000,'2025-04-15 13:47:31','2025-04-15 13:47:31',NULL,'[]'),(156,'DUMMY',156,'0156',156,NULL,31600.0000,31600.0000,25.0000,37000.0000,37000.0000,'2025-04-15 13:47:32','2025-04-15 13:47:32',NULL,'[]'),(157,'DUMMY',157,'0157',157,NULL,2400.0000,2400.0000,25.0000,5000.0000,5000.0000,'2025-04-15 13:47:33','2025-04-15 13:47:33',NULL,'[]'),(158,'DUMMY',158,'0158',158,NULL,12900.0000,12900.0000,25.0000,20000.0000,20000.0000,'2025-04-15 13:47:34','2025-04-19 11:29:51',NULL,'[]'),(159,'DUMMY',159,'0159',159,NULL,65000.0000,65000.0000,25.0000,80000.0000,80000.0000,'2025-04-15 13:47:34','2025-04-17 15:06:18',NULL,'[]'),(160,'DUMMY',160,'0160',160,NULL,1300.0000,1300.0000,25.0000,4000.0000,4000.0000,'2025-04-15 13:47:35','2025-04-15 13:47:35',NULL,'[]'),(161,'DUMMY',161,'0161',161,NULL,32580.0000,32580.0000,25.0000,40000.0000,40000.0000,'2025-04-15 13:47:35','2025-04-15 13:47:35',NULL,'[]'),(162,'DUMMY',162,'0162',162,NULL,4000.0000,4000.0000,25.0000,7000.0000,7000.0000,'2025-04-15 13:47:36','2025-04-15 13:47:36',NULL,'[]'),(163,'DUMMY',163,'0163',163,NULL,4500.0000,4500.0000,25.0000,8000.0000,8000.0000,'2025-04-15 13:47:36','2025-04-15 13:47:36',NULL,'[]'),(164,'DUMMY',164,'0164',164,NULL,4045.0000,4045.0000,25.0000,6000.0000,6000.0000,'2025-04-15 13:47:37','2025-04-15 13:47:37',NULL,'[]'),(165,'DUMMY',165,'0165',165,NULL,65800.0000,65800.0000,25.0000,85000.0000,85000.0000,'2025-04-15 13:47:37','2025-04-15 13:47:37',NULL,'[]'),(166,'DUMMY',166,'0166',166,NULL,1100.0000,1100.0000,25.0000,1700.0000,1700.0000,'2025-04-15 13:47:38','2025-04-15 13:47:38',NULL,'[]'),(167,'DUMMY',167,'0167',167,NULL,14000.0000,14000.0000,25.0000,24000.0000,24000.0000,'2025-04-15 13:47:39','2025-04-15 13:47:39',NULL,'[]'),(168,'DUMMY',168,'0168',168,NULL,3500.0000,3500.0000,25.0000,6000.0000,6000.0000,'2025-04-15 13:47:39','2025-04-15 13:47:39',NULL,'[]'),(169,'DUMMY',169,'0169',169,NULL,14500.0000,14500.0000,25.0000,20000.0000,20000.0000,'2025-04-15 13:47:39','2025-04-15 13:47:39',NULL,'[]'),(170,'DUMMY',170,'0170',170,NULL,2000.0000,2000.0000,25.0000,5000.0000,5000.0000,'2025-04-15 13:47:40','2025-04-15 13:47:40',NULL,'[]'),(171,'DUMMY',171,'0171',171,NULL,6800.0000,6800.0000,25.0000,8000.0000,8000.0000,'2025-04-15 13:47:40','2025-04-15 13:47:40',NULL,'[]'),(172,'DUMMY',172,'0172',172,NULL,6200.0000,6200.0000,25.0000,12000.0000,12000.0000,'2025-04-15 13:47:41','2025-04-15 13:47:41',NULL,'[]'),(173,'DUMMY',173,'0173',173,NULL,19800.0000,19800.0000,25.0000,33000.0000,33000.0000,'2025-04-15 13:47:41','2025-04-15 13:47:41',NULL,'[]'),(174,'DUMMY',174,'0174',174,NULL,36000.0000,36000.0000,25.0000,48000.0000,48000.0000,'2025-04-15 13:47:43','2025-04-15 13:47:43',NULL,'[]'),(175,'DUMMY',175,'0175',175,NULL,23000.0000,23000.0000,25.0000,5000.0000,5000.0000,'2025-04-15 13:47:43','2025-04-15 13:47:43',NULL,'[]'),(176,'DUMMY',176,'0176',176,NULL,7089.0000,7089.0000,25.0000,9000.0000,9000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(177,'DUMMY',177,'0177',177,NULL,23000.0000,23000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(178,'DUMMY',178,'0178',178,NULL,6000.0000,6000.0000,25.0000,9000.0000,9000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(179,'DUMMY',179,'0179',179,NULL,11000.0000,11000.0000,25.0000,22000.0000,22000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(180,'DUMMY',180,'0180',180,NULL,17000.0000,17000.0000,25.0000,30000.0000,30000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(181,'DUMMY',181,'0181',181,NULL,29000.0000,29000.0000,25.0000,48000.0000,48000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(182,'DUMMY',182,'0182',182,NULL,29000.0000,29000.0000,25.0000,48000.0000,48000.0000,'2025-04-15 13:47:44','2025-04-15 13:47:44',NULL,'[]'),(183,'DUMMY',183,'0183',183,NULL,34200.0000,34200.0000,25.0000,45000.0000,45000.0000,'2025-04-15 13:47:45','2025-04-15 13:47:45',NULL,'[]'),(184,'DUMMY',184,'0184',184,NULL,25000.0000,25000.0000,25.0000,45000.0000,45000.0000,'2025-04-15 13:47:45','2025-04-15 13:47:45',NULL,'[]'),(185,'DUMMY',185,'0185',185,NULL,18000.0000,18000.0000,25.0000,29000.0000,29000.0000,'2025-04-15 13:47:45','2025-04-15 13:47:45',NULL,'[]'),(186,'DUMMY',186,'0186',186,NULL,3510.0000,3510.0000,25.0000,5000.0000,5000.0000,'2025-04-15 13:47:45','2025-04-15 13:47:45',NULL,'[]'),(187,'DUMMY',187,'0187',187,NULL,17000.0000,17000.0000,25.0000,29000.0000,29000.0000,'2025-04-15 13:47:45','2025-04-15 13:47:45',NULL,'[]'),(188,'DUMMY',188,'0188',188,NULL,13700.0000,13700.0000,25.0000,26000.0000,26000.0000,'2025-04-15 13:47:46','2025-04-15 13:47:46',NULL,'[]'),(189,'DUMMY',189,'0189',189,NULL,19800.0000,19800.0000,25.0000,35000.0000,35000.0000,'2025-04-15 13:47:46','2025-04-15 13:47:46',NULL,'[]'),(190,'DUMMY',190,'0190',190,NULL,3247.0000,3247.0000,25.0000,6500.0000,6500.0000,'2025-04-15 13:47:46','2025-04-15 13:47:46',NULL,'[]'),(191,'DUMMY',191,'0191',191,NULL,4700.0000,4700.0000,25.0000,6500.0000,6500.0000,'2025-04-15 13:47:47','2025-04-15 13:47:47',NULL,'[]'),(192,'DUMMY',192,'0192',192,NULL,3350.0000,3350.0000,25.0000,6000.0000,6000.0000,'2025-04-15 13:47:47','2025-04-15 13:47:47',NULL,'[]'),(193,'DUMMY',193,'0193',193,NULL,8402.0000,8402.0000,25.0000,11500.0000,11500.0000,'2025-04-15 13:47:47','2025-04-15 13:47:47',NULL,'[]'),(194,'DUMMY',194,'0194',194,NULL,6284.0000,6284.0000,25.0000,9000.0000,9000.0000,'2025-04-15 13:47:48','2025-04-15 13:47:48',NULL,'[]'),(195,'DUMMY',195,'0195',195,NULL,8000.0000,8000.0000,25.0000,13000.0000,13000.0000,'2025-04-15 13:47:49','2025-04-15 13:47:49',NULL,'[]'),(196,'DUMMY',196,'0196',196,NULL,2431.0000,2431.0000,25.0000,4000.0000,4000.0000,'2025-04-15 13:47:49','2025-04-15 13:47:49',NULL,'[]'),(197,'DUMMY',197,'0197',197,NULL,28000.0000,28000.0000,25.0000,55000.0000,55000.0000,'2025-04-15 13:47:50','2025-04-15 13:47:50',NULL,'[]'),(198,'DUMMY',198,'0198',198,NULL,16677.0000,16677.0000,25.0000,26000.0000,26000.0000,'2025-04-15 13:47:50','2025-04-15 13:47:50',NULL,'[]'),(199,'DUMMY',199,'0199',199,NULL,23000.0000,23000.0000,25.0000,38000.0000,38000.0000,'2025-04-15 13:47:50','2025-04-15 13:47:50',NULL,'[]'),(200,'DUMMY',200,'0200',200,NULL,8470.0000,8470.0000,25.0000,15000.0000,15000.0000,'2025-04-15 13:47:51','2025-04-15 13:47:51',NULL,'[]'),(201,'DUMMY',201,'0201',201,NULL,19000.0000,19000.0000,25.0000,35000.0000,35000.0000,'2025-04-15 13:47:51','2025-04-15 13:47:51',NULL,'[]'),(202,'DUMMY',202,'0202',202,NULL,34000.0000,34000.0000,25.0000,48000.0000,48000.0000,'2025-04-15 13:47:51','2025-04-15 13:47:51',NULL,'[]'),(203,'DUMMY',203,'0203',203,NULL,45000.0000,45000.0000,25.0000,60000.0000,60000.0000,'2025-04-15 13:47:52','2025-04-15 13:47:52',NULL,'[]'),(204,'DUMMY',204,'0204',204,NULL,66000.0000,66000.0000,25.0000,100000.0000,100000.0000,'2025-04-15 13:47:52','2025-04-15 13:47:52',NULL,'[]'),(205,'DUMMY',205,'0205',205,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2025-04-17 14:13:35','2025-04-17 14:36:04',NULL,'[]'),(206,'DUMMY',206,'0206',206,NULL,14000.0000,14000.0000,57.1429,22000.0000,22000.0000,'2025-04-18 08:10:15','2025-04-18 08:48:36',NULL,'[]'),(207,'DUMMY',207,'0207',207,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2025-04-18 08:18:22','2025-04-18 08:18:22',NULL,'[]'),(208,'DUMMY',208,'0208',208,NULL,31600.0000,31600.0000,17.0886,37000.0000,37000.0000,'2025-04-18 09:36:16','2025-04-18 09:44:03',NULL,'[]'),(209,'DUMMY',209,'0209',209,NULL,3300.0000,3300.0000,36.3636,4500.0000,4500.0000,'2025-04-18 13:05:50','2025-04-18 13:18:37',NULL,'[]'),(210,'DUMMY',210,'0210',210,NULL,30000.0000,30000.0000,13.3333,34000.0000,34000.0000,'2025-04-18 13:08:54','2025-04-18 13:27:31',NULL,'[]'),(211,'DUMMY',211,'0211',211,NULL,12000.0000,12000.0000,25.0000,15000.0000,15000.0000,'2025-04-18 19:46:51','2025-04-18 19:46:51',NULL,'[]'),(212,'DUMMY',212,'0212',212,NULL,19000.0000,19000.0000,15.7895,22000.0000,22000.0000,'2025-04-19 13:38:00','2025-04-19 13:43:30',NULL,'[]'),(213,'DUMMY',213,'0213',213,NULL,4500.0000,4500.0000,55.5556,7000.0000,7000.0000,'2025-04-21 09:07:25','2025-04-21 09:10:09',NULL,'[]'),(214,'DUMMY',214,'0214',214,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2025-04-23 13:06:33','2025-04-23 13:06:33',NULL,'[]'),(215,'DUMMY',215,'0215',215,NULL,750.0000,750.0000,133.3333,1750.0000,1750.0000,'2025-04-23 13:08:15','2025-04-23 13:11:32',NULL,'[]');
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warranties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `duration_type` enum('days','months','years') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warranties_business_id_index` (`business_id`),
  KEY `warranties_duration_type_index` (`duration_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warranties` WRITE;
/*!40000 ALTER TABLE `warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `warranties` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

